/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.AutoValue_SurfaceConfig;
import androidx.camera.core.impl.SurfaceSizeDefinition;
import androidx.camera.core.internal.utils.SizeUtil;
import com.google.auto.value.AutoValue;

@RequiresApi(value=21)
@AutoValue
public abstract class SurfaceConfig {
    SurfaceConfig() {
    }

    @NonNull
    public static SurfaceConfig create(@NonNull ConfigType type, @NonNull ConfigSize size) {
        return new AutoValue_SurfaceConfig(type, size);
    }

    @NonNull
    public abstract ConfigType getConfigType();

    @NonNull
    public abstract ConfigSize getConfigSize();

    public final boolean isSupported(@NonNull SurfaceConfig surfaceConfig) {
        boolean isSupported = false;
        ConfigType configType = surfaceConfig.getConfigType();
        ConfigSize configSize = surfaceConfig.getConfigSize();
        if (configSize.getId() <= this.getConfigSize().getId() && configType == this.getConfigType()) {
            isSupported = true;
        }
        return isSupported;
    }

    @NonNull
    public static ConfigType getConfigType(int imageFormat) {
        if (imageFormat == 35) {
            return ConfigType.YUV;
        }
        if (imageFormat == 256) {
            return ConfigType.JPEG;
        }
        if (imageFormat == 32) {
            return ConfigType.RAW;
        }
        return ConfigType.PRIV;
    }

    @NonNull
    public static SurfaceConfig transformSurfaceConfig(int imageFormat, @NonNull Size size, @NonNull SurfaceSizeDefinition surfaceSizeDefinition) {
        ConfigType configType = SurfaceConfig.getConfigType(imageFormat);
        ConfigSize configSize = ConfigSize.NOT_SUPPORT;
        int sizeArea = SizeUtil.getArea(size);
        configSize = sizeArea <= SizeUtil.getArea(surfaceSizeDefinition.getAnalysisSize()) ? ConfigSize.VGA : (sizeArea <= SizeUtil.getArea(surfaceSizeDefinition.getPreviewSize()) ? ConfigSize.PREVIEW : (sizeArea <= SizeUtil.getArea(surfaceSizeDefinition.getRecordSize()) ? ConfigSize.RECORD : ConfigSize.MAXIMUM));
        return SurfaceConfig.create(configType, configSize);
    }

    public static enum ConfigSize {
        VGA(0),
        PREVIEW(1),
        RECORD(2),
        MAXIMUM(3),
        NOT_SUPPORT(4);

        final int mId;

        private ConfigSize(int id) {
            this.mId = id;
        }

        int getId() {
            return this.mId;
        }
    }

    public static enum ConfigType {
        PRIV,
        YUV,
        JPEG,
        RAW;

    }
}

