/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.graphics.Matrix;
import android.graphics.Rect;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.imagecapture.TakePictureCallback;
import androidx.camera.core.impl.CaptureBundle;
import androidx.camera.core.impl.CaptureStage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@RequiresApi(api=21)
class ProcessingRequest {
    @Nullable
    private final ImageCapture.OutputFileOptions mOutputFileOptions;
    @NonNull
    private final Rect mCropRect;
    private final int mRotationDegrees;
    private final int mJpegQuality;
    @NonNull
    private final Matrix mSensorToBufferTransform;
    @NonNull
    private final TakePictureCallback mCallback;
    @NonNull
    private final String mTagBundleKey;
    @NonNull
    private final List<Integer> mStageIds;

    ProcessingRequest(@NonNull CaptureBundle captureBundle, @Nullable ImageCapture.OutputFileOptions outputFileOptions, @NonNull Rect cropRect, int rotationDegrees, int jpegQuality, @NonNull Matrix sensorToBufferTransform, @NonNull TakePictureCallback callback) {
        this.mOutputFileOptions = outputFileOptions;
        this.mJpegQuality = jpegQuality;
        this.mRotationDegrees = rotationDegrees;
        this.mCropRect = cropRect;
        this.mSensorToBufferTransform = sensorToBufferTransform;
        this.mCallback = callback;
        this.mTagBundleKey = String.valueOf(captureBundle.hashCode());
        this.mStageIds = new ArrayList<Integer>();
        for (CaptureStage captureStage : Objects.requireNonNull(captureBundle.getCaptureStages())) {
            this.mStageIds.add(captureStage.getId());
        }
    }

    @NonNull
    String getTagBundleKey() {
        return this.mTagBundleKey;
    }

    @NonNull
    List<Integer> getStageIds() {
        return this.mStageIds;
    }

    @Nullable
    ImageCapture.OutputFileOptions getOutputFileOptions() {
        return this.mOutputFileOptions;
    }

    @NonNull
    Rect getCropRect() {
        return this.mCropRect;
    }

    int getRotationDegrees() {
        return this.mRotationDegrees;
    }

    int getJpegQuality() {
        return this.mJpegQuality;
    }

    @NonNull
    Matrix getSensorToBufferTransform() {
        return this.mSensorToBufferTransform;
    }

    boolean isInMemoryCapture() {
        return this.getOutputFileOptions() == null;
    }

    @MainThread
    void onImageCaptured() {
        this.mCallback.onImageCaptured();
    }

    @MainThread
    void onFinalResult(@NonNull ImageCapture.OutputFileResults outputFileResults) {
        this.mCallback.onFinalResult(outputFileResults);
    }

    @MainThread
    void onFinalResult(@NonNull ImageProxy imageProxy) {
        this.mCallback.onFinalResult(imageProxy);
    }

    @MainThread
    void onProcessFailure(@NonNull ImageCaptureException imageCaptureException) {
        this.mCallback.onProcessFailure(imageCaptureException);
    }

    boolean isAborted() {
        return this.mCallback.isAborted();
    }
}

