/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Pair;
import android.util.Size;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ProcessingSurface;
import androidx.camera.core.ResolutionInfo;
import androidx.camera.core.SurfaceOutput;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.CaptureStage;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageInfoProcessor;
import androidx.camera.core.impl.ImageInputConfig;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.PreviewConfig;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.CameraCaptureResultImageInfo;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.ThreadConfig;
import androidx.camera.core.processing.SettableSurface;
import androidx.camera.core.processing.SurfaceEdge;
import androidx.camera.core.processing.SurfaceProcessorInternal;
import androidx.camera.core.processing.SurfaceProcessorNode;
import androidx.core.util.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public final class Preview
extends UseCase {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Defaults DEFAULT_CONFIG = new Defaults();
    private static final String TAG = "Preview";
    private static final Executor DEFAULT_SURFACE_PROVIDER_EXECUTOR = CameraXExecutors.mainThreadExecutor();
    @Nullable
    private SurfaceProvider mSurfaceProvider;
    @NonNull
    private Executor mSurfaceProviderExecutor = DEFAULT_SURFACE_PROVIDER_EXECUTOR;
    private DeferrableSurface mSessionDeferrableSurface;
    @VisibleForTesting
    @Nullable
    SurfaceRequest mCurrentSurfaceRequest;
    @Nullable
    private Size mSurfaceSize;
    @Nullable
    private SurfaceProcessorInternal mSurfaceProcessor;
    @Nullable
    private SurfaceProcessorNode mNode;

    @MainThread
    Preview(@NonNull PreviewConfig config) {
        super(config);
    }

    @MainThread
    SessionConfig.Builder createPipeline(@NonNull String cameraId, @NonNull PreviewConfig config, @NonNull Size resolution) {
        SurfaceRequest surfaceRequest;
        if (this.mSurfaceProcessor != null) {
            return this.createPipelineWithNode(cameraId, config, resolution);
        }
        Threads.checkMainThread();
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.Builder.createFrom(config);
        CaptureProcessor captureProcessor = config.getCaptureProcessor(null);
        this.clearPipeline();
        boolean isRGBA8888SurfaceRequired = config.isRgba8888SurfaceRequired(false);
        this.mCurrentSurfaceRequest = surfaceRequest = new SurfaceRequest(resolution, this.getCamera(), isRGBA8888SurfaceRequired);
        if (this.mSurfaceProvider != null) {
            this.sendSurfaceRequest();
        }
        if (captureProcessor != null) {
            CaptureStage.DefaultCaptureStage captureStage = new CaptureStage.DefaultCaptureStage();
            HandlerThread handlerThread = new HandlerThread("CameraX-preview_processing");
            handlerThread.start();
            String tagBundleKey = Integer.toString(captureStage.hashCode());
            ProcessingSurface processingSurface = new ProcessingSurface(resolution.getWidth(), resolution.getHeight(), config.getInputFormat(), new Handler(handlerThread.getLooper()), captureStage, captureProcessor, surfaceRequest.getDeferrableSurface(), tagBundleKey);
            sessionConfigBuilder.addCameraCaptureCallback(processingSurface.getCameraCaptureCallback());
            processingSurface.getTerminationFuture().addListener(() -> ((HandlerThread)handlerThread).quitSafely(), CameraXExecutors.directExecutor());
            this.mSessionDeferrableSurface = processingSurface;
            sessionConfigBuilder.addTag(tagBundleKey, captureStage.getId());
        } else {
            final ImageInfoProcessor processor = config.getImageInfoProcessor(null);
            if (processor != null) {
                sessionConfigBuilder.addCameraCaptureCallback(new CameraCaptureCallback(){

                    @Override
                    public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
                        super.onCaptureCompleted(cameraCaptureResult);
                        if (processor.process(new CameraCaptureResultImageInfo(cameraCaptureResult))) {
                            Preview.this.notifyUpdated();
                        }
                    }
                });
            }
            this.mSessionDeferrableSurface = surfaceRequest.getDeferrableSurface();
        }
        this.addCameraSurfaceAndErrorListener(sessionConfigBuilder, cameraId, config, resolution);
        return sessionConfigBuilder;
    }

    @NonNull
    @MainThread
    private SessionConfig.Builder createPipelineWithNode(@NonNull String cameraId, @NonNull PreviewConfig config, @NonNull Size resolution) {
        Threads.checkMainThread();
        Preconditions.checkNotNull((Object)this.mSurfaceProcessor);
        CameraInternal camera = this.getCamera();
        Preconditions.checkNotNull((Object)camera);
        this.clearPipeline();
        this.mNode = new SurfaceProcessorNode(camera, SurfaceOutput.GlTransformOptions.USE_SURFACE_TEXTURE_TRANSFORM, this.mSurfaceProcessor);
        SettableSurface cameraSurface = new SettableSurface(1, resolution, 34, new Matrix(), true, Objects.requireNonNull(this.getCropRect(resolution)), this.getRelativeRotation(camera), false);
        SurfaceEdge inputEdge = SurfaceEdge.create(Collections.singletonList(cameraSurface));
        SurfaceEdge outputEdge = this.mNode.transform(inputEdge);
        SettableSurface appSurface = outputEdge.getSurfaces().get(0);
        this.mSessionDeferrableSurface = cameraSurface;
        this.mCurrentSurfaceRequest = appSurface.createSurfaceRequest(camera);
        if (this.mSurfaceProvider != null) {
            this.sendSurfaceRequest();
        }
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.Builder.createFrom(config);
        this.addCameraSurfaceAndErrorListener(sessionConfigBuilder, cameraId, config, resolution);
        return sessionConfigBuilder;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setProcessor(@Nullable SurfaceProcessorInternal surfaceProcessor) {
        this.mSurfaceProcessor = surfaceProcessor;
    }

    @Nullable
    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SurfaceProcessorInternal getProcessor() {
        return this.mSurfaceProcessor;
    }

    private void clearPipeline() {
        SurfaceProcessorNode node;
        DeferrableSurface cameraSurface = this.mSessionDeferrableSurface;
        if (cameraSurface != null) {
            cameraSurface.close();
            this.mSessionDeferrableSurface = null;
        }
        if ((node = this.mNode) != null) {
            node.release();
            this.mNode = null;
        }
        this.mCurrentSurfaceRequest = null;
    }

    private void addCameraSurfaceAndErrorListener(@NonNull SessionConfig.Builder sessionConfigBuilder, @NonNull String cameraId, @NonNull PreviewConfig config, @NonNull Size resolution) {
        if (this.mSurfaceProvider != null) {
            sessionConfigBuilder.addSurface(this.mSessionDeferrableSurface);
        }
        sessionConfigBuilder.addErrorListener((sessionConfig, error) -> {
            if (this.isCurrentCamera(cameraId)) {
                SessionConfig.Builder sessionConfigBuilder1 = this.createPipeline(cameraId, config, resolution);
                this.updateSessionConfig(sessionConfigBuilder1.build());
                this.notifyReset();
            }
        });
    }

    public void setTargetRotation(int targetRotation) {
        if (this.setTargetRotationInternal(targetRotation)) {
            this.sendTransformationInfoIfReady();
        }
    }

    private void sendTransformationInfoIfReady() {
        CameraInternal cameraInternal = this.getCamera();
        SurfaceProvider surfaceProvider = this.mSurfaceProvider;
        Rect cropRect = this.getCropRect(this.mSurfaceSize);
        SurfaceRequest surfaceRequest = this.mCurrentSurfaceRequest;
        if (cameraInternal != null && surfaceProvider != null && cropRect != null && surfaceRequest != null) {
            surfaceRequest.updateTransformationInfo(SurfaceRequest.TransformationInfo.of(cropRect, this.getRelativeRotation(cameraInternal), this.getAppTargetRotation()));
        }
    }

    @Nullable
    private Rect getCropRect(@Nullable Size surfaceResolution) {
        if (this.getViewPortCropRect() != null) {
            return this.getViewPortCropRect();
        }
        if (surfaceResolution != null) {
            return new Rect(0, 0, surfaceResolution.getWidth(), surfaceResolution.getHeight());
        }
        return null;
    }

    @UiThread
    public void setSurfaceProvider(@NonNull Executor executor, @Nullable SurfaceProvider surfaceProvider) {
        Threads.checkMainThread();
        if (surfaceProvider == null) {
            this.mSurfaceProvider = null;
            this.notifyInactive();
        } else {
            this.mSurfaceProvider = surfaceProvider;
            this.mSurfaceProviderExecutor = executor;
            this.notifyActive();
            if (this.getAttachedSurfaceResolution() != null) {
                this.updateConfigAndOutput(this.getCameraId(), (PreviewConfig)this.getCurrentConfig(), this.getAttachedSurfaceResolution());
                this.notifyReset();
            }
        }
    }

    private void sendSurfaceRequest() {
        SurfaceProvider surfaceProvider = (SurfaceProvider)Preconditions.checkNotNull((Object)this.mSurfaceProvider);
        SurfaceRequest surfaceRequest = (SurfaceRequest)Preconditions.checkNotNull((Object)this.mCurrentSurfaceRequest);
        this.mSurfaceProviderExecutor.execute(() -> surfaceProvider.onSurfaceRequested(surfaceRequest));
        this.sendTransformationInfoIfReady();
    }

    @UiThread
    public void setSurfaceProvider(@Nullable SurfaceProvider surfaceProvider) {
        this.setSurfaceProvider(DEFAULT_SURFACE_PROVIDER_EXECUTOR, surfaceProvider);
    }

    private void updateConfigAndOutput(@NonNull String cameraId, @NonNull PreviewConfig config, @NonNull Size resolution) {
        this.updateSessionConfig(this.createPipeline(cameraId, config, resolution).build());
    }

    public int getTargetRotation() {
        return this.getTargetRotationInternal();
    }

    @Override
    @Nullable
    public ResolutionInfo getResolutionInfo() {
        return super.getResolutionInfo();
    }

    @NonNull
    public String toString() {
        return "Preview:" + this.getName();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public UseCaseConfig<?> getDefaultConfig(boolean applyDefaultConfig, @NonNull UseCaseConfigFactory factory) {
        Config captureConfig = factory.getConfig(UseCaseConfigFactory.CaptureType.PREVIEW, 1);
        if (applyDefaultConfig) {
            captureConfig = Config.mergeConfigs(captureConfig, DEFAULT_CONFIG.getConfig());
        }
        return captureConfig == null ? null : (UseCaseConfig<?>)this.getUseCaseConfigBuilder(captureConfig).getUseCaseConfig();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected UseCaseConfig<?> onMergeConfig(@NonNull CameraInfoInternal cameraInfo, @NonNull UseCaseConfig.Builder<?, ?, ?> builder) {
        if (builder.getMutableConfig().retrieveOption(PreviewConfig.OPTION_PREVIEW_CAPTURE_PROCESSOR, null) != null) {
            builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 35);
        } else {
            builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 34);
        }
        return builder.getUseCaseConfig();
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public UseCaseConfig.Builder<?, ?, ?> getUseCaseConfigBuilder(@NonNull Config config) {
        return Builder.fromConfig(config);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onDetached() {
        this.clearPipeline();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected Size onSuggestedResolutionUpdated(@NonNull Size suggestedResolution) {
        this.mSurfaceSize = suggestedResolution;
        this.updateConfigAndOutput(this.getCameraId(), (PreviewConfig)this.getCurrentConfig(), this.mSurfaceSize);
        return suggestedResolution;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setViewPortCropRect(@NonNull Rect viewPortCropRect) {
        super.setViewPortCropRect(viewPortCropRect);
        this.sendTransformationInfoIfReady();
    }

    public static final class Builder
    implements UseCaseConfig.Builder<Preview, PreviewConfig, Builder>,
    ImageOutputConfig.Builder<Builder>,
    ThreadConfig.Builder<Builder> {
        private final MutableOptionsBundle mMutableConfig;

        public Builder() {
            this(MutableOptionsBundle.create());
        }

        private Builder(MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            Class oldConfigClass = mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(Preview.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setTargetClass((Class)Preview.class);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        static Builder fromConfig(@NonNull Config configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static Builder fromConfig(@NonNull PreviewConfig configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PreviewConfig getUseCaseConfig() {
            return new PreviewConfig(OptionsBundle.from(this.mMutableConfig));
        }

        @Override
        @NonNull
        public Preview build() {
            if (this.getMutableConfig().retrieveOption(PreviewConfig.OPTION_TARGET_ASPECT_RATIO, null) != null && this.getMutableConfig().retrieveOption(PreviewConfig.OPTION_TARGET_RESOLUTION, null) != null) {
                throw new IllegalArgumentException("Cannot use both setTargetResolution and setTargetAspectRatio on the same config.");
            }
            return new Preview(this.getUseCaseConfig());
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setTargetClass(@NonNull Class<Preview> targetClass) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(PreviewConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_NAME, targetName);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetAspectRatio(int aspectRatio) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_ASPECT_RATIO, aspectRatio);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetRotation(int rotation) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_ROTATION, rotation);
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_APP_TARGET_ROTATION, rotation);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setDefaultResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_DEFAULT_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setMaxResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_MAX_RESOLUTION, resolution);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> resolutions) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_SUPPORTED_RESOLUTIONS, resolutions);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setBackgroundExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_BACKGROUND_EXECUTOR, executor);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_DEFAULT_SESSION_CONFIG, sessionConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_DEFAULT_CAPTURE_CONFIG, captureConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_SESSION_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_CAPTURE_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSurfaceOccupancyPriority(int priority) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, priority);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCameraSelector(@NonNull CameraSelector cameraSelector) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAMERA_SELECTOR, cameraSelector);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setUseCaseEventCallback(@NonNull UseCase.EventCallback useCaseEventCallback) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_USE_CASE_EVENT_CALLBACK, useCaseEventCallback);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setIsRgba8888SurfaceRequired(boolean isRgba8888SurfaceRequired) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_RGBA8888_SURFACE_REQUIRED, isRgba8888SurfaceRequired);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setImageInfoProcessor(@NonNull ImageInfoProcessor processor) {
            this.getMutableConfig().insertOption(PreviewConfig.IMAGE_INFO_PROCESSOR, processor);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureProcessor(@NonNull CaptureProcessor captureProcessor) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_PREVIEW_CAPTURE_PROCESSOR, captureProcessor);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setZslDisabled(boolean disabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_ZSL_DISABLED, disabled);
            return this;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Defaults
    implements ConfigProvider<PreviewConfig> {
        private static final int DEFAULT_SURFACE_OCCUPANCY_PRIORITY = 2;
        private static final int DEFAULT_ASPECT_RATIO = 0;
        private static final PreviewConfig DEFAULT_CONFIG;

        @Override
        @NonNull
        public PreviewConfig getConfig() {
            return DEFAULT_CONFIG;
        }

        static {
            Builder builder = new Builder().setSurfaceOccupancyPriority(2).setTargetAspectRatio(0);
            DEFAULT_CONFIG = builder.getUseCaseConfig();
        }
    }

    public static interface SurfaceProvider {
        public void onSurfaceRequested(@NonNull SurfaceRequest var1);
    }
}

