/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.PointF;
import android.util.Rational;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.MeteringPoint;

@RequiresApi(value=21)
public abstract class MeteringPointFactory {
    @Nullable
    private Rational mSurfaceAspectRatio;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MeteringPointFactory() {
        this(null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MeteringPointFactory(@Nullable Rational surfaceAspectRatio) {
        this.mSurfaceAspectRatio = surfaceAspectRatio;
    }

    public static float getDefaultPointSize() {
        return 0.15f;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected abstract PointF convertPoint(float var1, float var2);

    @NonNull
    public final MeteringPoint createPoint(float x, float y) {
        return this.createPoint(x, y, MeteringPointFactory.getDefaultPointSize());
    }

    @NonNull
    public final MeteringPoint createPoint(float x, float y, float size) {
        PointF convertedPoint = this.convertPoint(x, y);
        return new MeteringPoint(convertedPoint.x, convertedPoint.y, size, this.mSurfaceAspectRatio);
    }
}

