/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.Rect;
import android.media.Image;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import java.util.HashSet;
import java.util.Set;

@RequiresApi(value=21)
abstract class ForwardingImageProxy
implements ImageProxy {
    @GuardedBy(value="this")
    protected final ImageProxy mImage;
    @GuardedBy(value="this")
    private final Set<OnImageCloseListener> mOnImageCloseListeners = new HashSet<OnImageCloseListener>();

    protected ForwardingImageProxy(ImageProxy image) {
        this.mImage = image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ForwardingImageProxy forwardingImageProxy = this;
        synchronized (forwardingImageProxy) {
            this.mImage.close();
        }
        this.notifyOnImageCloseListeners();
    }

    @Override
    @NonNull
    public synchronized Rect getCropRect() {
        return this.mImage.getCropRect();
    }

    @Override
    public synchronized void setCropRect(@Nullable Rect rect) {
        this.mImage.setCropRect(rect);
    }

    @Override
    public synchronized int getFormat() {
        return this.mImage.getFormat();
    }

    @Override
    public synchronized int getHeight() {
        return this.mImage.getHeight();
    }

    @Override
    public synchronized int getWidth() {
        return this.mImage.getWidth();
    }

    @Override
    @NonNull
    public synchronized ImageProxy.PlaneProxy[] getPlanes() {
        return this.mImage.getPlanes();
    }

    @Override
    @NonNull
    public synchronized ImageInfo getImageInfo() {
        return this.mImage.getImageInfo();
    }

    @Override
    @ExperimentalGetImage
    public synchronized Image getImage() {
        return this.mImage.getImage();
    }

    synchronized void addOnImageCloseListener(OnImageCloseListener listener) {
        this.mOnImageCloseListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyOnImageCloseListeners() {
        HashSet<OnImageCloseListener> onImageCloseListeners;
        ForwardingImageProxy forwardingImageProxy = this;
        synchronized (forwardingImageProxy) {
            onImageCloseListeners = new HashSet<OnImageCloseListener>(this.mOnImageCloseListeners);
        }
        for (OnImageCloseListener listener : onImageCloseListeners) {
            listener.onImageClose(this);
        }
    }

    static interface OnImageCloseListener {
        public void onImageClose(ImageProxy var1);
    }
}

