/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.Rect;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.camera.core.ResolutionInfo;

final class AutoValue_ResolutionInfo
extends ResolutionInfo {
    private final Size resolution;
    private final Rect cropRect;
    private final int rotationDegrees;

    AutoValue_ResolutionInfo(Size resolution, Rect cropRect, int rotationDegrees) {
        if (resolution == null) {
            throw new NullPointerException("Null resolution");
        }
        this.resolution = resolution;
        if (cropRect == null) {
            throw new NullPointerException("Null cropRect");
        }
        this.cropRect = cropRect;
        this.rotationDegrees = rotationDegrees;
    }

    @Override
    @NonNull
    public Size getResolution() {
        return this.resolution;
    }

    @Override
    @NonNull
    public Rect getCropRect() {
        return this.cropRect;
    }

    @Override
    public int getRotationDegrees() {
        return this.rotationDegrees;
    }

    public String toString() {
        return "ResolutionInfo{resolution=" + this.resolution + ", cropRect=" + this.cropRect + ", rotationDegrees=" + this.rotationDegrees + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ResolutionInfo) {
            ResolutionInfo that = (ResolutionInfo)o;
            return this.resolution.equals((Object)that.getResolution()) && this.cropRect.equals((Object)that.getCropRect()) && this.rotationDegrees == that.getRotationDegrees();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.resolution.hashCode();
        h$ *= 1000003;
        h$ ^= this.cropRect.hashCode();
        h$ *= 1000003;
        return h$ ^= this.rotationDegrees;
    }
}

