/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.quirk;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.camera.core.impl.Quirk;
import androidx.camera.core.impl.SurfaceCombination;
import androidx.camera.core.impl.SurfaceConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ExtraSupportedSurfaceCombinationsQuirk
implements Quirk {
    private static final String TAG = "ExtraSupportedSurfaceCombinationsQuirk";
    private static final SurfaceCombination FULL_LEVEL_YUV_PRIV_YUV_CONFIGURATION = ExtraSupportedSurfaceCombinationsQuirk.createFullYuvPrivYuvConfiguration();
    private static final SurfaceCombination LEVEL_3_LEVEL_PRIV_PRIV_YUV_SUBSET_CONFIGURATION = ExtraSupportedSurfaceCombinationsQuirk.createLevel3PrivPrivYuvSubsetConfiguration();
    private static final Set<String> SUPPORT_EXTRA_LEVEL_3_CONFIGURATIONS_GOOGLE_MODELS = new HashSet<String>(Arrays.asList("PIXEL 6", "PIXEL 6 PRO", "PIXEL 7", "PIXEL 7 PRO", "PIXEL 8", "PIXEL 8 PRO"));
    private static final Set<String> SUPPORT_EXTRA_LEVEL_3_CONFIGURATIONS_SAMSUNG_MODELS = new HashSet<String>(Arrays.asList("SM-S921", "SC-51E", "SCG25", "SM-S926", "SM-S928", "SC-52E", "SCG26"));

    static boolean load() {
        return ExtraSupportedSurfaceCombinationsQuirk.isSamsungS7() || ExtraSupportedSurfaceCombinationsQuirk.supportExtraLevel3ConfigurationsGoogleDevice() || ExtraSupportedSurfaceCombinationsQuirk.supportExtraLevel3ConfigurationsSamsungDevice();
    }

    private static boolean isSamsungS7() {
        return "heroqltevzw".equalsIgnoreCase(Build.DEVICE) || "heroqltetmo".equalsIgnoreCase(Build.DEVICE);
    }

    private static boolean supportExtraLevel3ConfigurationsGoogleDevice() {
        if (!"google".equalsIgnoreCase(Build.BRAND)) {
            return false;
        }
        String capitalModelName = Build.MODEL.toUpperCase(Locale.US);
        return SUPPORT_EXTRA_LEVEL_3_CONFIGURATIONS_GOOGLE_MODELS.contains(capitalModelName);
    }

    private static boolean supportExtraLevel3ConfigurationsSamsungDevice() {
        if (!"samsung".equalsIgnoreCase(Build.BRAND)) {
            return false;
        }
        String capitalModelName = Build.MODEL.toUpperCase(Locale.US);
        for (String supportedModel : SUPPORT_EXTRA_LEVEL_3_CONFIGURATIONS_SAMSUNG_MODELS) {
            if (!capitalModelName.startsWith(supportedModel)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public List<SurfaceCombination> getExtraSupportedSurfaceCombinations(@NonNull String cameraId) {
        if (ExtraSupportedSurfaceCombinationsQuirk.isSamsungS7()) {
            return this.getSamsungS7ExtraCombinations(cameraId);
        }
        if (ExtraSupportedSurfaceCombinationsQuirk.supportExtraLevel3ConfigurationsGoogleDevice() || ExtraSupportedSurfaceCombinationsQuirk.supportExtraLevel3ConfigurationsSamsungDevice()) {
            return Collections.singletonList(LEVEL_3_LEVEL_PRIV_PRIV_YUV_SUBSET_CONFIGURATION);
        }
        return Collections.emptyList();
    }

    @NonNull
    private List<SurfaceCombination> getSamsungS7ExtraCombinations(@NonNull String cameraId) {
        ArrayList<SurfaceCombination> extraCombinations = new ArrayList<SurfaceCombination>();
        if (cameraId.equals("1")) {
            extraCombinations.add(FULL_LEVEL_YUV_PRIV_YUV_CONFIGURATION);
        }
        return extraCombinations;
    }

    @NonNull
    private static SurfaceCombination createFullYuvPrivYuvConfiguration() {
        SurfaceCombination surfaceCombination = new SurfaceCombination();
        surfaceCombination.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.VGA));
        surfaceCombination.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        return surfaceCombination;
    }

    private static SurfaceCombination createLevel3PrivPrivYuvSubsetConfiguration() {
        SurfaceCombination surfaceCombination = new SurfaceCombination();
        surfaceCombination.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.VGA));
        surfaceCombination.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        return surfaceCombination;
    }
}

