/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.annotation.SuppressLint;
import android.hardware.camera2.CameraCharacteristics;
import android.os.Build;
import android.util.Pair;
import android.util.Range;
import android.util.Size;
import androidx.annotation.FloatRange;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.camera.camera2.internal.Camera2CameraControlImpl;
import androidx.camera.camera2.internal.Camera2EncoderProfilesProvider;
import androidx.camera.camera2.internal.Camera2PhysicalCameraInfoImpl;
import androidx.camera.camera2.internal.ExposureControl;
import androidx.camera.camera2.internal.FovUtil;
import androidx.camera.camera2.internal.LensFacingUtil;
import androidx.camera.camera2.internal.ZoomControl;
import androidx.camera.camera2.internal.ZslUtil;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.camera2.internal.compat.StreamConfigurationMapCompat;
import androidx.camera.camera2.internal.compat.params.DynamicRangesCompat;
import androidx.camera.camera2.internal.compat.quirk.CameraQuirks;
import androidx.camera.camera2.internal.compat.quirk.DeviceQuirks;
import androidx.camera.camera2.internal.compat.quirk.ZslDisablerQuirk;
import androidx.camera.camera2.internal.compat.workaround.FlashAvailabilityChecker;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraState;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.ExperimentalZeroShutterLag;
import androidx.camera.core.ExposureState;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.Logger;
import androidx.camera.core.ZoomState;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.DynamicRanges;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.Timebase;
import androidx.camera.core.impl.utils.CameraOrientationUtil;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.Observer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;

@OptIn(markerClass={ExperimentalCamera2Interop.class})
public final class Camera2CameraInfoImpl
implements CameraInfoInternal {
    private static final String TAG = "Camera2CameraInfo";
    private final String mCameraId;
    private final CameraCharacteristicsCompat mCameraCharacteristicsCompat;
    private final Camera2CameraInfo mCamera2CameraInfo;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    @Nullable
    private Camera2CameraControlImpl mCamera2CameraControlImpl;
    @GuardedBy(value="mLock")
    @Nullable
    private RedirectableLiveData<Integer> mRedirectTorchStateLiveData = null;
    @GuardedBy(value="mLock")
    @Nullable
    private RedirectableLiveData<ZoomState> mRedirectZoomStateLiveData = null;
    @NonNull
    private final RedirectableLiveData<CameraState> mCameraStateLiveData;
    @GuardedBy(value="mLock")
    @Nullable
    private List<Pair<CameraCaptureCallback, Executor>> mCameraCaptureCallbacks = null;
    @NonNull
    private final Quirks mCameraQuirks;
    @NonNull
    private final EncoderProfilesProvider mCamera2EncoderProfilesProvider;
    @NonNull
    private final CameraManagerCompat mCameraManager;
    @Nullable
    private Set<CameraInfo> mPhysicalCameraInfos;

    public Camera2CameraInfoImpl(@NonNull String cameraId, @NonNull CameraManagerCompat cameraManager) throws CameraAccessExceptionCompat {
        this.mCameraId = (String)Preconditions.checkNotNull((Object)cameraId);
        this.mCameraManager = cameraManager;
        this.mCameraCharacteristicsCompat = cameraManager.getCameraCharacteristicsCompat(this.mCameraId);
        this.mCamera2CameraInfo = new Camera2CameraInfo(this);
        this.mCameraQuirks = CameraQuirks.get(cameraId, this.mCameraCharacteristicsCompat);
        this.mCamera2EncoderProfilesProvider = new Camera2EncoderProfilesProvider(cameraId, this.mCameraQuirks);
        this.mCameraStateLiveData = new RedirectableLiveData<CameraState>(CameraState.create((CameraState.Type)CameraState.Type.CLOSED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void linkWithCameraControl(@NonNull Camera2CameraControlImpl camera2CameraControlImpl) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCamera2CameraControlImpl = camera2CameraControlImpl;
            if (this.mRedirectZoomStateLiveData != null) {
                this.mRedirectZoomStateLiveData.redirectTo(this.mCamera2CameraControlImpl.getZoomControl().getZoomState());
            }
            if (this.mRedirectTorchStateLiveData != null) {
                this.mRedirectTorchStateLiveData.redirectTo(this.mCamera2CameraControlImpl.getTorchControl().getTorchState());
            }
            if (this.mCameraCaptureCallbacks != null) {
                for (Pair<CameraCaptureCallback, Executor> pair : this.mCameraCaptureCallbacks) {
                    this.mCamera2CameraControlImpl.addSessionCameraCaptureCallback((Executor)pair.second, (CameraCaptureCallback)pair.first);
                }
                this.mCameraCaptureCallbacks = null;
            }
        }
        this.logDeviceInfo();
    }

    void setCameraStateSource(@NonNull LiveData<CameraState> cameraStateSource) {
        this.mCameraStateLiveData.redirectTo(cameraStateSource);
    }

    @NonNull
    public String getCameraId() {
        return this.mCameraId;
    }

    @NonNull
    public CameraCharacteristicsCompat getCameraCharacteristicsCompat() {
        return this.mCameraCharacteristicsCompat;
    }

    public int getLensFacing() {
        Integer lensFacing = (Integer)this.mCameraCharacteristicsCompat.get(CameraCharacteristics.LENS_FACING);
        Preconditions.checkArgument((lensFacing != null ? 1 : 0) != 0, (Object)"Unable to get the lens facing of the camera.");
        return LensFacingUtil.getCameraSelectorLensFacing(lensFacing);
    }

    public int getSensorRotationDegrees(int relativeRotation) {
        int sensorOrientation = this.getSensorOrientation();
        int relativeRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees((int)relativeRotation);
        int lensFacing = this.getLensFacing();
        boolean isOppositeFacingScreen = 1 == lensFacing;
        return CameraOrientationUtil.getRelativeImageRotation((int)relativeRotationDegrees, (int)sensorOrientation, (boolean)isOppositeFacingScreen);
    }

    int getSensorOrientation() {
        Integer sensorOrientation = (Integer)this.mCameraCharacteristicsCompat.get(CameraCharacteristics.SENSOR_ORIENTATION);
        Preconditions.checkNotNull((Object)sensorOrientation);
        return sensorOrientation;
    }

    int getSupportedHardwareLevel() {
        Integer deviceLevel = (Integer)this.mCameraCharacteristicsCompat.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        Preconditions.checkNotNull((Object)deviceLevel);
        return deviceLevel;
    }

    public int getSensorRotationDegrees() {
        return this.getSensorRotationDegrees(0);
    }

    private void logDeviceInfo() {
        this.logDeviceLevel();
    }

    private void logDeviceLevel() {
        String levelString;
        int deviceLevel = this.getSupportedHardwareLevel();
        switch (deviceLevel) {
            case 2: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_LEGACY";
                break;
            }
            case 4: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_EXTERNAL";
                break;
            }
            case 0: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_LIMITED";
                break;
            }
            case 1: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_FULL";
                break;
            }
            case 3: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_3";
                break;
            }
            default: {
                levelString = "Unknown value: " + deviceLevel;
            }
        }
        Logger.i((String)TAG, (String)("Device Level: " + levelString));
    }

    public boolean hasFlashUnit() {
        return FlashAvailabilityChecker.isFlashAvailable(this.mCameraCharacteristicsCompat::get);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public LiveData<Integer> getTorchState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCamera2CameraControlImpl == null) {
                if (this.mRedirectTorchStateLiveData == null) {
                    this.mRedirectTorchStateLiveData = new RedirectableLiveData<Integer>(0);
                }
                return this.mRedirectTorchStateLiveData;
            }
            if (this.mRedirectTorchStateLiveData != null) {
                return this.mRedirectTorchStateLiveData;
            }
            return this.mCamera2CameraControlImpl.getTorchControl().getTorchState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public LiveData<ZoomState> getZoomState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCamera2CameraControlImpl == null) {
                if (this.mRedirectZoomStateLiveData == null) {
                    this.mRedirectZoomStateLiveData = new RedirectableLiveData<ZoomState>(ZoomControl.getDefaultZoomState(this.mCameraCharacteristicsCompat));
                }
                return this.mRedirectZoomStateLiveData;
            }
            if (this.mRedirectZoomStateLiveData != null) {
                return this.mRedirectZoomStateLiveData;
            }
            return this.mCamera2CameraControlImpl.getZoomControl().getZoomState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ExposureState getExposureState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCamera2CameraControlImpl == null) {
                return ExposureControl.getDefaultExposureState(this.mCameraCharacteristicsCompat);
            }
            return this.mCamera2CameraControlImpl.getExposureControl().getExposureState();
        }
    }

    @NonNull
    public LiveData<CameraState> getCameraState() {
        return this.mCameraStateLiveData;
    }

    @NonNull
    public String getImplementationType() {
        int hardwareLevel = this.getSupportedHardwareLevel();
        return hardwareLevel == 2 ? "androidx.camera.camera2.legacy" : "androidx.camera.camera2";
    }

    @FloatRange(from=0.0, fromInclusive=false)
    public float getIntrinsicZoomRatio() {
        int defaultFovDegrees;
        int fovDegrees;
        Integer lensFacing = (Integer)this.mCameraCharacteristicsCompat.get(CameraCharacteristics.LENS_FACING);
        if (lensFacing == null) {
            return 1.0f;
        }
        try {
            fovDegrees = FovUtil.focalLengthToViewAngleDegrees(FovUtil.getDefaultFocalLength(this.mCameraCharacteristicsCompat), FovUtil.getSensorHorizontalLength(this.mCameraCharacteristicsCompat));
            defaultFovDegrees = FovUtil.getDeviceDefaultViewAngleDegrees(this.mCameraManager, lensFacing);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("The camera is unable to provide necessary information to resolve its intrinsic zoom ratio with error: " + e));
            return 1.0f;
        }
        return (float)defaultFovDegrees / (float)fovDegrees;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFocusMeteringSupported(@NonNull FocusMeteringAction action) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCamera2CameraControlImpl == null) {
                return false;
            }
            return this.mCamera2CameraControlImpl.getFocusMeteringControl().isFocusMeteringSupported(action);
        }
    }

    @SuppressLint(value={"NullAnnotationGroup"})
    @OptIn(markerClass={ExperimentalZeroShutterLag.class})
    public boolean isZslSupported() {
        return Build.VERSION.SDK_INT >= 23 && this.isPrivateReprocessingSupported() && DeviceQuirks.get(ZslDisablerQuirk.class) == null;
    }

    public boolean isPrivateReprocessingSupported() {
        return ZslUtil.isCapabilitySupported(this.mCameraCharacteristicsCompat, 4);
    }

    public boolean isLogicalMultiCameraSupported() {
        return ZslUtil.isCapabilitySupported(this.mCameraCharacteristicsCompat, 11);
    }

    @NonNull
    public EncoderProfilesProvider getEncoderProfilesProvider() {
        return this.mCamera2EncoderProfilesProvider;
    }

    @NonNull
    public Timebase getTimebase() {
        Integer timeSource = (Integer)this.mCameraCharacteristicsCompat.get(CameraCharacteristics.SENSOR_INFO_TIMESTAMP_SOURCE);
        Preconditions.checkNotNull((Object)timeSource);
        switch (timeSource) {
            case 1: {
                return Timebase.REALTIME;
            }
        }
        return Timebase.UPTIME;
    }

    @NonNull
    public Set<Integer> getSupportedOutputFormats() {
        StreamConfigurationMapCompat mapCompat = this.mCameraCharacteristicsCompat.getStreamConfigurationMapCompat();
        int[] formats = mapCompat.getOutputFormats();
        if (formats == null) {
            return new HashSet<Integer>();
        }
        HashSet<Integer> result = new HashSet<Integer>();
        for (int format : formats) {
            result.add(format);
        }
        return result;
    }

    @NonNull
    public List<Size> getSupportedResolutions(int format) {
        StreamConfigurationMapCompat mapCompat = this.mCameraCharacteristicsCompat.getStreamConfigurationMapCompat();
        Size[] size = mapCompat.getOutputSizes(format);
        return size != null ? Arrays.asList(size) : Collections.emptyList();
    }

    @NonNull
    public List<Size> getSupportedHighResolutions(int format) {
        StreamConfigurationMapCompat mapCompat = this.mCameraCharacteristicsCompat.getStreamConfigurationMapCompat();
        Size[] size = mapCompat.getHighResolutionOutputSizes(format);
        return size != null ? Arrays.asList(size) : Collections.emptyList();
    }

    @NonNull
    public Set<DynamicRange> getSupportedDynamicRanges() {
        DynamicRangesCompat dynamicRangesCompat = DynamicRangesCompat.fromCameraCharacteristics(this.mCameraCharacteristicsCompat);
        return dynamicRangesCompat.getSupportedDynamicRanges();
    }

    @NonNull
    public Set<DynamicRange> querySupportedDynamicRanges(@NonNull Set<DynamicRange> candidateDynamicRanges) {
        return DynamicRanges.findAllPossibleMatches(candidateDynamicRanges, this.getSupportedDynamicRanges());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionCaptureCallback(@NonNull Executor executor, @NonNull CameraCaptureCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCamera2CameraControlImpl == null) {
                if (this.mCameraCaptureCallbacks == null) {
                    this.mCameraCaptureCallbacks = new ArrayList<Pair<CameraCaptureCallback, Executor>>();
                }
                this.mCameraCaptureCallbacks.add((Pair<CameraCaptureCallback, Executor>)new Pair((Object)callback, (Object)executor));
                return;
            }
            this.mCamera2CameraControlImpl.addSessionCameraCaptureCallback(executor, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionCaptureCallback(@NonNull CameraCaptureCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCamera2CameraControlImpl == null) {
                if (this.mCameraCaptureCallbacks == null) {
                    return;
                }
                Iterator<Pair<CameraCaptureCallback, Executor>> it = this.mCameraCaptureCallbacks.iterator();
                while (it.hasNext()) {
                    Pair<CameraCaptureCallback, Executor> pair = it.next();
                    if (pair.first != callback) continue;
                    it.remove();
                }
                return;
            }
            this.mCamera2CameraControlImpl.removeSessionCameraCaptureCallback(callback);
        }
    }

    @NonNull
    public Quirks getCameraQuirks() {
        return this.mCameraQuirks;
    }

    @NonNull
    public Set<Range<Integer>> getSupportedFrameRateRanges() {
        Range[] availableTargetFpsRanges = (Range[])this.mCameraCharacteristicsCompat.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        if (availableTargetFpsRanges != null) {
            return new HashSet<Range<Integer>>(Arrays.asList(availableTargetFpsRanges));
        }
        return Collections.emptySet();
    }

    public boolean isVideoStabilizationSupported() {
        int[] availableVideoStabilizationModes = (int[])this.mCameraCharacteristicsCompat.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES);
        if (availableVideoStabilizationModes != null) {
            for (int mode : availableVideoStabilizationModes) {
                if (mode != 1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPreviewStabilizationSupported() {
        int[] availableVideoStabilizationModes = (int[])this.mCameraCharacteristicsCompat.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES);
        if (availableVideoStabilizationModes != null) {
            for (int mode : availableVideoStabilizationModes) {
                if (mode != 2) continue;
                return true;
            }
        }
        return false;
    }

    @NonNull
    public Camera2CameraInfo getCamera2CameraInfo() {
        return this.mCamera2CameraInfo;
    }

    @NonNull
    public Object getCameraCharacteristics() {
        return this.mCameraCharacteristicsCompat.toCameraCharacteristics();
    }

    @Nullable
    public Object getPhysicalCameraCharacteristics(@NonNull String physicalCameraId) {
        try {
            if (!this.mCameraCharacteristicsCompat.getPhysicalCameraIds().contains(physicalCameraId)) {
                return null;
            }
            return this.mCameraManager.getCameraCharacteristicsCompat(physicalCameraId).toCameraCharacteristics();
        }
        catch (CameraAccessExceptionCompat e) {
            Logger.e((String)TAG, (String)("Failed to get CameraCharacteristics for cameraId " + physicalCameraId), (Throwable)e);
            return null;
        }
    }

    @NonNull
    public Map<String, CameraCharacteristics> getCameraCharacteristicsMap() {
        LinkedHashMap<String, CameraCharacteristics> map = new LinkedHashMap<String, CameraCharacteristics>();
        map.put(this.mCameraId, this.mCameraCharacteristicsCompat.toCameraCharacteristics());
        for (String physicalCameraId : this.mCameraCharacteristicsCompat.getPhysicalCameraIds()) {
            if (Objects.equals(physicalCameraId, this.mCameraId)) continue;
            try {
                map.put(physicalCameraId, this.mCameraManager.getCameraCharacteristicsCompat(physicalCameraId).toCameraCharacteristics());
            }
            catch (CameraAccessExceptionCompat e) {
                Logger.e((String)TAG, (String)("Failed to get CameraCharacteristics for cameraId " + physicalCameraId), (Throwable)e);
            }
        }
        return map;
    }

    @NonNull
    public Set<CameraInfo> getPhysicalCameraInfos() {
        if (this.mPhysicalCameraInfos == null) {
            this.mPhysicalCameraInfos = new HashSet<CameraInfo>();
            for (String physicalCameraId : this.mCameraCharacteristicsCompat.getPhysicalCameraIds()) {
                try {
                    Camera2PhysicalCameraInfoImpl physicalCameraInfo = new Camera2PhysicalCameraInfoImpl(physicalCameraId, this.mCameraManager);
                    this.mPhysicalCameraInfos.add(physicalCameraInfo);
                }
                catch (CameraAccessExceptionCompat e) {
                    Logger.e((String)TAG, (String)("Failed to get CameraCharacteristics for cameraId " + physicalCameraId), (Throwable)e);
                    return Collections.emptySet();
                }
            }
        }
        return this.mPhysicalCameraInfos;
    }

    static class RedirectableLiveData<T>
    extends MediatorLiveData<T> {
        private LiveData<T> mLiveDataSource;
        private final T mInitialValue;

        RedirectableLiveData(T initialValue) {
            this.mInitialValue = initialValue;
        }

        void redirectTo(@NonNull LiveData<T> liveDataSource) {
            if (this.mLiveDataSource != null) {
                super.removeSource(this.mLiveDataSource);
            }
            this.mLiveDataSource = liveDataSource;
            super.addSource(liveDataSource, arg_0 -> ((RedirectableLiveData)this).setValue(arg_0));
        }

        public <S> void addSource(@NonNull LiveData<S> source, @NonNull Observer<? super S> onChanged) {
            throw new UnsupportedOperationException();
        }

        public T getValue() {
            return (T)(this.mLiveDataSource == null ? this.mInitialValue : this.mLiveDataSource.getValue());
        }
    }
}

