/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.internal.compat.quirk.DeviceQuirks;
import androidx.camera.camera2.internal.compat.quirk.ExtraCroppingQuirk;
import androidx.camera.core.impl.SurfaceConfig;
import java.util.ArrayList;
import java.util.List;

public class ResolutionCorrector {
    @Nullable
    private final ExtraCroppingQuirk mExtraCroppingQuirk;

    public ResolutionCorrector() {
        this(DeviceQuirks.get(ExtraCroppingQuirk.class));
    }

    @VisibleForTesting
    ResolutionCorrector(@Nullable ExtraCroppingQuirk extraCroppingQuirk) {
        this.mExtraCroppingQuirk = extraCroppingQuirk;
    }

    @NonNull
    public List<Size> insertOrPrioritize(@NonNull SurfaceConfig.ConfigType configType, @NonNull List<Size> supportedResolutions) {
        if (this.mExtraCroppingQuirk == null) {
            return supportedResolutions;
        }
        Size selectResolution = this.mExtraCroppingQuirk.getVerifiedResolution(configType);
        if (selectResolution == null) {
            return supportedResolutions;
        }
        ArrayList<Size> newResolutions = new ArrayList<Size>();
        newResolutions.add(selectResolution);
        for (Size size : supportedResolutions) {
            if (size.equals((Object)selectResolution)) continue;
            newResolutions.add(size);
        }
        return newResolutions;
    }
}

