/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.params;

import android.hardware.camera2.params.OutputConfiguration;
import android.os.Build;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.internal.compat.ApiCompat;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompatApi24Impl;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompatApi26Impl;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompatApi28Impl;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompatApi33Impl;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompatBaseImpl;
import java.util.List;

public final class OutputConfigurationCompat {
    public static final int SURFACE_GROUP_ID_NONE = -1;
    public static final int STREAM_USE_CASE_NONE = -1;
    private final OutputConfigurationCompatImpl mImpl;

    public OutputConfigurationCompat(@NonNull Surface surface) {
        this(-1, surface);
    }

    public OutputConfigurationCompat(int surfaceGroupId, @NonNull Surface surface) {
        this.mImpl = Build.VERSION.SDK_INT >= 33 ? new OutputConfigurationCompatApi33Impl(surfaceGroupId, surface) : (Build.VERSION.SDK_INT >= 28 ? new OutputConfigurationCompatApi28Impl(surfaceGroupId, surface) : (Build.VERSION.SDK_INT >= 26 ? new OutputConfigurationCompatApi26Impl(surfaceGroupId, surface) : (Build.VERSION.SDK_INT >= 24 ? new OutputConfigurationCompatApi24Impl(surfaceGroupId, surface) : new OutputConfigurationCompatBaseImpl(surface))));
    }

    @RequiresApi(value=26)
    public <T> OutputConfigurationCompat(@NonNull Size surfaceSize, @NonNull Class<T> klass) {
        OutputConfiguration deferredConfig = ApiCompat.Api26Impl.newOutputConfiguration(surfaceSize, klass);
        this.mImpl = Build.VERSION.SDK_INT >= 33 ? OutputConfigurationCompatApi33Impl.wrap(deferredConfig) : (Build.VERSION.SDK_INT >= 28 ? OutputConfigurationCompatApi28Impl.wrap(deferredConfig) : OutputConfigurationCompatApi26Impl.wrap(deferredConfig));
    }

    private OutputConfigurationCompat(@NonNull OutputConfigurationCompatImpl impl) {
        this.mImpl = impl;
    }

    @Nullable
    public static OutputConfigurationCompat wrap(@Nullable Object outputConfiguration) {
        if (outputConfiguration == null) {
            return null;
        }
        OutputConfigurationCompatApi24Impl outputConfigurationCompatImpl = null;
        if (Build.VERSION.SDK_INT >= 33) {
            outputConfigurationCompatImpl = OutputConfigurationCompatApi33Impl.wrap((OutputConfiguration)outputConfiguration);
        } else if (Build.VERSION.SDK_INT >= 28) {
            outputConfigurationCompatImpl = OutputConfigurationCompatApi28Impl.wrap((OutputConfiguration)outputConfiguration);
        } else if (Build.VERSION.SDK_INT >= 26) {
            outputConfigurationCompatImpl = OutputConfigurationCompatApi26Impl.wrap((OutputConfiguration)outputConfiguration);
        } else if (Build.VERSION.SDK_INT >= 24) {
            outputConfigurationCompatImpl = OutputConfigurationCompatApi24Impl.wrap((OutputConfiguration)outputConfiguration);
        }
        if (outputConfigurationCompatImpl == null) {
            return null;
        }
        return new OutputConfigurationCompat(outputConfigurationCompatImpl);
    }

    public void enableSurfaceSharing() {
        this.mImpl.enableSurfaceSharing();
    }

    public int getMirrorMode() {
        return this.mImpl.getMirrorMode();
    }

    public void setMirrorMode(int mirrorMode) {
        this.mImpl.setMirrorMode(mirrorMode);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public String getPhysicalCameraId() {
        return this.mImpl.getPhysicalCameraId();
    }

    public void setPhysicalCameraId(@Nullable String physicalCameraId) {
        this.mImpl.setPhysicalCameraId(physicalCameraId);
    }

    public void addSurface(@NonNull Surface surface) {
        this.mImpl.addSurface(surface);
    }

    public void removeSurface(@NonNull Surface surface) {
        this.mImpl.removeSurface(surface);
    }

    public int getMaxSharedSurfaceCount() {
        return this.mImpl.getMaxSharedSurfaceCount();
    }

    @Nullable
    public Surface getSurface() {
        return this.mImpl.getSurface();
    }

    @NonNull
    public List<Surface> getSurfaces() {
        return this.mImpl.getSurfaces();
    }

    public int getSurfaceGroupId() {
        return this.mImpl.getSurfaceGroupId();
    }

    public long getDynamicRangeProfile() {
        return this.mImpl.getDynamicRangeProfile();
    }

    public void setDynamicRangeProfile(long profile) {
        this.mImpl.setDynamicRangeProfile(profile);
    }

    public void setStreamUseCase(long streamUseCase) {
        this.mImpl.setStreamUseCase(streamUseCase);
    }

    public long getStreamUseCase() {
        return this.mImpl.getStreamUseCase();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OutputConfigurationCompat)) {
            return false;
        }
        return this.mImpl.equals(((OutputConfigurationCompat)obj).mImpl);
    }

    public int hashCode() {
        return this.mImpl.hashCode();
    }

    @Nullable
    public Object unwrap() {
        return this.mImpl.getOutputConfiguration();
    }

    static interface OutputConfigurationCompatImpl {
        public void enableSurfaceSharing();

        public int getMirrorMode();

        public void setMirrorMode(int var1);

        @Nullable
        public String getPhysicalCameraId();

        public void setPhysicalCameraId(@Nullable String var1);

        public void addSurface(@NonNull Surface var1);

        public void removeSurface(@NonNull Surface var1);

        public int getMaxSharedSurfaceCount();

        public long getDynamicRangeProfile();

        public void setDynamicRangeProfile(long var1);

        public void setStreamUseCase(long var1);

        public long getStreamUseCase();

        @Nullable
        public Surface getSurface();

        public List<Surface> getSurfaces();

        public int getSurfaceGroupId();

        @Nullable
        public Object getOutputConfiguration();
    }
}

