/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.params.SessionConfiguration;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraDeviceCompatApi24Impl;
import androidx.camera.camera2.internal.compat.params.SessionConfigurationCompat;
import androidx.core.util.Preconditions;

@RequiresApi(value=28)
class CameraDeviceCompatApi28Impl
extends CameraDeviceCompatApi24Impl {
    CameraDeviceCompatApi28Impl(@NonNull CameraDevice cameraDevice) {
        super((CameraDevice)Preconditions.checkNotNull((Object)cameraDevice), null);
    }

    @Override
    public void createCaptureSession(@NonNull SessionConfigurationCompat config) throws CameraAccessExceptionCompat {
        SessionConfiguration sessionConfig = (SessionConfiguration)config.unwrap();
        Preconditions.checkNotNull((Object)sessionConfig);
        try {
            this.mCameraDevice.createCaptureSession(sessionConfig);
        }
        catch (CameraAccessException e) {
            throw CameraAccessExceptionCompat.toCameraAccessExceptionCompat(e);
        }
    }
}

