/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsApi28Impl;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsBaseImpl;
import androidx.camera.camera2.internal.compat.StreamConfigurationMapCompat;
import androidx.camera.camera2.internal.compat.workaround.OutputSizesCorrector;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CameraCharacteristicsCompat {
    @NonNull
    @GuardedBy(value="this")
    private final Map<CameraCharacteristics.Key<?>, Object> mValuesCache = new HashMap();
    @NonNull
    private final CameraCharacteristicsCompatImpl mCameraCharacteristicsImpl;
    @NonNull
    private final String mCameraId;
    @Nullable
    private StreamConfigurationMapCompat mStreamConfigurationMapCompat = null;

    private CameraCharacteristicsCompat(@NonNull CameraCharacteristics cameraCharacteristics, @NonNull String cameraId) {
        this.mCameraCharacteristicsImpl = Build.VERSION.SDK_INT >= 28 ? new CameraCharacteristicsApi28Impl(cameraCharacteristics) : new CameraCharacteristicsBaseImpl(cameraCharacteristics);
        this.mCameraId = cameraId;
    }

    @VisibleForTesting
    @NonNull
    public static CameraCharacteristicsCompat toCameraCharacteristicsCompat(@NonNull CameraCharacteristics characteristics, @NonNull String cameraId) {
        return new CameraCharacteristicsCompat(characteristics, cameraId);
    }

    private boolean isKeyNonCacheable(@NonNull CameraCharacteristics.Key<?> key) {
        return key.equals((Object)CameraCharacteristics.SENSOR_ORIENTATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T get(@NonNull CameraCharacteristics.Key<T> key) {
        if (this.isKeyNonCacheable(key)) {
            return this.mCameraCharacteristicsImpl.get(key);
        }
        CameraCharacteristicsCompat cameraCharacteristicsCompat = this;
        synchronized (cameraCharacteristicsCompat) {
            Object value = this.mValuesCache.get(key);
            if (value != null) {
                return (T)value;
            }
            value = this.mCameraCharacteristicsImpl.get(key);
            if (value != null) {
                this.mValuesCache.put(key, value);
            }
            return (T)value;
        }
    }

    @NonNull
    public Set<String> getPhysicalCameraIds() {
        return this.mCameraCharacteristicsImpl.getPhysicalCameraIds();
    }

    public boolean isZoomOverrideAvailable() {
        int[] availableSettingsOverrides;
        if (Build.VERSION.SDK_INT >= 34 && (availableSettingsOverrides = (int[])this.mCameraCharacteristicsImpl.get(CameraCharacteristics.CONTROL_AVAILABLE_SETTINGS_OVERRIDES)) != null) {
            for (int i : availableSettingsOverrides) {
                if (i != 1) continue;
                return true;
            }
        }
        return false;
    }

    @NonNull
    public StreamConfigurationMapCompat getStreamConfigurationMapCompat() {
        if (this.mStreamConfigurationMapCompat == null) {
            StreamConfigurationMap map;
            try {
                map = (StreamConfigurationMap)this.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            }
            catch (AssertionError | NullPointerException e) {
                throw new IllegalArgumentException(((Throwable)e).getMessage());
            }
            if (map == null) {
                throw new IllegalArgumentException("StreamConfigurationMap is null!");
            }
            OutputSizesCorrector outputSizesCorrector = new OutputSizesCorrector(this.mCameraId);
            this.mStreamConfigurationMapCompat = StreamConfigurationMapCompat.toStreamConfigurationMapCompat(map, outputSizesCorrector);
        }
        return this.mStreamConfigurationMapCompat;
    }

    @NonNull
    public CameraCharacteristics toCameraCharacteristics() {
        return this.mCameraCharacteristicsImpl.unwrap();
    }

    public static interface CameraCharacteristicsCompatImpl {
        @Nullable
        public <T> T get(@NonNull CameraCharacteristics.Key<T> var1);

        @NonNull
        public Set<String> getPhysicalCameraIds();

        @NonNull
        public CameraCharacteristics unwrap();
    }
}

