/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.Camera2CameraInfoImpl;
import androidx.camera.camera2.internal.Camera2RequestProcessor;
import androidx.camera.camera2.internal.CaptureSession;
import androidx.camera.camera2.internal.CaptureSessionInterface;
import androidx.camera.camera2.internal.SynchronizedCaptureSession;
import androidx.camera.camera2.internal.compat.params.DynamicRangesCompat;
import androidx.camera.camera2.interop.CaptureRequestOptions;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.core.Preview;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureFailure;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.DeferrableSurfaces;
import androidx.camera.core.impl.OutputSurface;
import androidx.camera.core.impl.OutputSurfaceConfiguration;
import androidx.camera.core.impl.RequestProcessor;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.core.impl.SessionProcessorSurface;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.streamsharing.StreamSharing;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

@OptIn(markerClass={ExperimentalCamera2Interop.class})
final class ProcessingCaptureSession
implements CaptureSessionInterface {
    private static final String TAG = "ProcessingCaptureSession";
    private final SessionProcessor mSessionProcessor;
    private final Camera2CameraInfoImpl mCamera2CameraInfoImpl;
    final Executor mExecutor;
    private final ScheduledExecutorService mScheduledExecutorService;
    private final CaptureSession mCaptureSession;
    private List<DeferrableSurface> mOutputSurfaces = new ArrayList<DeferrableSurface>();
    @Nullable
    private SessionConfig mSessionConfig;
    @Nullable
    private Camera2RequestProcessor mRequestProcessor;
    @Nullable
    private SessionConfig mProcessorSessionConfig;
    private static final long TIMEOUT_GET_SURFACE_IN_MS = 5000L;
    private ProcessorState mProcessorState;
    private static List<DeferrableSurface> sHeldProcessorSurfaces = new ArrayList<DeferrableSurface>();
    @Nullable
    private volatile List<CaptureConfig> mPendingCaptureConfigs = null;
    private final SessionProcessorCaptureCallback mSessionProcessorCaptureCallback;
    private CaptureRequestOptions mSessionOptions = new CaptureRequestOptions.Builder().build();
    private CaptureRequestOptions mStillCaptureOptions = new CaptureRequestOptions.Builder().build();
    private static int sNextInstanceId = 0;
    private int mInstanceId = 0;

    ProcessingCaptureSession(@NonNull SessionProcessor sessionProcessor, @NonNull Camera2CameraInfoImpl camera2CameraInfoImpl, @NonNull DynamicRangesCompat dynamicRangesCompat, @NonNull Executor executor, @NonNull ScheduledExecutorService scheduledExecutorService) {
        this.mCaptureSession = new CaptureSession(dynamicRangesCompat);
        this.mSessionProcessor = sessionProcessor;
        this.mCamera2CameraInfoImpl = camera2CameraInfoImpl;
        this.mExecutor = executor;
        this.mScheduledExecutorService = scheduledExecutorService;
        this.mProcessorState = ProcessorState.UNINITIALIZED;
        this.mSessionProcessorCaptureCallback = new SessionProcessorCaptureCallback();
        this.mInstanceId = sNextInstanceId++;
        Logger.d((String)TAG, (String)("New ProcessingCaptureSession (id=" + this.mInstanceId + ")"));
    }

    @Override
    @NonNull
    public ListenableFuture<Void> open(@NonNull SessionConfig sessionConfig, @NonNull CameraDevice cameraDevice, @NonNull SynchronizedCaptureSession.Opener opener) {
        Preconditions.checkArgument((this.mProcessorState == ProcessorState.UNINITIALIZED ? 1 : 0) != 0, (Object)("Invalid state state:" + (Object)((Object)this.mProcessorState)));
        Preconditions.checkArgument((!sessionConfig.getSurfaces().isEmpty() ? 1 : 0) != 0, (Object)"SessionConfig contains no surfaces");
        Logger.d((String)TAG, (String)("open (id=" + this.mInstanceId + ")"));
        this.mOutputSurfaces = sessionConfig.getSurfaces();
        FutureChain future = FutureChain.from((ListenableFuture)DeferrableSurfaces.surfaceListWithTimeout(this.mOutputSurfaces, (boolean)false, (long)5000L, (Executor)this.mExecutor, (ScheduledExecutorService)this.mScheduledExecutorService)).transformAsync(surfaceList -> {
            DeferrableSurface postviewDeferrableSurface;
            Logger.d((String)TAG, (String)("-- getSurfaces done, start init (id=" + this.mInstanceId + ")"));
            if (this.mProcessorState == ProcessorState.DE_INITIALIZED) {
                return Futures.immediateFailedFuture((Throwable)new IllegalStateException("SessionProcessorCaptureSession is closed."));
            }
            if (surfaceList.contains(null)) {
                DeferrableSurface deferrableSurface = (DeferrableSurface)sessionConfig.getSurfaces().get(surfaceList.indexOf(null));
                return Futures.immediateFailedFuture((Throwable)new DeferrableSurface.SurfaceClosedException("Surface closed", deferrableSurface));
            }
            OutputSurface previewOutputSurface = null;
            OutputSurface captureOutputSurface = null;
            OutputSurface analysisOutputSurface = null;
            OutputSurface postviewOutputSurface = null;
            for (int i = 0; i < sessionConfig.getSurfaces().size(); ++i) {
                DeferrableSurface dSurface = (DeferrableSurface)sessionConfig.getSurfaces().get(i);
                if (ProcessingCaptureSession.isPreview(dSurface) || ProcessingCaptureSession.isStreamSharing(dSurface)) {
                    previewOutputSurface = OutputSurface.create((Surface)((Surface)dSurface.getSurface().get()), (Size)dSurface.getPrescribedSize(), (int)dSurface.getPrescribedStreamFormat());
                    continue;
                }
                if (ProcessingCaptureSession.isImageCapture(dSurface)) {
                    captureOutputSurface = OutputSurface.create((Surface)((Surface)dSurface.getSurface().get()), (Size)dSurface.getPrescribedSize(), (int)dSurface.getPrescribedStreamFormat());
                    continue;
                }
                if (!ProcessingCaptureSession.isImageAnalysis(dSurface)) continue;
                analysisOutputSurface = OutputSurface.create((Surface)((Surface)dSurface.getSurface().get()), (Size)dSurface.getPrescribedSize(), (int)dSurface.getPrescribedStreamFormat());
            }
            if (sessionConfig.getPostviewOutputConfig() != null) {
                postviewDeferrableSurface = sessionConfig.getPostviewOutputConfig().getSurface();
                postviewOutputSurface = OutputSurface.create((Surface)((Surface)postviewDeferrableSurface.getSurface().get()), (Size)postviewDeferrableSurface.getPrescribedSize(), (int)postviewDeferrableSurface.getPrescribedStreamFormat());
            } else {
                postviewDeferrableSurface = null;
            }
            this.mProcessorState = ProcessorState.SESSION_INITIALIZED;
            try {
                ArrayList<DeferrableSurface> surfacesToIncrement = new ArrayList<DeferrableSurface>(this.mOutputSurfaces);
                if (postviewDeferrableSurface != null) {
                    surfacesToIncrement.add(postviewDeferrableSurface);
                }
                DeferrableSurfaces.incrementAll(surfacesToIncrement);
            }
            catch (DeferrableSurface.SurfaceClosedException e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
            Logger.w((String)TAG, (String)("== initSession (id=" + this.mInstanceId + ")"));
            try {
                this.mProcessorSessionConfig = this.mSessionProcessor.initSession((CameraInfo)this.mCamera2CameraInfoImpl, OutputSurfaceConfiguration.create((OutputSurface)previewOutputSurface, (OutputSurface)captureOutputSurface, (OutputSurface)analysisOutputSurface, (OutputSurface)postviewOutputSurface));
            }
            catch (Throwable e) {
                Logger.e((String)TAG, (String)"initSession failed", (Throwable)e);
                DeferrableSurfaces.decrementAll(this.mOutputSurfaces);
                if (postviewDeferrableSurface != null) {
                    postviewDeferrableSurface.decrementUseCount();
                }
                throw e;
            }
            ((DeferrableSurface)this.mProcessorSessionConfig.getSurfaces().get(0)).getTerminationFuture().addListener(() -> {
                DeferrableSurfaces.decrementAll(this.mOutputSurfaces);
                if (postviewDeferrableSurface != null) {
                    postviewDeferrableSurface.decrementUseCount();
                }
            }, CameraXExecutors.directExecutor());
            for (DeferrableSurface surface : this.mProcessorSessionConfig.getSurfaces()) {
                sHeldProcessorSurfaces.add(surface);
                surface.getTerminationFuture().addListener(() -> sHeldProcessorSurfaces.remove(surface), this.mExecutor);
            }
            SessionConfig.ValidatingBuilder validatingBuilder = new SessionConfig.ValidatingBuilder();
            validatingBuilder.add(sessionConfig);
            validatingBuilder.clearSurfaces();
            validatingBuilder.add(this.mProcessorSessionConfig);
            Preconditions.checkArgument((boolean)validatingBuilder.isValid(), (Object)"Cannot transform the SessionConfig");
            SessionConfig transformedConfig = validatingBuilder.build();
            ListenableFuture<Void> openSessionFuture = this.mCaptureSession.open(transformedConfig, (CameraDevice)Preconditions.checkNotNull((Object)cameraDevice), opener);
            Futures.addCallback(openSessionFuture, (FutureCallback)new FutureCallback<Void>(){

                public void onSuccess(@Nullable Void result) {
                }

                public void onFailure(@NonNull Throwable t) {
                    Logger.e((String)ProcessingCaptureSession.TAG, (String)"open session failed ", (Throwable)t);
                    ProcessingCaptureSession.this.close();
                    ProcessingCaptureSession.this.release(false);
                }
            }, (Executor)this.mExecutor);
            return openSessionFuture;
        }, this.mExecutor).transform(v -> {
            this.onConfigured(this.mCaptureSession);
            return null;
        }, this.mExecutor);
        return future;
    }

    private static void cancelRequests(@NonNull List<CaptureConfig> captureConfigs) {
        for (CaptureConfig captureConfig : captureConfigs) {
            for (CameraCaptureCallback cameraCaptureCallback : captureConfig.getCameraCaptureCallbacks()) {
                cameraCaptureCallback.onCaptureCancelled(captureConfig.getId());
            }
        }
    }

    void issueTriggerRequest(@NonNull CaptureConfig captureConfig) {
        Logger.d((String)TAG, (String)"issueTriggerRequest");
        CaptureRequestOptions options = CaptureRequestOptions.Builder.from(captureConfig.getImplementationOptions()).build();
        boolean hasTriggerParameters = false;
        for (Config.Option option : options.listOptions()) {
            CaptureRequest.Key key = (CaptureRequest.Key)option.getToken();
            if (!key.equals((Object)CaptureRequest.CONTROL_AF_TRIGGER) && !key.equals((Object)CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER)) continue;
            hasTriggerParameters = true;
            break;
        }
        if (!hasTriggerParameters) {
            ProcessingCaptureSession.cancelRequests(Arrays.asList(captureConfig));
            return;
        }
        this.mSessionProcessor.startTrigger((Config)options, captureConfig.getTagBundle(), (SessionProcessor.CaptureCallback)new CaptureCallbackAdapter(captureConfig.getId(), captureConfig.getCameraCaptureCallbacks()));
    }

    @Override
    public void issueCaptureRequests(@NonNull List<CaptureConfig> captureConfigs) {
        if (captureConfigs.isEmpty()) {
            return;
        }
        Logger.d((String)TAG, (String)("issueCaptureRequests (id=" + this.mInstanceId + ") + state =" + (Object)((Object)this.mProcessorState)));
        switch (this.mProcessorState.ordinal()) {
            case 0: 
            case 1: {
                if (this.mPendingCaptureConfigs != null) {
                    ProcessingCaptureSession.cancelRequests(captureConfigs);
                    Logger.d((String)TAG, (String)"cancel the request because are pending un-submitted request");
                    break;
                }
                this.mPendingCaptureConfigs = captureConfigs;
                break;
            }
            case 2: {
                for (CaptureConfig captureConfig : captureConfigs) {
                    if (captureConfig.getTemplateType() == 2) {
                        this.issueStillCaptureRequest(captureConfig);
                        continue;
                    }
                    this.issueTriggerRequest(captureConfig);
                }
                break;
            }
            case 3: 
            case 4: {
                Logger.d((String)TAG, (String)("Run issueCaptureRequests in wrong state, state = " + (Object)((Object)this.mProcessorState)));
                ProcessingCaptureSession.cancelRequests(captureConfigs);
            }
        }
    }

    void issueStillCaptureRequest(@NonNull CaptureConfig captureConfig) {
        CaptureRequestOptions.Builder builder = CaptureRequestOptions.Builder.from(captureConfig.getImplementationOptions());
        if (captureConfig.getImplementationOptions().containsOption(CaptureConfig.OPTION_ROTATION)) {
            builder.setCaptureRequestOption(CaptureRequest.JPEG_ORIENTATION, (Integer)captureConfig.getImplementationOptions().retrieveOption(CaptureConfig.OPTION_ROTATION));
        }
        if (captureConfig.getImplementationOptions().containsOption(CaptureConfig.OPTION_JPEG_QUALITY)) {
            builder.setCaptureRequestOption(CaptureRequest.JPEG_QUALITY, ((Integer)captureConfig.getImplementationOptions().retrieveOption(CaptureConfig.OPTION_JPEG_QUALITY)).byteValue());
        }
        this.mStillCaptureOptions = builder.build();
        this.updateParameters(this.mSessionOptions, this.mStillCaptureOptions);
        this.mSessionProcessor.startCapture(captureConfig.isPostviewEnabled(), captureConfig.getTagBundle(), (SessionProcessor.CaptureCallback)new CaptureCallbackAdapter(captureConfig.getId(), captureConfig.getCameraCaptureCallbacks()));
    }

    @Override
    @NonNull
    public ListenableFuture<Void> release(boolean abortInFlightCaptures) {
        Logger.d((String)TAG, (String)("release (id=" + this.mInstanceId + ") mProcessorState=" + (Object)((Object)this.mProcessorState)));
        ListenableFuture<Void> future = this.mCaptureSession.release(abortInFlightCaptures);
        switch (this.mProcessorState.ordinal()) {
            case 1: 
            case 3: {
                future.addListener(() -> {
                    Logger.d((String)TAG, (String)("== deInitSession (id=" + this.mInstanceId + ")"));
                    this.mSessionProcessor.deInitSession();
                }, CameraXExecutors.directExecutor());
                break;
            }
        }
        this.mProcessorState = ProcessorState.DE_INITIALIZED;
        return future;
    }

    private static List<SessionProcessorSurface> getSessionProcessorSurfaceList(List<DeferrableSurface> deferrableSurfaceList) {
        ArrayList<SessionProcessorSurface> outputSurfaceList = new ArrayList<SessionProcessorSurface>();
        for (DeferrableSurface deferrableSurface : deferrableSurfaceList) {
            Preconditions.checkArgument((boolean)(deferrableSurface instanceof SessionProcessorSurface), (Object)"Surface must be SessionProcessorSurface");
            outputSurfaceList.add((SessionProcessorSurface)deferrableSurface);
        }
        return outputSurfaceList;
    }

    void onConfigured(@NonNull CaptureSession captureSession) {
        if (this.mProcessorState != ProcessorState.SESSION_INITIALIZED) {
            return;
        }
        this.mRequestProcessor = new Camera2RequestProcessor(captureSession, ProcessingCaptureSession.getSessionProcessorSurfaceList(this.mProcessorSessionConfig.getSurfaces()));
        Logger.d((String)TAG, (String)("== onCaptureSessinStarted (id = " + this.mInstanceId + ")"));
        this.mSessionProcessor.onCaptureSessionStart((RequestProcessor)this.mRequestProcessor);
        this.mProcessorState = ProcessorState.ON_CAPTURE_SESSION_STARTED;
        if (this.mSessionConfig != null) {
            this.setSessionConfig(this.mSessionConfig);
        }
        if (this.mPendingCaptureConfigs != null) {
            this.issueCaptureRequests(this.mPendingCaptureConfigs);
            this.mPendingCaptureConfigs = null;
        }
    }

    @Override
    @Nullable
    public SessionConfig getSessionConfig() {
        return this.mSessionConfig;
    }

    @Override
    @NonNull
    public List<CaptureConfig> getCaptureConfigs() {
        return this.mPendingCaptureConfigs != null ? this.mPendingCaptureConfigs : Collections.emptyList();
    }

    @Override
    public void cancelIssuedCaptureRequests() {
        Logger.d((String)TAG, (String)("cancelIssuedCaptureRequests (id=" + this.mInstanceId + ")"));
        if (this.mPendingCaptureConfigs != null) {
            for (CaptureConfig captureConfig : this.mPendingCaptureConfigs) {
                for (CameraCaptureCallback cameraCaptureCallback : captureConfig.getCameraCaptureCallbacks()) {
                    cameraCaptureCallback.onCaptureCancelled(captureConfig.getId());
                }
            }
            this.mPendingCaptureConfigs = null;
        }
    }

    @Override
    public void close() {
        Logger.d((String)TAG, (String)("close (id=" + this.mInstanceId + ") state=" + (Object)((Object)this.mProcessorState)));
        if (this.mProcessorState == ProcessorState.ON_CAPTURE_SESSION_STARTED) {
            Logger.d((String)TAG, (String)("== onCaptureSessionEnd (id = " + this.mInstanceId + ")"));
            this.mSessionProcessor.onCaptureSessionEnd();
            if (this.mRequestProcessor != null) {
                this.mRequestProcessor.close();
            }
            this.mProcessorState = ProcessorState.ON_CAPTURE_SESSION_ENDED;
        }
        this.mCaptureSession.close();
    }

    @Override
    public void setSessionConfig(@Nullable SessionConfig sessionConfig) {
        Logger.d((String)TAG, (String)("setSessionConfig (id=" + this.mInstanceId + ")"));
        this.mSessionConfig = sessionConfig;
        if (sessionConfig == null) {
            return;
        }
        if (this.mRequestProcessor != null) {
            this.mRequestProcessor.updateSessionConfig(sessionConfig);
        }
        if (this.mProcessorState == ProcessorState.ON_CAPTURE_SESSION_STARTED) {
            this.mSessionOptions = CaptureRequestOptions.Builder.from(sessionConfig.getImplementationOptions()).build();
            this.updateParameters(this.mSessionOptions, this.mStillCaptureOptions);
            if (!ProcessingCaptureSession.hasPreviewSurface(sessionConfig.getRepeatingCaptureConfig())) {
                this.mSessionProcessor.stopRepeating();
            } else {
                this.mSessionProcessor.startRepeating(sessionConfig.getRepeatingCaptureConfig().getTagBundle(), (SessionProcessor.CaptureCallback)this.mSessionProcessorCaptureCallback);
            }
        }
    }

    @Override
    public boolean isInOpenState() {
        return this.mCaptureSession.isInOpenState();
    }

    private static boolean hasPreviewSurface(@NonNull CaptureConfig captureConfig) {
        for (DeferrableSurface surface : captureConfig.getSurfaces()) {
            if (!ProcessingCaptureSession.isPreview(surface) && !ProcessingCaptureSession.isStreamSharing(surface)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setStreamUseCaseMap(@NonNull Map<DeferrableSurface, Long> streamUseCaseMap) {
    }

    private void updateParameters(@NonNull CaptureRequestOptions sessionOptions, @NonNull CaptureRequestOptions stillCaptureOptions) {
        Camera2ImplConfig.Builder builder = new Camera2ImplConfig.Builder();
        builder.insertAllOptions((Config)sessionOptions);
        builder.insertAllOptions((Config)stillCaptureOptions);
        this.mSessionProcessor.setParameters((Config)builder.build());
    }

    private static boolean isPreview(@NonNull DeferrableSurface dSurface) {
        return Objects.equals(dSurface.getContainerClass(), Preview.class);
    }

    private static boolean isImageCapture(@NonNull DeferrableSurface dSurface) {
        return Objects.equals(dSurface.getContainerClass(), ImageCapture.class);
    }

    private static boolean isImageAnalysis(@NonNull DeferrableSurface dSurface) {
        return Objects.equals(dSurface.getContainerClass(), ImageAnalysis.class);
    }

    private static boolean isStreamSharing(@NonNull DeferrableSurface dSurface) {
        return Objects.equals(dSurface.getContainerClass(), StreamSharing.class);
    }

    private static enum ProcessorState {
        UNINITIALIZED,
        SESSION_INITIALIZED,
        ON_CAPTURE_SESSION_STARTED,
        ON_CAPTURE_SESSION_ENDED,
        DE_INITIALIZED;

    }

    private static class SessionProcessorCaptureCallback
    implements SessionProcessor.CaptureCallback {
        SessionProcessorCaptureCallback() {
        }

        public void onCaptureStarted(int captureSequenceId, long timestamp) {
        }

        public void onCaptureProcessStarted(int captureSequenceId) {
        }

        public void onCaptureFailed(int captureSequenceId) {
        }

        public void onCaptureSequenceCompleted(int captureSequenceId) {
        }

        public void onCaptureSequenceAborted(int captureSequenceId) {
        }

        public void onCaptureCompleted(long timestamp, int captureSequenceId, @NonNull CameraCaptureResult result) {
        }
    }

    private static class CaptureCallbackAdapter
    implements SessionProcessor.CaptureCallback {
        private List<CameraCaptureCallback> mCameraCaptureCallbacks;
        private final int mCaptureConfigId;
        private CameraCaptureResult mCaptureResult = null;

        private CaptureCallbackAdapter(int captureConfigId, List<CameraCaptureCallback> cameraCaptureCallbacks) {
            this.mCaptureConfigId = captureConfigId;
            this.mCameraCaptureCallbacks = cameraCaptureCallbacks;
        }

        public void onCaptureStarted(int captureSequenceId, long timestamp) {
            for (CameraCaptureCallback cameraCaptureCallback : this.mCameraCaptureCallbacks) {
                cameraCaptureCallback.onCaptureStarted(this.mCaptureConfigId);
            }
        }

        public void onCaptureFailed(int captureSequenceId) {
            for (CameraCaptureCallback cameraCaptureCallback : this.mCameraCaptureCallbacks) {
                cameraCaptureCallback.onCaptureFailed(this.mCaptureConfigId, new CameraCaptureFailure(CameraCaptureFailure.Reason.ERROR));
            }
        }

        public void onCaptureCompleted(long timestamp, int captureSequenceId, @NonNull CameraCaptureResult captureResult) {
            this.mCaptureResult = captureResult;
        }

        public void onCaptureSequenceCompleted(int captureSequenceId) {
            CameraCaptureResult cameraCaptureResult = this.mCaptureResult != null ? this.mCaptureResult : new CameraCaptureResult.EmptyCameraCaptureResult();
            for (CameraCaptureCallback cameraCaptureCallback : this.mCameraCaptureCallbacks) {
                cameraCaptureCallback.onCaptureCompleted(this.mCaptureConfigId, cameraCaptureResult);
            }
        }

        public void onCaptureProcessProgressed(int progress) {
            for (CameraCaptureCallback cameraCaptureCallback : this.mCameraCaptureCallbacks) {
                cameraCaptureCallback.onCaptureProcessProgressed(this.mCaptureConfigId, progress);
            }
        }
    }
}

