/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.os.Build;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.internal.compat.workaround.TemplateParamsOverride;
import androidx.camera.camera2.interop.CaptureRequestOptions;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.StreamSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class Camera2CaptureRequestBuilder {
    private static final String TAG = "Camera2CaptureRequestBuilder";

    private Camera2CaptureRequestBuilder() {
    }

    @NonNull
    private static List<Surface> getConfiguredSurfaces(List<DeferrableSurface> deferrableSurfaces, Map<DeferrableSurface, Surface> configuredSurfaceMap) {
        ArrayList<Surface> surfaceList = new ArrayList<Surface>();
        for (DeferrableSurface deferrableSurface : deferrableSurfaces) {
            Surface surface = configuredSurfaceMap.get(deferrableSurface);
            if (surface == null) {
                throw new IllegalArgumentException("DeferrableSurface not in configuredSurfaceMap");
            }
            surfaceList.add(surface);
        }
        return surfaceList;
    }

    private static void applyTemplateParamsOverrideWorkaround(@NonNull CaptureRequest.Builder builder, int template, @NonNull TemplateParamsOverride templateParamsOverride) {
        for (Map.Entry<CaptureRequest.Key<?>, Object> entry : templateParamsOverride.getOverrideParams(template).entrySet()) {
            CaptureRequest.Key<?> key = entry.getKey();
            builder.set(key, entry.getValue());
        }
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    private static void applyImplementationOptionToCaptureBuilder(CaptureRequest.Builder builder, Config config) {
        CaptureRequestOptions bundle = CaptureRequestOptions.Builder.from(config).build();
        for (Config.Option option : bundle.listOptions()) {
            CaptureRequest.Key key = (CaptureRequest.Key)option.getToken();
            try {
                builder.set(key, bundle.retrieveOption(option));
            }
            catch (IllegalArgumentException e) {
                Logger.e((String)TAG, (String)("CaptureRequest.Key is not supported: " + key));
            }
        }
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    private static void applyAeFpsRange(@NonNull CaptureConfig captureConfig, @NonNull CaptureRequest.Builder builder) {
        if (!captureConfig.getExpectedFrameRateRange().equals((Object)StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
            builder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)captureConfig.getExpectedFrameRateRange());
        }
    }

    @VisibleForTesting
    static void applyVideoStabilization(@NonNull CaptureConfig captureConfig, @NonNull CaptureRequest.Builder builder) {
        if (captureConfig.getPreviewStabilizationMode() == 1 || captureConfig.getVideoStabilizationMode() == 1) {
            builder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
        } else if (captureConfig.getPreviewStabilizationMode() == 2) {
            builder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)2);
        } else if (captureConfig.getVideoStabilizationMode() == 2) {
            builder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
        }
    }

    @Nullable
    public static CaptureRequest build(@NonNull CaptureConfig captureConfig, @Nullable CameraDevice device, @NonNull Map<DeferrableSurface, Surface> configuredSurfaceMap, boolean isRepeatingRequest, @NonNull TemplateParamsOverride mTemplateParamsOverride) throws CameraAccessException {
        CaptureRequest.Builder builder;
        if (device == null) {
            return null;
        }
        List<Surface> surfaceList = Camera2CaptureRequestBuilder.getConfiguredSurfaces(captureConfig.getSurfaces(), configuredSurfaceMap);
        if (surfaceList.isEmpty()) {
            return null;
        }
        CameraCaptureResult cameraCaptureResult = captureConfig.getCameraCaptureResult();
        if (Build.VERSION.SDK_INT >= 23 && captureConfig.getTemplateType() == 5 && cameraCaptureResult != null && cameraCaptureResult.getCaptureResult() instanceof TotalCaptureResult) {
            Logger.d((String)TAG, (String)"createReprocessCaptureRequest");
            builder = Api23Impl.createReprocessCaptureRequest(device, (TotalCaptureResult)cameraCaptureResult.getCaptureResult());
        } else {
            Logger.d((String)TAG, (String)"createCaptureRequest");
            if (captureConfig.getTemplateType() == 5) {
                int templateType = isRepeatingRequest ? 1 : 2;
                builder = device.createCaptureRequest(templateType);
            } else {
                builder = device.createCaptureRequest(captureConfig.getTemplateType());
            }
        }
        Camera2CaptureRequestBuilder.applyTemplateParamsOverrideWorkaround(builder, captureConfig.getTemplateType(), mTemplateParamsOverride);
        Camera2CaptureRequestBuilder.applyAeFpsRange(captureConfig, builder);
        Camera2CaptureRequestBuilder.applyVideoStabilization(captureConfig, builder);
        if (captureConfig.getImplementationOptions().containsOption(CaptureConfig.OPTION_ROTATION)) {
            builder.set(CaptureRequest.JPEG_ORIENTATION, (Object)((Integer)captureConfig.getImplementationOptions().retrieveOption(CaptureConfig.OPTION_ROTATION)));
        }
        if (captureConfig.getImplementationOptions().containsOption(CaptureConfig.OPTION_JPEG_QUALITY)) {
            builder.set(CaptureRequest.JPEG_QUALITY, (Object)((Integer)captureConfig.getImplementationOptions().retrieveOption(CaptureConfig.OPTION_JPEG_QUALITY)).byteValue());
        }
        Camera2CaptureRequestBuilder.applyImplementationOptionToCaptureBuilder(builder, captureConfig.getImplementationOptions());
        for (Surface surface : surfaceList) {
            builder.addTarget(surface);
        }
        builder.setTag((Object)captureConfig.getTagBundle());
        return builder.build();
    }

    @Nullable
    public static CaptureRequest buildWithoutTarget(@NonNull CaptureConfig captureConfig, @Nullable CameraDevice device, @NonNull TemplateParamsOverride templateParamsOverride) throws CameraAccessException {
        if (device == null) {
            return null;
        }
        Logger.d((String)TAG, (String)("template type = " + captureConfig.getTemplateType()));
        CaptureRequest.Builder builder = device.createCaptureRequest(captureConfig.getTemplateType());
        Camera2CaptureRequestBuilder.applyTemplateParamsOverrideWorkaround(builder, captureConfig.getTemplateType(), templateParamsOverride);
        Camera2CaptureRequestBuilder.applyImplementationOptionToCaptureBuilder(builder, captureConfig.getImplementationOptions());
        return builder.build();
    }

    @RequiresApi(value=23)
    static class Api23Impl {
        private Api23Impl() {
        }

        static CaptureRequest.Builder createReprocessCaptureRequest(@NonNull CameraDevice cameraDevice, @NonNull TotalCaptureResult totalCaptureResult) throws CameraAccessException {
            return cameraDevice.createReprocessCaptureRequest(totalCaptureResult);
        }
    }
}

