/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.quirk.DeviceQuirks;
import androidx.camera.camera2.internal.compat.quirk.ExtraSupportedOutputSizeQuirk;
import androidx.camera.camera2.internal.compat.workaround.ExcludedSupportedSizesContainer;
import androidx.camera.core.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RequiresApi(value=21)
public class OutputSizesCorrector {
    private static final String TAG = "OutputSizesCorrector";
    private final String mCameraId;
    private final ExtraSupportedOutputSizeQuirk mExtraSupportedOutputSizeQuirk = DeviceQuirks.get(ExtraSupportedOutputSizeQuirk.class);
    private final ExcludedSupportedSizesContainer mExcludedSupportedSizesContainer;

    public OutputSizesCorrector(@NonNull String cameraId) {
        this.mCameraId = cameraId;
        this.mExcludedSupportedSizesContainer = new ExcludedSupportedSizesContainer(this.mCameraId);
    }

    @NonNull
    public Size[] applyQuirks(@NonNull Size[] sizes, int format) {
        ArrayList<Size> sizeList = new ArrayList<Size>(Arrays.asList(sizes));
        this.addExtraSupportedOutputSizesByFormat(sizeList, format);
        this.excludeProblematicOutputSizesByFormat(sizeList, format);
        if (sizeList.isEmpty()) {
            Logger.w((String)TAG, (String)"Sizes array becomes empty after excluding problematic output sizes.");
        }
        return sizeList.toArray(new Size[0]);
    }

    @NonNull
    public <T> Size[] applyQuirks(@NonNull Size[] sizes, @NonNull Class<T> klass) {
        ArrayList<Size> sizeList = new ArrayList<Size>(Arrays.asList(sizes));
        this.addExtraSupportedOutputSizesByClass(sizeList, klass);
        this.excludeProblematicOutputSizesByClass(sizeList, klass);
        if (sizeList.isEmpty()) {
            Logger.w((String)TAG, (String)"Sizes array becomes empty after excluding problematic output sizes.");
        }
        return sizeList.toArray(new Size[0]);
    }

    private void addExtraSupportedOutputSizesByFormat(@NonNull List<Size> sizeList, int format) {
        if (this.mExtraSupportedOutputSizeQuirk == null) {
            return;
        }
        Size[] extraSizes = this.mExtraSupportedOutputSizeQuirk.getExtraSupportedResolutions(format);
        if (extraSizes.length > 0) {
            sizeList.addAll(Arrays.asList(extraSizes));
        }
    }

    private void addExtraSupportedOutputSizesByClass(@NonNull List<Size> sizeList, @NonNull Class<?> klass) {
        if (this.mExtraSupportedOutputSizeQuirk == null) {
            return;
        }
        Size[] extraSizes = this.mExtraSupportedOutputSizeQuirk.getExtraSupportedResolutions(klass);
        if (extraSizes.length > 0) {
            sizeList.addAll(Arrays.asList(extraSizes));
        }
    }

    private void excludeProblematicOutputSizesByFormat(@NonNull List<Size> sizeList, int format) {
        List<Size> excludedSizes = this.mExcludedSupportedSizesContainer.get(format);
        if (excludedSizes.isEmpty()) {
            return;
        }
        sizeList.removeAll(excludedSizes);
    }

    private void excludeProblematicOutputSizesByClass(@NonNull List<Size> sizeList, @NonNull Class<?> klass) {
        List<Size> excludedSizes = this.mExcludedSupportedSizesContainer.get(klass);
        if (excludedSizes.isEmpty()) {
            return;
        }
        sizeList.removeAll(excludedSizes);
    }
}

