/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCharacteristics;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.SupportedSurfaceCombination;
import androidx.camera.camera2.internal.TemplateTypeUtil;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.AttachedSurfaceInfo;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageCaptureConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.streamsharing.StreamSharingConfig;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@RequiresApi(value=21)
public final class StreamUseCaseUtil {
    private static final String TAG = "Camera2CameraImpl";
    public static final Config.Option<Long> STREAM_USE_CASE_STREAM_SPEC_OPTION = Config.Option.create((String)"camera2.streamSpec.streamUseCase", Long.TYPE);
    private static final Map<Long, Set<UseCaseConfigFactory.CaptureType>> STREAM_USE_CASE_TO_ELIGIBLE_CAPTURE_TYPES_MAP = new HashMap<Long, Set<UseCaseConfigFactory.CaptureType>>();
    private static final Map<Long, Set<UseCaseConfigFactory.CaptureType>> STREAM_USE_CASE_TO_ELIGIBLE_STREAM_SHARING_CHILDREN_TYPES_MAP = new HashMap<Long, Set<UseCaseConfigFactory.CaptureType>>();

    private StreamUseCaseUtil() {
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    public static void populateSurfaceToStreamUseCaseMapping(@NonNull Collection<SessionConfig> sessionConfigs, @NonNull Collection<UseCaseConfig<?>> useCaseConfigs, @NonNull Map<DeferrableSurface, Long> streamUseCaseMap) {
        int position = 0;
        boolean hasStreamUseCase = false;
        ArrayList useCaseConfigArrayList = new ArrayList(useCaseConfigs);
        for (SessionConfig sessionConfig : sessionConfigs) {
            if (sessionConfig.getImplementationOptions().containsOption(STREAM_USE_CASE_STREAM_SPEC_OPTION) && sessionConfig.getSurfaces().size() != 1) {
                Logger.e((String)TAG, (String)String.format("SessionConfig has stream use case but also contains %d surfaces, abort populateSurfaceToStreamUseCaseMapping().", sessionConfig.getSurfaces().size()));
                return;
            }
            if (!sessionConfig.getImplementationOptions().containsOption(STREAM_USE_CASE_STREAM_SPEC_OPTION)) continue;
            hasStreamUseCase = true;
            break;
        }
        if (hasStreamUseCase) {
            for (SessionConfig sessionConfig : sessionConfigs) {
                if (useCaseConfigArrayList.get(position).getCaptureType() == UseCaseConfigFactory.CaptureType.METERING_REPEATING) {
                    streamUseCaseMap.put((DeferrableSurface)sessionConfig.getSurfaces().get(0), 1L);
                } else if (sessionConfig.getImplementationOptions().containsOption(STREAM_USE_CASE_STREAM_SPEC_OPTION)) {
                    streamUseCaseMap.put((DeferrableSurface)sessionConfig.getSurfaces().get(0), (Long)sessionConfig.getImplementationOptions().retrieveOption(STREAM_USE_CASE_STREAM_SPEC_OPTION));
                }
                ++position;
            }
        }
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    @NonNull
    public static Camera2ImplConfig getStreamSpecImplementationOptions(@NonNull UseCaseConfig<?> useCaseConfig) {
        MutableOptionsBundle optionsBundle = MutableOptionsBundle.create();
        if (useCaseConfig.containsOption(Camera2ImplConfig.STREAM_USE_CASE_OPTION)) {
            optionsBundle.insertOption(Camera2ImplConfig.STREAM_USE_CASE_OPTION, (Object)((Long)useCaseConfig.retrieveOption(Camera2ImplConfig.STREAM_USE_CASE_OPTION)));
        }
        if (useCaseConfig.containsOption(UseCaseConfig.OPTION_ZSL_DISABLED)) {
            optionsBundle.insertOption(UseCaseConfig.OPTION_ZSL_DISABLED, (Object)((Boolean)useCaseConfig.retrieveOption(UseCaseConfig.OPTION_ZSL_DISABLED)));
        }
        if (useCaseConfig.containsOption(ImageCaptureConfig.OPTION_IMAGE_CAPTURE_MODE)) {
            optionsBundle.insertOption(ImageCaptureConfig.OPTION_IMAGE_CAPTURE_MODE, (Object)((Integer)useCaseConfig.retrieveOption(ImageCaptureConfig.OPTION_IMAGE_CAPTURE_MODE)));
        }
        if (useCaseConfig.containsOption(UseCaseConfig.OPTION_INPUT_FORMAT)) {
            optionsBundle.insertOption(UseCaseConfig.OPTION_INPUT_FORMAT, (Object)((Integer)useCaseConfig.retrieveOption(UseCaseConfig.OPTION_INPUT_FORMAT)));
        }
        return new Camera2ImplConfig((Config)optionsBundle);
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    public static boolean isStreamUseCaseSupported(@NonNull CameraCharacteristicsCompat characteristicsCompat) {
        if (Build.VERSION.SDK_INT < 33) {
            return false;
        }
        long[] availableStreamUseCases = (long[])characteristicsCompat.get(CameraCharacteristics.SCALER_AVAILABLE_STREAM_USE_CASES);
        return availableStreamUseCases != null && availableStreamUseCases.length != 0;
    }

    public static boolean shouldUseStreamUseCase(@NonNull SupportedSurfaceCombination.FeatureSettings featureSettings) {
        return featureSettings.getCameraMode() == 0 && featureSettings.getRequiredMaxBitDepth() == 8;
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    public static boolean populateStreamUseCaseStreamSpecOptionWithInteropOverride(@NonNull CameraCharacteristicsCompat characteristicsCompat, @NonNull List<AttachedSurfaceInfo> attachedSurfaces, @NonNull Map<UseCaseConfig<?>, StreamSpec> suggestedStreamSpecMap, @NonNull Map<AttachedSurfaceInfo, StreamSpec> attachedSurfaceStreamSpecMap) {
        if (Build.VERSION.SDK_INT < 33) {
            return false;
        }
        ArrayList newUseCaseConfigs = new ArrayList(suggestedStreamSpecMap.keySet());
        for (AttachedSurfaceInfo attachedSurfaceInfo : attachedSurfaces) {
            Preconditions.checkNotNull((Object)attachedSurfaceInfo.getImplementationOptions());
        }
        for (UseCaseConfig useCaseConfig : newUseCaseConfigs) {
            Preconditions.checkNotNull((Object)((StreamSpec)Preconditions.checkNotNull((Object)suggestedStreamSpecMap.get(useCaseConfig))).getImplementationOptions());
        }
        long[] availableStreamUseCases = (long[])characteristicsCompat.get(CameraCharacteristics.SCALER_AVAILABLE_STREAM_USE_CASES);
        if (availableStreamUseCases == null || availableStreamUseCases.length == 0) {
            return false;
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        Object object = availableStreamUseCases;
        int n = ((long[])object).length;
        for (int i = 0; i < n; ++i) {
            Long availableStreamUseCase = object[i];
            hashSet.add(availableStreamUseCase);
        }
        if (StreamUseCaseUtil.isValidCamera2InteropOverride(attachedSurfaces, newUseCaseConfigs, hashSet)) {
            object = attachedSurfaces.iterator();
            while (object.hasNext()) {
                AttachedSurfaceInfo attachedSurfaceInfo = (AttachedSurfaceInfo)object.next();
                Config oldImplementationOptions = attachedSurfaceInfo.getImplementationOptions();
                Config newImplementationOptions = StreamUseCaseUtil.getUpdatedImplementationOptionsWithUseCaseStreamSpecOption(oldImplementationOptions, (Long)oldImplementationOptions.retrieveOption(Camera2ImplConfig.STREAM_USE_CASE_OPTION));
                if (newImplementationOptions == null) continue;
                attachedSurfaceStreamSpecMap.put(attachedSurfaceInfo, attachedSurfaceInfo.toStreamSpec(newImplementationOptions));
            }
            for (UseCaseConfig useCaseConfig : newUseCaseConfigs) {
                StreamSpec oldStreamSpec = suggestedStreamSpecMap.get(useCaseConfig);
                Config oldImplementationOptions = oldStreamSpec.getImplementationOptions();
                Config newImplementationOptions = StreamUseCaseUtil.getUpdatedImplementationOptionsWithUseCaseStreamSpecOption(oldImplementationOptions, (Long)oldImplementationOptions.retrieveOption(Camera2ImplConfig.STREAM_USE_CASE_OPTION));
                if (newImplementationOptions == null) continue;
                StreamSpec newStreamSpec = oldStreamSpec.toBuilder().setImplementationOptions(newImplementationOptions).build();
                suggestedStreamSpecMap.put(useCaseConfig, newStreamSpec);
            }
            return true;
        }
        return false;
    }

    public static boolean areStreamUseCasesAvailableForSurfaceConfigs(@NonNull CameraCharacteristicsCompat characteristicsCompat, @NonNull List<SurfaceConfig> surfaceConfigs) {
        if (Build.VERSION.SDK_INT < 33) {
            return false;
        }
        long[] availableStreamUseCases = (long[])characteristicsCompat.get(CameraCharacteristics.SCALER_AVAILABLE_STREAM_USE_CASES);
        if (availableStreamUseCases == null || availableStreamUseCases.length == 0) {
            return false;
        }
        HashSet<Long> availableStreamUseCaseSet = new HashSet<Long>();
        Object object = availableStreamUseCases;
        int n = ((long[])object).length;
        for (int i = 0; i < n; ++i) {
            Long availableStreamUseCase = object[i];
            availableStreamUseCaseSet.add(availableStreamUseCase);
        }
        object = surfaceConfigs.iterator();
        while (object.hasNext()) {
            SurfaceConfig surfaceConfig = (SurfaceConfig)object.next();
            if (availableStreamUseCaseSet.contains(surfaceConfig.getStreamUseCase())) continue;
            return false;
        }
        return true;
    }

    private static boolean isEligibleCaptureType(UseCaseConfigFactory.CaptureType captureType, long streamUseCase, List<UseCaseConfigFactory.CaptureType> streamSharingTypes) {
        if (Build.VERSION.SDK_INT < 33) {
            return false;
        }
        if (captureType == UseCaseConfigFactory.CaptureType.STREAM_SHARING) {
            if (!STREAM_USE_CASE_TO_ELIGIBLE_STREAM_SHARING_CHILDREN_TYPES_MAP.containsKey(streamUseCase)) {
                return false;
            }
            Set<UseCaseConfigFactory.CaptureType> captureTypes = STREAM_USE_CASE_TO_ELIGIBLE_STREAM_SHARING_CHILDREN_TYPES_MAP.get(streamUseCase);
            if (streamSharingTypes.size() != captureTypes.size()) {
                return false;
            }
            for (UseCaseConfigFactory.CaptureType childType : streamSharingTypes) {
                if (captureTypes.contains(childType)) continue;
                return false;
            }
            return true;
        }
        return STREAM_USE_CASE_TO_ELIGIBLE_CAPTURE_TYPES_MAP.containsKey(streamUseCase) && STREAM_USE_CASE_TO_ELIGIBLE_CAPTURE_TYPES_MAP.get(streamUseCase).contains(captureType);
    }

    public static boolean areCaptureTypesEligible(@NonNull Map<Integer, AttachedSurfaceInfo> surfaceConfigIndexAttachedSurfaceInfoMap, @NonNull Map<Integer, UseCaseConfig<?>> surfaceConfigIndexUseCaseConfigMap, @NonNull List<SurfaceConfig> surfaceConfigsWithStreamUseCase) {
        for (int i = 0; i < surfaceConfigsWithStreamUseCase.size(); ++i) {
            long streamUseCase = surfaceConfigsWithStreamUseCase.get(i).getStreamUseCase();
            if (surfaceConfigIndexAttachedSurfaceInfoMap.containsKey(i)) {
                AttachedSurfaceInfo attachedSurfaceInfo = surfaceConfigIndexAttachedSurfaceInfoMap.get(i);
                if (StreamUseCaseUtil.isEligibleCaptureType(attachedSurfaceInfo.getCaptureTypes().size() == 1 ? (UseCaseConfigFactory.CaptureType)attachedSurfaceInfo.getCaptureTypes().get(0) : UseCaseConfigFactory.CaptureType.STREAM_SHARING, streamUseCase, attachedSurfaceInfo.getCaptureTypes())) continue;
                return false;
            }
            if (surfaceConfigIndexUseCaseConfigMap.containsKey(i)) {
                UseCaseConfig<?> newUseCaseConfig = surfaceConfigIndexUseCaseConfigMap.get(i);
                if (StreamUseCaseUtil.isEligibleCaptureType(newUseCaseConfig.getCaptureType(), streamUseCase, newUseCaseConfig.getCaptureType() == UseCaseConfigFactory.CaptureType.STREAM_SHARING ? ((StreamSharingConfig)newUseCaseConfig).getCaptureTypes() : Collections.emptyList())) continue;
                return false;
            }
            throw new AssertionError((Object)"SurfaceConfig does not map to any use case");
        }
        return true;
    }

    public static void populateStreamUseCaseStreamSpecOptionWithSupportedSurfaceConfigs(@NonNull Map<UseCaseConfig<?>, StreamSpec> suggestedStreamSpecMap, @NonNull Map<AttachedSurfaceInfo, StreamSpec> attachedSurfaceStreamSpecMap, @NonNull Map<Integer, AttachedSurfaceInfo> surfaceConfigIndexAttachedSurfaceInfoMap, @NonNull Map<Integer, UseCaseConfig<?>> surfaceConfigIndexUseCaseConfigMap, @NonNull List<SurfaceConfig> surfaceConfigsWithStreamUseCase) {
        for (int i = 0; i < surfaceConfigsWithStreamUseCase.size(); ++i) {
            long streamUseCase = surfaceConfigsWithStreamUseCase.get(i).getStreamUseCase();
            if (surfaceConfigIndexAttachedSurfaceInfoMap.containsKey(i)) {
                AttachedSurfaceInfo attachedSurfaceInfo = surfaceConfigIndexAttachedSurfaceInfoMap.get(i);
                Config oldImplementationOptions = attachedSurfaceInfo.getImplementationOptions();
                Config newImplementationOptions = StreamUseCaseUtil.getUpdatedImplementationOptionsWithUseCaseStreamSpecOption(oldImplementationOptions, streamUseCase);
                if (newImplementationOptions == null) continue;
                attachedSurfaceStreamSpecMap.put(attachedSurfaceInfo, attachedSurfaceInfo.toStreamSpec(newImplementationOptions));
                continue;
            }
            if (surfaceConfigIndexUseCaseConfigMap.containsKey(i)) {
                UseCaseConfig<?> newUseCaseConfig = surfaceConfigIndexUseCaseConfigMap.get(i);
                StreamSpec oldStreamSpec = suggestedStreamSpecMap.get(newUseCaseConfig);
                Config oldImplementationOptions = oldStreamSpec.getImplementationOptions();
                Config newImplementationOptions = StreamUseCaseUtil.getUpdatedImplementationOptionsWithUseCaseStreamSpecOption(oldImplementationOptions, streamUseCase);
                if (newImplementationOptions == null) continue;
                StreamSpec newStreamSpec = oldStreamSpec.toBuilder().setImplementationOptions(newImplementationOptions).build();
                suggestedStreamSpecMap.put(newUseCaseConfig, newStreamSpec);
                continue;
            }
            throw new AssertionError((Object)"SurfaceConfig does not map to any use case");
        }
    }

    @Nullable
    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    private static Config getUpdatedImplementationOptionsWithUseCaseStreamSpecOption(Config oldImplementationOptions, long streamUseCase) {
        if (oldImplementationOptions.containsOption(STREAM_USE_CASE_STREAM_SPEC_OPTION) && (Long)oldImplementationOptions.retrieveOption(STREAM_USE_CASE_STREAM_SPEC_OPTION) == streamUseCase) {
            return null;
        }
        MutableOptionsBundle optionsBundle = MutableOptionsBundle.from((Config)oldImplementationOptions);
        optionsBundle.insertOption(STREAM_USE_CASE_STREAM_SPEC_OPTION, (Object)streamUseCase);
        return new Camera2ImplConfig((Config)optionsBundle);
    }

    public static boolean containsZslUseCase(@NonNull List<AttachedSurfaceInfo> attachedSurfaces, @NonNull List<UseCaseConfig<?>> newUseCaseConfigs) {
        for (AttachedSurfaceInfo attachedSurfaceInfo : attachedSurfaces) {
            List captureTypes = attachedSurfaceInfo.getCaptureTypes();
            UseCaseConfigFactory.CaptureType captureType = (UseCaseConfigFactory.CaptureType)captureTypes.get(0);
            if (!StreamUseCaseUtil.isZslUseCase(attachedSurfaceInfo.getImplementationOptions(), captureType)) continue;
            return true;
        }
        for (UseCaseConfig useCaseConfig : newUseCaseConfigs) {
            if (!StreamUseCaseUtil.isZslUseCase((Config)useCaseConfig, useCaseConfig.getCaptureType())) continue;
            return true;
        }
        return false;
    }

    private static boolean isZslUseCase(Config config, UseCaseConfigFactory.CaptureType captureType) {
        if (((Boolean)config.retrieveOption(UseCaseConfig.OPTION_ZSL_DISABLED, (Object)false)).booleanValue()) {
            return false;
        }
        if (!config.containsOption(ImageCaptureConfig.OPTION_IMAGE_CAPTURE_MODE)) {
            return false;
        }
        int captureMode = (Integer)config.retrieveOption(ImageCaptureConfig.OPTION_IMAGE_CAPTURE_MODE);
        return TemplateTypeUtil.getSessionConfigTemplateType(captureType, captureMode) == 5;
    }

    private static boolean areStreamUseCasesAvailable(Set<Long> availableStreamUseCasesSet, Set<Long> streamUseCases) {
        for (Long streamUseCase : streamUseCases) {
            if (availableStreamUseCasesSet.contains(streamUseCase)) continue;
            return false;
        }
        return true;
    }

    private static void throwInvalidCamera2InteropOverrideException() {
        throw new IllegalArgumentException("Either all use cases must have non-default stream use case assigned or none should have it");
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    private static boolean isValidCamera2InteropOverride(List<AttachedSurfaceInfo> attachedSurfaces, List<UseCaseConfig<?>> newUseCaseConfigs, Set<Long> availableStreamUseCases) {
        long streamUseCaseOverride;
        HashSet<Long> streamUseCases = new HashSet<Long>();
        boolean hasNonDefaultStreamUseCase = false;
        boolean hasDefaultOrNullStreamUseCase = false;
        Iterator<AttachedSurfaceInfo> iterator = attachedSurfaces.iterator();
        if (iterator.hasNext()) {
            AttachedSurfaceInfo attachedSurfaceInfo = iterator.next();
            if (!attachedSurfaceInfo.getImplementationOptions().containsOption(Camera2ImplConfig.STREAM_USE_CASE_OPTION)) {
                hasDefaultOrNullStreamUseCase = true;
            } else {
                streamUseCaseOverride = (Long)attachedSurfaceInfo.getImplementationOptions().retrieveOption(Camera2ImplConfig.STREAM_USE_CASE_OPTION);
                if (streamUseCaseOverride == 0L) {
                    hasDefaultOrNullStreamUseCase = true;
                } else {
                    hasNonDefaultStreamUseCase = true;
                }
            }
        }
        for (UseCaseConfig useCaseConfig : newUseCaseConfigs) {
            if (!useCaseConfig.containsOption(Camera2ImplConfig.STREAM_USE_CASE_OPTION)) {
                hasDefaultOrNullStreamUseCase = true;
                if (!hasNonDefaultStreamUseCase) continue;
                StreamUseCaseUtil.throwInvalidCamera2InteropOverrideException();
                continue;
            }
            streamUseCaseOverride = (Long)useCaseConfig.retrieveOption(Camera2ImplConfig.STREAM_USE_CASE_OPTION);
            if (streamUseCaseOverride == 0L) {
                hasDefaultOrNullStreamUseCase = true;
                if (!hasNonDefaultStreamUseCase) continue;
                StreamUseCaseUtil.throwInvalidCamera2InteropOverrideException();
                continue;
            }
            hasNonDefaultStreamUseCase = true;
            if (hasDefaultOrNullStreamUseCase) {
                StreamUseCaseUtil.throwInvalidCamera2InteropOverrideException();
            }
            streamUseCases.add(streamUseCaseOverride);
        }
        return !hasDefaultOrNullStreamUseCase && StreamUseCaseUtil.areStreamUseCasesAvailable(availableStreamUseCases, streamUseCases);
    }

    static {
        if (Build.VERSION.SDK_INT >= 33) {
            HashSet<UseCaseConfigFactory.CaptureType> captureTypes = new HashSet<UseCaseConfigFactory.CaptureType>();
            captureTypes.add(UseCaseConfigFactory.CaptureType.PREVIEW);
            STREAM_USE_CASE_TO_ELIGIBLE_CAPTURE_TYPES_MAP.put(4L, captureTypes);
            captureTypes = new HashSet();
            captureTypes.add(UseCaseConfigFactory.CaptureType.PREVIEW);
            captureTypes.add(UseCaseConfigFactory.CaptureType.IMAGE_ANALYSIS);
            STREAM_USE_CASE_TO_ELIGIBLE_CAPTURE_TYPES_MAP.put(1L, captureTypes);
            captureTypes = new HashSet();
            captureTypes.add(UseCaseConfigFactory.CaptureType.IMAGE_CAPTURE);
            STREAM_USE_CASE_TO_ELIGIBLE_CAPTURE_TYPES_MAP.put(2L, captureTypes);
            captureTypes = new HashSet();
            captureTypes.add(UseCaseConfigFactory.CaptureType.VIDEO_CAPTURE);
            STREAM_USE_CASE_TO_ELIGIBLE_CAPTURE_TYPES_MAP.put(3L, captureTypes);
            captureTypes = new HashSet();
            captureTypes.add(UseCaseConfigFactory.CaptureType.PREVIEW);
            captureTypes.add(UseCaseConfigFactory.CaptureType.IMAGE_CAPTURE);
            captureTypes.add(UseCaseConfigFactory.CaptureType.VIDEO_CAPTURE);
            STREAM_USE_CASE_TO_ELIGIBLE_STREAM_SHARING_CHILDREN_TYPES_MAP.put(4L, captureTypes);
            captureTypes = new HashSet();
            captureTypes.add(UseCaseConfigFactory.CaptureType.PREVIEW);
            captureTypes.add(UseCaseConfigFactory.CaptureType.VIDEO_CAPTURE);
            STREAM_USE_CASE_TO_ELIGIBLE_STREAM_SHARING_CHILDREN_TYPES_MAP.put(3L, captureTypes);
        }
    }
}

