/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.content.Context;
import android.graphics.Point;
import android.hardware.display.DisplayManager;
import android.util.Size;
import android.view.Display;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.internal.compat.workaround.DisplaySizeCorrector;
import androidx.camera.camera2.internal.compat.workaround.MaxPreviewSize;
import androidx.camera.core.internal.utils.SizeUtil;

@RequiresApi(value=21)
public class DisplayInfoManager {
    private static final Size MAX_PREVIEW_SIZE = new Size(1920, 1080);
    private static final Size ABNORMAL_DISPLAY_SIZE_THRESHOLD = new Size(320, 240);
    private static final Size FALLBACK_DISPLAY_SIZE = new Size(640, 480);
    private static final Object INSTANCE_LOCK = new Object();
    private static volatile DisplayInfoManager sInstance;
    @NonNull
    private final DisplayManager mDisplayManager;
    private volatile Size mPreviewSize = null;
    private final MaxPreviewSize mMaxPreviewSize = new MaxPreviewSize();
    private final DisplaySizeCorrector mDisplaySizeCorrector = new DisplaySizeCorrector();

    private DisplayInfoManager(@NonNull Context context) {
        this.mDisplayManager = (DisplayManager)context.getSystemService("display");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static DisplayInfoManager getInstance(@NonNull Context context) {
        if (sInstance == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = new DisplayInfoManager(context);
                }
            }
        }
        return sInstance;
    }

    @VisibleForTesting
    static void releaseInstance() {
        sInstance = null;
    }

    void refresh() {
        this.mPreviewSize = this.calculatePreviewSize();
    }

    @NonNull
    public Display getMaxSizeDisplay(boolean skipStateOffDisplay) {
        Display[] displays = this.mDisplayManager.getDisplays();
        if (displays.length == 1) {
            return displays[0];
        }
        Display maxDisplay = this.getMaxSizeDisplayInternal(displays, skipStateOffDisplay);
        if (maxDisplay == null && skipStateOffDisplay) {
            maxDisplay = this.getMaxSizeDisplayInternal(displays, false);
        }
        if (maxDisplay == null) {
            throw new IllegalArgumentException("No display can be found from the input display manager!");
        }
        return maxDisplay;
    }

    @Nullable
    private Display getMaxSizeDisplayInternal(@NonNull Display[] displays, boolean skipStateOffDisplay) {
        Display maxDisplay = null;
        int maxDisplaySize = -1;
        for (Display display : displays) {
            if (skipStateOffDisplay && display.getState() == 1) continue;
            Point displaySize = new Point();
            display.getRealSize(displaySize);
            if (displaySize.x * displaySize.y <= maxDisplaySize) continue;
            maxDisplaySize = displaySize.x * displaySize.y;
            maxDisplay = display;
        }
        return maxDisplay;
    }

    @NonNull
    Size getPreviewSize() {
        if (this.mPreviewSize != null) {
            return this.mPreviewSize;
        }
        this.mPreviewSize = this.calculatePreviewSize();
        return this.mPreviewSize;
    }

    private Size calculatePreviewSize() {
        Size displayViewSize = this.getCorrectedDisplaySize();
        if (displayViewSize.getWidth() * displayViewSize.getHeight() > MAX_PREVIEW_SIZE.getWidth() * MAX_PREVIEW_SIZE.getHeight()) {
            displayViewSize = MAX_PREVIEW_SIZE;
        }
        return this.mMaxPreviewSize.getMaxPreviewResolution(displayViewSize);
    }

    @NonNull
    private Size getCorrectedDisplaySize() {
        Point displaySize = new Point();
        Display display = this.getMaxSizeDisplay(false);
        display.getRealSize(displaySize);
        Size displayViewSize = new Size(displaySize.x, displaySize.y);
        if (SizeUtil.isSmallerByArea((Size)displayViewSize, (Size)ABNORMAL_DISPLAY_SIZE_THRESHOLD) && (displayViewSize = this.mDisplaySizeCorrector.getDisplaySize()) == null) {
            displayViewSize = FALLBACK_DISPLAY_SIZE;
        }
        if (displayViewSize.getHeight() > displayViewSize.getWidth()) {
            displayViewSize = new Size(displayViewSize.getHeight(), displayViewSize.getWidth());
        }
        return displayViewSize;
    }
}

