/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.util.Range;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.ZoomControl;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.core.CameraControl;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;

@RequiresApi(value=30)
final class AndroidRZoomImpl
implements ZoomControl.ZoomImpl {
    public static final float DEFAULT_ZOOM_RATIO = 1.0f;
    private final CameraCharacteristicsCompat mCameraCharacteristics;
    private final Range<Float> mZoomRatioRange;
    private float mCurrentZoomRatio = 1.0f;
    private CallbackToFutureAdapter.Completer<Void> mPendingZoomRatioCompleter;
    private float mPendingZoomRatio = 1.0f;

    AndroidRZoomImpl(@NonNull CameraCharacteristicsCompat cameraCharacteristics) {
        this.mCameraCharacteristics = cameraCharacteristics;
        this.mZoomRatioRange = (Range)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_ZOOM_RATIO_RANGE);
    }

    @Override
    public float getMinZoom() {
        return ((Float)this.mZoomRatioRange.getLower()).floatValue();
    }

    @Override
    public float getMaxZoom() {
        return ((Float)this.mZoomRatioRange.getUpper()).floatValue();
    }

    @Override
    public void addRequestOption(@NonNull Camera2ImplConfig.Builder builder) {
        builder.setCaptureRequestOption(CaptureRequest.CONTROL_ZOOM_RATIO, Float.valueOf(this.mCurrentZoomRatio));
    }

    @Override
    public void resetZoom() {
        this.mCurrentZoomRatio = 1.0f;
        if (this.mPendingZoomRatioCompleter != null) {
            this.mPendingZoomRatioCompleter.setException((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
            this.mPendingZoomRatioCompleter = null;
        }
    }

    @Override
    public void setZoomRatio(float zoomRatio, @NonNull CallbackToFutureAdapter.Completer<Void> completer) {
        this.mCurrentZoomRatio = zoomRatio;
        if (this.mPendingZoomRatioCompleter != null) {
            this.mPendingZoomRatioCompleter.setException((Throwable)new CameraControl.OperationCanceledException("There is a new zoomRatio being set"));
        }
        this.mPendingZoomRatio = this.mCurrentZoomRatio;
        this.mPendingZoomRatioCompleter = completer;
    }

    @Override
    public void onCaptureResult(@NonNull TotalCaptureResult captureResult) {
        if (this.mPendingZoomRatioCompleter != null) {
            Float zoomRatioFloat;
            CaptureRequest request = captureResult.getRequest();
            Float f = zoomRatioFloat = request == null ? null : (Float)request.get(CaptureRequest.CONTROL_ZOOM_RATIO);
            if (zoomRatioFloat == null) {
                return;
            }
            float zoomRatio = zoomRatioFloat.floatValue();
            if (this.mPendingZoomRatio == zoomRatio) {
                this.mPendingZoomRatioCompleter.set(null);
                this.mPendingZoomRatioCompleter = null;
            }
        }
    }

    @Override
    @NonNull
    public Rect getCropSensorRegion() {
        return (Rect)Preconditions.checkNotNull((Object)((Rect)this.mCameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE)));
    }
}

