/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.graphics.Rect;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.os.Build;
import android.util.ArrayMap;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.Camera2CapturePipeline;
import androidx.camera.camera2.internal.CaptureCallbackContainer;
import androidx.camera.camera2.internal.ExposureControl;
import androidx.camera.camera2.internal.FocusMeteringControl;
import androidx.camera.camera2.internal.TorchControl;
import androidx.camera.camera2.internal.ZoomControl;
import androidx.camera.camera2.internal.ZslControl;
import androidx.camera.camera2.internal.ZslControlImpl;
import androidx.camera.camera2.internal.ZslControlNoOpImpl;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.workaround.AeFpsRange;
import androidx.camera.camera2.internal.compat.workaround.AutoFlashAEModeDisabler;
import androidx.camera.camera2.interop.Camera2CameraControl;
import androidx.camera.camera2.interop.CaptureRequestOptions;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraControl;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.FocusMeteringResult;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureFailure;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.TagBundle;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;

@OptIn(markerClass={ExperimentalCamera2Interop.class})
@RequiresApi(value=21)
public class Camera2CameraControlImpl
implements CameraControlInternal {
    private static final String TAG = "Camera2CameraControlImp";
    private static final int DEFAULT_TEMPLATE = 1;
    @VisibleForTesting
    final CameraControlSessionCallback mSessionCallback;
    final Executor mExecutor;
    private final Object mLock = new Object();
    private final CameraCharacteristicsCompat mCameraCharacteristics;
    private final CameraControlInternal.ControlUpdateCallback mControlUpdateCallback;
    private final SessionConfig.Builder mSessionConfigBuilder = new SessionConfig.Builder();
    private final FocusMeteringControl mFocusMeteringControl;
    private final ZoomControl mZoomControl;
    private final TorchControl mTorchControl;
    private final ExposureControl mExposureControl;
    @VisibleForTesting
    ZslControl mZslControl;
    private final Camera2CameraControl mCamera2CameraControl;
    private final Camera2CapturePipeline mCamera2CapturePipeline;
    @GuardedBy(value="mLock")
    private int mUseCount = 0;
    private volatile boolean mIsTorchOn = false;
    private volatile int mFlashMode = 2;
    private final AeFpsRange mAeFpsRange;
    private final AutoFlashAEModeDisabler mAutoFlashAEModeDisabler = new AutoFlashAEModeDisabler();
    static final String TAG_SESSION_UPDATE_ID = "CameraControlSessionUpdateId";
    private final AtomicLong mNextSessionUpdateId = new AtomicLong(0L);
    @NonNull
    private volatile ListenableFuture<Void> mFlashModeChangeSessionUpdateFuture = Futures.immediateFuture(null);
    private int mTemplate = 1;
    private long mCurrentSessionUpdateId = 0L;
    private final CameraCaptureCallbackSet mCameraCaptureCallbackSet = new CameraCaptureCallbackSet();

    @VisibleForTesting
    Camera2CameraControlImpl(@NonNull CameraCharacteristicsCompat cameraCharacteristics, @NonNull ScheduledExecutorService scheduler, @NonNull Executor executor, @NonNull CameraControlInternal.ControlUpdateCallback controlUpdateCallback) {
        this(cameraCharacteristics, scheduler, executor, controlUpdateCallback, new Quirks(new ArrayList()));
    }

    Camera2CameraControlImpl(@NonNull CameraCharacteristicsCompat cameraCharacteristics, @NonNull ScheduledExecutorService scheduler, @NonNull Executor executor, @NonNull CameraControlInternal.ControlUpdateCallback controlUpdateCallback, @NonNull Quirks cameraQuirks) {
        this.mCameraCharacteristics = cameraCharacteristics;
        this.mControlUpdateCallback = controlUpdateCallback;
        this.mExecutor = executor;
        this.mSessionCallback = new CameraControlSessionCallback(this.mExecutor);
        this.mSessionConfigBuilder.setTemplateType(this.mTemplate);
        this.mSessionConfigBuilder.addRepeatingCameraCaptureCallback((CameraCaptureCallback)CaptureCallbackContainer.create(this.mSessionCallback));
        this.mSessionConfigBuilder.addRepeatingCameraCaptureCallback((CameraCaptureCallback)this.mCameraCaptureCallbackSet);
        this.mExposureControl = new ExposureControl(this, this.mCameraCharacteristics, this.mExecutor);
        this.mFocusMeteringControl = new FocusMeteringControl(this, scheduler, this.mExecutor, cameraQuirks);
        this.mZoomControl = new ZoomControl(this, this.mCameraCharacteristics, this.mExecutor);
        this.mTorchControl = new TorchControl(this, this.mCameraCharacteristics, this.mExecutor);
        this.mZslControl = Build.VERSION.SDK_INT >= 23 ? new ZslControlImpl(this.mCameraCharacteristics) : new ZslControlNoOpImpl();
        this.mAeFpsRange = new AeFpsRange(cameraQuirks);
        this.mCamera2CameraControl = new Camera2CameraControl(this, this.mExecutor);
        this.mCamera2CapturePipeline = new Camera2CapturePipeline(this, this.mCameraCharacteristics, cameraQuirks, this.mExecutor);
        this.mExecutor.execute(() -> this.addCaptureResultListener(this.mCamera2CameraControl.getCaptureRequestListener()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementUseCount() {
        Object object = this.mLock;
        synchronized (object) {
            ++this.mUseCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementUseCount() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUseCount == 0) {
                throw new IllegalStateException("Decrementing use count occurs more times than incrementing");
            }
            --this.mUseCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getUseCount() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUseCount;
        }
    }

    @NonNull
    public ZoomControl getZoomControl() {
        return this.mZoomControl;
    }

    @NonNull
    public FocusMeteringControl getFocusMeteringControl() {
        return this.mFocusMeteringControl;
    }

    @NonNull
    public TorchControl getTorchControl() {
        return this.mTorchControl;
    }

    @NonNull
    public ExposureControl getExposureControl() {
        return this.mExposureControl;
    }

    @NonNull
    public ZslControl getZslControl() {
        return this.mZslControl;
    }

    @NonNull
    public Camera2CameraControl getCamera2CameraControl() {
        return this.mCamera2CameraControl;
    }

    public void addInteropConfig(@NonNull Config config) {
        ListenableFuture<Void> future = this.mCamera2CameraControl.addCaptureRequestOptions(CaptureRequestOptions.Builder.from(config).build());
        future.addListener(() -> {}, CameraXExecutors.directExecutor());
    }

    public void clearInteropConfig() {
        ListenableFuture<Void> future = this.mCamera2CameraControl.clearCaptureRequestOptions();
        future.addListener(() -> {}, CameraXExecutors.directExecutor());
    }

    @NonNull
    public Config getInteropConfig() {
        return this.mCamera2CameraControl.getCamera2ImplConfig();
    }

    void setActive(boolean isActive) {
        this.mFocusMeteringControl.setActive(isActive);
        this.mZoomControl.setActive(isActive);
        this.mTorchControl.setActive(isActive);
        this.mExposureControl.setActive(isActive);
        this.mCamera2CameraControl.setActive(isActive);
    }

    public void setPreviewAspectRatio(@Nullable Rational previewAspectRatio) {
        this.mFocusMeteringControl.setPreviewAspectRatio(previewAspectRatio);
    }

    @NonNull
    public ListenableFuture<FocusMeteringResult> startFocusAndMetering(@NonNull FocusMeteringAction action) {
        if (!this.isControlInUse()) {
            return Futures.immediateFailedFuture((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
        }
        return Futures.nonCancellationPropagating(this.mFocusMeteringControl.startFocusAndMetering(action));
    }

    @NonNull
    public ListenableFuture<Void> cancelFocusAndMetering() {
        if (!this.isControlInUse()) {
            return Futures.immediateFailedFuture((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
        }
        return Futures.nonCancellationPropagating(this.mFocusMeteringControl.cancelFocusAndMetering());
    }

    @NonNull
    public ListenableFuture<Void> setZoomRatio(float ratio) {
        if (!this.isControlInUse()) {
            return Futures.immediateFailedFuture((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
        }
        return Futures.nonCancellationPropagating(this.mZoomControl.setZoomRatio(ratio));
    }

    @NonNull
    public ListenableFuture<Void> setLinearZoom(float linearZoom) {
        if (!this.isControlInUse()) {
            return Futures.immediateFailedFuture((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
        }
        return Futures.nonCancellationPropagating(this.mZoomControl.setLinearZoom(linearZoom));
    }

    public int getFlashMode() {
        return this.mFlashMode;
    }

    public void setFlashMode(int flashMode) {
        if (!this.isControlInUse()) {
            Logger.w((String)TAG, (String)"Camera is not active.");
            return;
        }
        this.mFlashMode = flashMode;
        this.mFlashModeChangeSessionUpdateFuture = this.updateSessionConfigAsync();
    }

    public void addZslConfig(@NonNull Size resolution, @NonNull SessionConfig.Builder sessionConfigBuilder) {
        this.mZslControl.addZslConfig(resolution, sessionConfigBuilder);
    }

    public void setZslDisabled(boolean disabled) {
        this.mZslControl.setZslDisabled(disabled);
    }

    @NonNull
    public ListenableFuture<Void> enableTorch(boolean torch) {
        if (!this.isControlInUse()) {
            return Futures.immediateFailedFuture((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
        }
        return Futures.nonCancellationPropagating(this.mTorchControl.enableTorch(torch));
    }

    @NonNull
    private ListenableFuture<Void> waitForSessionUpdateId(long sessionUpdateIdToWait) {
        return CallbackToFutureAdapter.getFuture(completer -> {
            this.addCaptureResultListener(captureResult -> {
                boolean updated = Camera2CameraControlImpl.isSessionUpdated(captureResult, sessionUpdateIdToWait);
                if (updated) {
                    completer.set(null);
                    return true;
                }
                return false;
            });
            return "waitForSessionUpdateId:" + sessionUpdateIdToWait;
        });
    }

    static boolean isSessionUpdated(@NonNull TotalCaptureResult captureResult, long sessionUpdateId) {
        if (captureResult.getRequest() == null) {
            return false;
        }
        Object tag = captureResult.getRequest().getTag();
        if (tag instanceof TagBundle) {
            Long tagLong = (Long)((TagBundle)tag).getTag(TAG_SESSION_UPDATE_ID);
            if (tagLong == null) {
                return false;
            }
            long sessionUpdateIdInCaptureResult = tagLong;
            if (sessionUpdateIdInCaptureResult >= sessionUpdateId) {
                return true;
            }
        }
        return false;
    }

    @NonNull
    public ListenableFuture<Integer> setExposureCompensationIndex(int exposure) {
        if (!this.isControlInUse()) {
            return Futures.immediateFailedFuture((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
        }
        return this.mExposureControl.setExposureCompensationIndex(exposure);
    }

    @NonNull
    public ListenableFuture<List<Void>> submitStillCaptureRequests(@NonNull List<CaptureConfig> captureConfigs, int captureMode, int flashType) {
        if (!this.isControlInUse()) {
            Logger.w((String)TAG, (String)"Camera is not active.");
            return Futures.immediateFailedFuture((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
        }
        int flashMode = this.getFlashMode();
        return FutureChain.from(this.mFlashModeChangeSessionUpdateFuture).transformAsync(v -> this.mCamera2CapturePipeline.submitStillCaptures(captureConfigs, captureMode, flashMode, flashType), this.mExecutor);
    }

    @NonNull
    public SessionConfig getSessionConfig() {
        this.mSessionConfigBuilder.setTemplateType(this.mTemplate);
        this.mSessionConfigBuilder.setImplementationOptions(this.getSessionOptions());
        Object tag = this.mCamera2CameraControl.getCamera2ImplConfig().getCaptureRequestTag(null);
        if (tag != null && tag instanceof Integer) {
            this.mSessionConfigBuilder.addTag("Camera2CameraControl", tag);
        }
        this.mSessionConfigBuilder.addTag(TAG_SESSION_UPDATE_ID, (Object)this.mCurrentSessionUpdateId);
        return this.mSessionConfigBuilder.build();
    }

    void setTemplate(int template) {
        this.mTemplate = template;
        this.mFocusMeteringControl.setTemplate(this.mTemplate);
        this.mCamera2CapturePipeline.setTemplate(this.mTemplate);
    }

    void resetTemplate() {
        this.setTemplate(1);
    }

    private boolean isControlInUse() {
        return this.getUseCount() > 0;
    }

    public void updateSessionConfig() {
        this.mExecutor.execute(this::updateSessionConfigSynchronous);
    }

    @NonNull
    ListenableFuture<Void> updateSessionConfigAsync() {
        ListenableFuture future = CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> {
                long sessionUpdateId = this.updateSessionConfigSynchronous();
                Futures.propagate(this.waitForSessionUpdateId(sessionUpdateId), (CallbackToFutureAdapter.Completer)completer);
            });
            return "updateSessionConfigAsync";
        });
        return Futures.nonCancellationPropagating((ListenableFuture)future);
    }

    long updateSessionConfigSynchronous() {
        this.mCurrentSessionUpdateId = this.mNextSessionUpdateId.getAndIncrement();
        this.mControlUpdateCallback.onCameraControlUpdateSessionConfig();
        return this.mCurrentSessionUpdateId;
    }

    @NonNull
    Rect getCropSensorRegion() {
        return this.mZoomControl.getCropSensorRegion();
    }

    @NonNull
    public Rect getSensorRect() {
        return (Rect)Preconditions.checkNotNull((Object)((Rect)this.mCameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE)));
    }

    void removeCaptureResultListener(@NonNull CaptureResultListener listener) {
        this.mSessionCallback.removeListener(listener);
    }

    void addCaptureResultListener(@NonNull CaptureResultListener listener) {
        this.mSessionCallback.addListener(listener);
    }

    void addSessionCameraCaptureCallback(@NonNull Executor executor, @NonNull CameraCaptureCallback cameraCaptureCallback) {
        this.mExecutor.execute(() -> this.mCameraCaptureCallbackSet.addCaptureCallback(executor, cameraCaptureCallback));
    }

    void removeSessionCameraCaptureCallback(@NonNull CameraCaptureCallback cameraCaptureCallback) {
        this.mExecutor.execute(() -> this.mCameraCaptureCallbackSet.removeCaptureCallback(cameraCaptureCallback));
    }

    void enableTorchInternal(boolean torch) {
        this.mIsTorchOn = torch;
        if (!torch) {
            CaptureConfig.Builder singleRequestBuilder = new CaptureConfig.Builder();
            singleRequestBuilder.setTemplateType(this.mTemplate);
            singleRequestBuilder.setUseRepeatingSurface(true);
            Camera2ImplConfig.Builder configBuilder = new Camera2ImplConfig.Builder();
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_MODE, this.getSupportedAeMode(1));
            configBuilder.setCaptureRequestOption(CaptureRequest.FLASH_MODE, 0);
            singleRequestBuilder.addImplementationOptions((Config)configBuilder.build());
            this.submitCaptureRequestsInternal(Collections.singletonList(singleRequestBuilder.build()));
        }
        this.updateSessionConfigSynchronous();
    }

    boolean isTorchOn() {
        return this.mIsTorchOn;
    }

    void submitCaptureRequestsInternal(List<CaptureConfig> captureConfigs) {
        this.mControlUpdateCallback.onCameraControlCaptureRequests(captureConfigs);
    }

    @VisibleForTesting
    Config getSessionOptions() {
        Camera2ImplConfig.Builder builder = new Camera2ImplConfig.Builder();
        builder.setCaptureRequestOption(CaptureRequest.CONTROL_MODE, 1);
        this.mFocusMeteringControl.addFocusMeteringOptions(builder);
        this.mAeFpsRange.addAeFpsRangeOptions(builder);
        this.mZoomControl.addZoomOption(builder);
        int aeMode = 1;
        if (this.mIsTorchOn) {
            builder.setCaptureRequestOption(CaptureRequest.FLASH_MODE, 2);
        } else {
            switch (this.mFlashMode) {
                case 2: {
                    aeMode = 1;
                    break;
                }
                case 1: {
                    aeMode = 3;
                    break;
                }
                case 0: {
                    aeMode = this.mAutoFlashAEModeDisabler.getCorrectedAeMode(2);
                }
            }
        }
        builder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_MODE, this.getSupportedAeMode(aeMode));
        builder.setCaptureRequestOption(CaptureRequest.CONTROL_AWB_MODE, this.getSupportedAwbMode(1));
        this.mExposureControl.setCaptureRequestOption(builder);
        Camera2ImplConfig currentConfig = this.mCamera2CameraControl.getCamera2ImplConfig();
        Iterator iterator = currentConfig.listOptions().iterator();
        while (iterator.hasNext()) {
            Config.Option option;
            Config.Option objectOpt = option = (Config.Option)iterator.next();
            builder.getMutableConfig().insertOption(objectOpt, Config.OptionPriority.ALWAYS_OVERRIDE, currentConfig.retrieveOption(objectOpt));
        }
        return builder.build();
    }

    int getSupportedAfMode(int preferredMode) {
        int[] modes = (int[])this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (modes == null) {
            return 0;
        }
        if (this.isModeInList(preferredMode, modes)) {
            return preferredMode;
        }
        if (this.isModeInList(4, modes)) {
            return 4;
        }
        if (this.isModeInList(1, modes)) {
            return 1;
        }
        return 0;
    }

    int getSupportedAeMode(int preferredMode) {
        int[] modes = (int[])this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
        if (modes == null) {
            return 0;
        }
        if (this.isModeInList(preferredMode, modes)) {
            return preferredMode;
        }
        if (this.isModeInList(1, modes)) {
            return 1;
        }
        return 0;
    }

    private int getSupportedAwbMode(int preferredMode) {
        int[] modes = (int[])this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES);
        if (modes == null) {
            return 0;
        }
        if (this.isModeInList(preferredMode, modes)) {
            return preferredMode;
        }
        if (this.isModeInList(1, modes)) {
            return 1;
        }
        return 0;
    }

    private boolean isModeInList(int mode, int[] modeList) {
        for (int m : modeList) {
            if (mode != m) continue;
            return true;
        }
        return false;
    }

    int getMaxAfRegionCount() {
        Integer count = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF);
        return count == null ? 0 : count;
    }

    int getMaxAeRegionCount() {
        Integer count = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AE);
        return count == null ? 0 : count;
    }

    int getMaxAwbRegionCount() {
        Integer count = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB);
        return count == null ? 0 : count;
    }

    @VisibleForTesting
    long getCurrentSessionUpdateId() {
        return this.mCurrentSessionUpdateId;
    }

    @RequiresApi(value=21)
    static final class CameraCaptureCallbackSet
    extends CameraCaptureCallback {
        Set<CameraCaptureCallback> mCallbacks = new HashSet<CameraCaptureCallback>();
        Map<CameraCaptureCallback, Executor> mCallbackExecutors = new ArrayMap();

        CameraCaptureCallbackSet() {
        }

        void addCaptureCallback(@NonNull Executor executor, @NonNull CameraCaptureCallback callback) {
            this.mCallbacks.add(callback);
            this.mCallbackExecutors.put(callback, executor);
        }

        void removeCaptureCallback(@NonNull CameraCaptureCallback callback) {
            this.mCallbacks.remove(callback);
            this.mCallbackExecutors.remove(callback);
        }

        public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
            for (CameraCaptureCallback callback : this.mCallbacks) {
                try {
                    this.mCallbackExecutors.get(callback).execute(() -> callback.onCaptureCompleted(cameraCaptureResult));
                }
                catch (RejectedExecutionException e) {
                    Logger.e((String)Camera2CameraControlImpl.TAG, (String)"Executor rejected to invoke onCaptureCompleted.", (Throwable)e);
                }
            }
        }

        public void onCaptureFailed(@NonNull CameraCaptureFailure failure) {
            for (CameraCaptureCallback callback : this.mCallbacks) {
                try {
                    this.mCallbackExecutors.get(callback).execute(() -> callback.onCaptureFailed(failure));
                }
                catch (RejectedExecutionException e) {
                    Logger.e((String)Camera2CameraControlImpl.TAG, (String)"Executor rejected to invoke onCaptureFailed.", (Throwable)e);
                }
            }
        }

        public void onCaptureCancelled() {
            for (CameraCaptureCallback callback : this.mCallbacks) {
                try {
                    this.mCallbackExecutors.get(callback).execute(() -> callback.onCaptureCancelled());
                }
                catch (RejectedExecutionException e) {
                    Logger.e((String)Camera2CameraControlImpl.TAG, (String)"Executor rejected to invoke onCaptureCancelled.", (Throwable)e);
                }
            }
        }
    }

    static final class CameraControlSessionCallback
    extends CameraCaptureSession.CaptureCallback {
        final Set<CaptureResultListener> mResultListeners = new HashSet<CaptureResultListener>();
        private final Executor mExecutor;

        CameraControlSessionCallback(@NonNull Executor executor) {
            this.mExecutor = executor;
        }

        void addListener(@NonNull CaptureResultListener listener) {
            this.mResultListeners.add(listener);
        }

        void removeListener(@NonNull CaptureResultListener listener) {
            this.mResultListeners.remove(listener);
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            this.mExecutor.execute(() -> {
                HashSet<CaptureResultListener> removeSet = new HashSet<CaptureResultListener>();
                for (CaptureResultListener listener : this.mResultListeners) {
                    boolean isFinished = listener.onCaptureResult(result);
                    if (!isFinished) continue;
                    removeSet.add(listener);
                }
                if (!removeSet.isEmpty()) {
                    this.mResultListeners.removeAll(removeSet);
                }
            });
        }
    }

    public static interface CaptureResultListener {
        public boolean onCaptureResult(@NonNull TotalCaptureResult var1);
    }
}

