/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.graphics.drawable;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.StateSet;
import android.util.Xml;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.graphics.drawable.DrawableContainerCompat;
import androidx.appcompat.graphics.drawable.StateListDrawableCompat;
import androidx.appcompat.resources.Compatibility;
import androidx.appcompat.resources.R;
import androidx.appcompat.widget.ResourceManagerInternal;
import androidx.collection.LongSparseArray;
import androidx.collection.SparseArrayCompat;
import androidx.core.content.res.TypedArrayUtils;
import androidx.core.graphics.drawable.TintAwareDrawable;
import androidx.core.util.ObjectsCompat;
import androidx.vectordrawable.graphics.drawable.AnimatedVectorDrawableCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedStateListDrawableCompat
extends StateListDrawableCompat
implements TintAwareDrawable {
    private static final String LOGTAG = AnimatedStateListDrawableCompat.class.getSimpleName();
    private static final String ELEMENT_TRANSITION = "transition";
    private static final String ELEMENT_ITEM = "item";
    private static final String TRANSITION_MISSING_DRAWABLE_ERROR = ": <transition> tag requires a 'drawable' attribute or child tag defining a drawable";
    private static final String TRANSITION_MISSING_FROM_TO_ID = ": <transition> tag requires 'fromId' & 'toId' attributes";
    private static final String ITEM_MISSING_DRAWABLE_ERROR = ": <item> tag requires a 'drawable' attribute or child tag defining a drawable";
    private AnimatedStateListState mState;
    private Transition mTransition;
    private int mTransitionToIndex = -1;
    private int mTransitionFromIndex = -1;
    private boolean mMutated;

    public AnimatedStateListDrawableCompat() {
        this(null, null);
    }

    AnimatedStateListDrawableCompat(@Nullable AnimatedStateListState state, @Nullable Resources res) {
        super(null);
        AnimatedStateListState newState = new AnimatedStateListState(state, this, res);
        this.setConstantState(newState);
        this.onStateChange(this.getState());
        this.jumpToCurrentState();
    }

    @Nullable
    public static AnimatedStateListDrawableCompat create(@NonNull Context context, @DrawableRes int resId, @Nullable Resources.Theme theme) {
        try {
            int type;
            Resources res = context.getResources();
            XmlResourceParser parser = res.getXml(resId);
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new XmlPullParserException("No start tag found");
            }
            return AnimatedStateListDrawableCompat.createFromXmlInner(context, res, (XmlPullParser)parser, attrs, theme);
        }
        catch (XmlPullParserException e) {
            Log.e((String)LOGTAG, (String)"parser error", (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)LOGTAG, (String)"parser error", (Throwable)e);
        }
        return null;
    }

    @NonNull
    public static AnimatedStateListDrawableCompat createFromXmlInner(@NonNull Context context, @NonNull Resources resources, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) throws IOException, XmlPullParserException {
        String name = parser.getName();
        if (!name.equals("animated-selector")) {
            throw new XmlPullParserException(parser.getPositionDescription() + ": invalid animated-selector tag " + name);
        }
        AnimatedStateListDrawableCompat asl = new AnimatedStateListDrawableCompat();
        asl.inflate(context, resources, parser, attrs, theme);
        return asl;
    }

    @Override
    public void inflate(@NonNull Context context, @NonNull Resources resources, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = TypedArrayUtils.obtainAttributes((Resources)resources, (Resources.Theme)theme, (AttributeSet)attrs, (int[])R.styleable.AnimatedStateListDrawableCompat);
        this.setVisible(a.getBoolean(R.styleable.AnimatedStateListDrawableCompat_android_visible, true), true);
        this.updateStateFromTypedArray(a);
        this.updateDensity(resources);
        a.recycle();
        this.inflateChildElements(context, resources, parser, attrs, theme);
        this.init();
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (this.mTransition != null && (changed || restart)) {
            if (visible) {
                this.mTransition.start();
            } else {
                this.jumpToCurrentState();
            }
        }
        return changed;
    }

    public void addState(@NonNull int[] stateSet, @NonNull Drawable drawable2, int id) {
        ObjectsCompat.requireNonNull((Object)drawable2);
        this.mState.addStateSet(stateSet, drawable2, id);
        this.onStateChange(this.getState());
    }

    public <T extends Drawable> void addTransition(int fromId, int toId, @NonNull T transition, boolean reversible) {
        ObjectsCompat.requireNonNull(transition);
        this.mState.addTransition(fromId, toId, transition, reversible);
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    public void jumpToCurrentState() {
        super.jumpToCurrentState();
        if (this.mTransition != null) {
            this.mTransition.stop();
            this.mTransition = null;
            this.selectDrawable(this.mTransitionToIndex);
            this.mTransitionToIndex = -1;
            this.mTransitionFromIndex = -1;
        }
    }

    @Override
    protected boolean onStateChange(@NonNull int[] stateSet) {
        int targetIndex = this.mState.indexOfKeyframe(stateSet);
        boolean changed = targetIndex != this.getCurrentIndex() && (this.selectTransition(targetIndex) || this.selectDrawable(targetIndex));
        Drawable current = this.getCurrent();
        if (current != null) {
            changed |= current.setState(stateSet);
        }
        return changed;
    }

    private boolean selectTransition(int toIndex) {
        Transition transition;
        int fromIndex;
        Transition currentTransition = this.mTransition;
        if (currentTransition != null) {
            if (toIndex == this.mTransitionToIndex) {
                return true;
            }
            if (toIndex == this.mTransitionFromIndex && currentTransition.canReverse()) {
                currentTransition.reverse();
                this.mTransitionToIndex = this.mTransitionFromIndex;
                this.mTransitionFromIndex = toIndex;
                return true;
            }
            fromIndex = this.mTransitionToIndex;
            currentTransition.stop();
        } else {
            fromIndex = this.getCurrentIndex();
        }
        this.mTransition = null;
        this.mTransitionFromIndex = -1;
        this.mTransitionToIndex = -1;
        AnimatedStateListState state = this.mState;
        int fromId = state.getKeyframeIdAt(fromIndex);
        int toId = state.getKeyframeIdAt(toIndex);
        if (toId == 0 || fromId == 0) {
            return false;
        }
        int transitionIndex = state.indexOfTransition(fromId, toId);
        if (transitionIndex < 0) {
            return false;
        }
        boolean hasReversibleFlag = state.transitionHasReversibleFlag(fromId, toId);
        this.selectDrawable(transitionIndex);
        Drawable d = this.getCurrent();
        if (d instanceof AnimationDrawable) {
            boolean reversed = state.isTransitionReversed(fromId, toId);
            transition = new AnimationDrawableTransition((AnimationDrawable)d, reversed, hasReversibleFlag);
        } else if (d instanceof AnimatedVectorDrawableCompat) {
            transition = new AnimatedVectorDrawableTransition((AnimatedVectorDrawableCompat)d);
        } else if (d instanceof Animatable) {
            transition = new AnimatableTransition((Animatable)d);
        } else {
            return false;
        }
        ((Transition)transition).start();
        this.mTransition = transition;
        this.mTransitionFromIndex = fromIndex;
        this.mTransitionToIndex = toIndex;
        return true;
    }

    private void updateStateFromTypedArray(TypedArray a) {
        AnimatedStateListState state = this.mState;
        if (Build.VERSION.SDK_INT >= 21) {
            state.mChangingConfigurations |= Compatibility.Api21Impl.getChangingConfigurations(a);
        }
        state.setVariablePadding(a.getBoolean(R.styleable.AnimatedStateListDrawableCompat_android_variablePadding, state.mVariablePadding));
        state.setConstantSize(a.getBoolean(R.styleable.AnimatedStateListDrawableCompat_android_constantSize, state.mConstantSize));
        state.setEnterFadeDuration(a.getInt(R.styleable.AnimatedStateListDrawableCompat_android_enterFadeDuration, state.mEnterFadeDuration));
        state.setExitFadeDuration(a.getInt(R.styleable.AnimatedStateListDrawableCompat_android_exitFadeDuration, state.mExitFadeDuration));
        this.setDither(a.getBoolean(R.styleable.AnimatedStateListDrawableCompat_android_dither, state.mDither));
    }

    private void init() {
        this.onStateChange(this.getState());
    }

    private void inflateChildElements(@NonNull Context context, @NonNull Resources resources, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth) continue;
            if (parser.getName().equals(ELEMENT_ITEM)) {
                this.parseItem(context, resources, parser, attrs, theme);
                continue;
            }
            if (!parser.getName().equals(ELEMENT_TRANSITION)) continue;
            this.parseTransition(context, resources, parser, attrs, theme);
        }
    }

    private int parseTransition(@NonNull Context context, @NonNull Resources resources, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = TypedArrayUtils.obtainAttributes((Resources)resources, (Resources.Theme)theme, (AttributeSet)attrs, (int[])R.styleable.AnimatedStateListDrawableTransition);
        int fromId = a.getResourceId(R.styleable.AnimatedStateListDrawableTransition_android_fromId, -1);
        int toId = a.getResourceId(R.styleable.AnimatedStateListDrawableTransition_android_toId, -1);
        Object dr = null;
        int drawableId = a.getResourceId(R.styleable.AnimatedStateListDrawableTransition_android_drawable, -1);
        if (drawableId > 0) {
            dr = ResourceManagerInternal.get().getDrawable(context, drawableId);
        }
        boolean reversible = a.getBoolean(R.styleable.AnimatedStateListDrawableTransition_android_reversible, false);
        a.recycle();
        if (dr == null) {
            int type;
            while ((type = parser.next()) == 4) {
            }
            if (type != 2) {
                throw new XmlPullParserException(parser.getPositionDescription() + TRANSITION_MISSING_DRAWABLE_ERROR);
            }
            dr = parser.getName().equals("animated-vector") ? AnimatedVectorDrawableCompat.createFromXmlInner((Context)context, (Resources)resources, (XmlPullParser)parser, (AttributeSet)attrs, (Resources.Theme)theme) : (Build.VERSION.SDK_INT >= 21 ? Compatibility.Api21Impl.createFromXmlInner(resources, parser, attrs, theme) : Drawable.createFromXmlInner((Resources)resources, (XmlPullParser)parser, (AttributeSet)attrs));
        }
        if (dr == null) {
            throw new XmlPullParserException(parser.getPositionDescription() + TRANSITION_MISSING_DRAWABLE_ERROR);
        }
        if (fromId == -1 || toId == -1) {
            throw new XmlPullParserException(parser.getPositionDescription() + TRANSITION_MISSING_FROM_TO_ID);
        }
        return this.mState.addTransition(fromId, toId, (Drawable)dr, reversible);
    }

    private int parseItem(@NonNull Context context, @NonNull Resources resources, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = TypedArrayUtils.obtainAttributes((Resources)resources, (Resources.Theme)theme, (AttributeSet)attrs, (int[])R.styleable.AnimatedStateListDrawableItem);
        int keyframeId = a.getResourceId(R.styleable.AnimatedStateListDrawableItem_android_id, 0);
        Object dr = null;
        int drawableId = a.getResourceId(R.styleable.AnimatedStateListDrawableItem_android_drawable, -1);
        if (drawableId > 0) {
            dr = ResourceManagerInternal.get().getDrawable(context, drawableId);
        }
        a.recycle();
        int[] states = this.extractStateSet(attrs);
        if (dr == null) {
            int type;
            while ((type = parser.next()) == 4) {
            }
            if (type != 2) {
                throw new XmlPullParserException(parser.getPositionDescription() + ITEM_MISSING_DRAWABLE_ERROR);
            }
            dr = parser.getName().equals("vector") ? VectorDrawableCompat.createFromXmlInner((Resources)resources, (XmlPullParser)parser, (AttributeSet)attrs, (Resources.Theme)theme) : (Build.VERSION.SDK_INT >= 21 ? Compatibility.Api21Impl.createFromXmlInner(resources, parser, attrs, theme) : Drawable.createFromXmlInner((Resources)resources, (XmlPullParser)parser, (AttributeSet)attrs));
        }
        if (dr == null) {
            throw new XmlPullParserException(parser.getPositionDescription() + ITEM_MISSING_DRAWABLE_ERROR);
        }
        return this.mState.addStateSet(states, (Drawable)dr, keyframeId);
    }

    @Override
    @NonNull
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mState.mutate();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    AnimatedStateListState cloneConstantState() {
        return new AnimatedStateListState(this.mState, this, null);
    }

    @Override
    void clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    @Override
    void setConstantState(@NonNull DrawableContainerCompat.DrawableContainerState state) {
        super.setConstantState(state);
        if (state instanceof AnimatedStateListState) {
            this.mState = (AnimatedStateListState)state;
        }
    }

    static class AnimatedStateListState
    extends StateListDrawableCompat.StateListState {
        private static final long REVERSED_BIT = 0x100000000L;
        private static final long REVERSIBLE_FLAG_BIT = 0x200000000L;
        LongSparseArray<Long> mTransitions;
        SparseArrayCompat<Integer> mStateIds;

        AnimatedStateListState(@Nullable AnimatedStateListState orig, @NonNull AnimatedStateListDrawableCompat owner, @Nullable Resources res) {
            super(orig, owner, res);
            if (orig != null) {
                this.mTransitions = orig.mTransitions;
                this.mStateIds = orig.mStateIds;
            } else {
                this.mTransitions = new LongSparseArray();
                this.mStateIds = new SparseArrayCompat();
            }
        }

        @Override
        void mutate() {
            this.mTransitions = this.mTransitions.clone();
            this.mStateIds = this.mStateIds.clone();
        }

        int addTransition(int fromId, int toId, @NonNull Drawable anim, boolean reversible) {
            int pos = super.addChild(anim);
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            long reversibleBit = 0L;
            if (reversible) {
                reversibleBit = 0x200000000L;
            }
            this.mTransitions.append(keyFromTo, (Object)((long)pos | reversibleBit));
            if (reversible) {
                long keyToFrom = AnimatedStateListState.generateTransitionKey(toId, fromId);
                this.mTransitions.append(keyToFrom, (Object)((long)pos | 0x100000000L | reversibleBit));
            }
            return pos;
        }

        int addStateSet(@NonNull int[] stateSet, @NonNull Drawable drawable2, int id) {
            int index = super.addStateSet(stateSet, drawable2);
            this.mStateIds.put(index, (Object)id);
            return index;
        }

        int indexOfKeyframe(@NonNull int[] stateSet) {
            int index = super.indexOfStateSet(stateSet);
            if (index >= 0) {
                return index;
            }
            return super.indexOfStateSet(StateSet.WILD_CARD);
        }

        int getKeyframeIdAt(int index) {
            return index < 0 ? 0 : (Integer)this.mStateIds.get(index, (Object)0);
        }

        int indexOfTransition(int fromId, int toId) {
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            return (int)((Long)this.mTransitions.get(keyFromTo, (Object)-1L)).longValue();
        }

        boolean isTransitionReversed(int fromId, int toId) {
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            return ((Long)this.mTransitions.get(keyFromTo, (Object)-1L) & 0x100000000L) != 0L;
        }

        boolean transitionHasReversibleFlag(int fromId, int toId) {
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            return ((Long)this.mTransitions.get(keyFromTo, (Object)-1L) & 0x200000000L) != 0L;
        }

        @Override
        @NonNull
        public Drawable newDrawable() {
            return new AnimatedStateListDrawableCompat(this, null);
        }

        @Override
        @NonNull
        public Drawable newDrawable(Resources res) {
            return new AnimatedStateListDrawableCompat(this, res);
        }

        private static long generateTransitionKey(int fromId, int toId) {
            return (long)fromId << 32 | (long)toId;
        }
    }

    private static abstract class Transition {
        private Transition() {
        }

        public abstract void start();

        public abstract void stop();

        public void reverse() {
        }

        public boolean canReverse() {
            return false;
        }
    }

    private static class AnimationDrawableTransition
    extends Transition {
        private final ObjectAnimator mAnim;
        private final boolean mHasReversibleFlag;

        AnimationDrawableTransition(AnimationDrawable ad, boolean reversed, boolean hasReversibleFlag) {
            int frameCount = ad.getNumberOfFrames();
            int fromFrame = reversed ? frameCount - 1 : 0;
            int toFrame = reversed ? 0 : frameCount - 1;
            FrameInterpolator interp = new FrameInterpolator(ad, reversed);
            ObjectAnimator anim = ObjectAnimator.ofInt((Object)ad, (String)"currentIndex", (int[])new int[]{fromFrame, toFrame});
            anim.setAutoCancel(true);
            anim.setDuration((long)interp.getTotalDuration());
            anim.setInterpolator((TimeInterpolator)interp);
            this.mHasReversibleFlag = hasReversibleFlag;
            this.mAnim = anim;
        }

        @Override
        public boolean canReverse() {
            return this.mHasReversibleFlag;
        }

        @Override
        public void start() {
            this.mAnim.start();
        }

        @Override
        public void reverse() {
            this.mAnim.reverse();
        }

        @Override
        public void stop() {
            this.mAnim.cancel();
        }
    }

    private static class AnimatedVectorDrawableTransition
    extends Transition {
        private final AnimatedVectorDrawableCompat mAvd;

        AnimatedVectorDrawableTransition(AnimatedVectorDrawableCompat avd) {
            this.mAvd = avd;
        }

        @Override
        public void start() {
            this.mAvd.start();
        }

        @Override
        public void stop() {
            this.mAvd.stop();
        }
    }

    private static class AnimatableTransition
    extends Transition {
        private final Animatable mA;

        AnimatableTransition(Animatable a) {
            this.mA = a;
        }

        @Override
        public void start() {
            this.mA.start();
        }

        @Override
        public void stop() {
            this.mA.stop();
        }
    }

    private static class FrameInterpolator
    implements TimeInterpolator {
        private int[] mFrameTimes;
        private int mFrames;
        private int mTotalDuration;

        FrameInterpolator(AnimationDrawable d, boolean reversed) {
            this.updateFrames(d, reversed);
        }

        int updateFrames(AnimationDrawable d, boolean reversed) {
            int frameCount;
            this.mFrames = frameCount = d.getNumberOfFrames();
            if (this.mFrameTimes == null || this.mFrameTimes.length < frameCount) {
                this.mFrameTimes = new int[frameCount];
            }
            int[] frameTimes = this.mFrameTimes;
            int totalDuration = 0;
            for (int i = 0; i < frameCount; ++i) {
                int duration;
                frameTimes[i] = duration = d.getDuration(reversed ? frameCount - i - 1 : i);
                totalDuration += duration;
            }
            this.mTotalDuration = totalDuration;
            return totalDuration;
        }

        int getTotalDuration() {
            return this.mTotalDuration;
        }

        public float getInterpolation(float input) {
            int i;
            int elapsed = (int)(input * (float)this.mTotalDuration + 0.5f);
            int frameCount = this.mFrames;
            int[] frameTimes = this.mFrameTimes;
            int remaining = elapsed;
            for (i = 0; i < frameCount && remaining >= frameTimes[i]; remaining -= frameTimes[i], ++i) {
            }
            float frameElapsed = i < frameCount ? (float)remaining / (float)this.mTotalDuration : 0.0f;
            return (float)i / (float)frameCount + frameElapsed;
        }
    }
}

