/*
 * Decompiled with CFR 0.152.
 */
package androidx.annotation.experimental.lint;

import androidx.annotation.experimental.lint.ExperimentalDetectorKt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u001a_\u0010\u0000\u001a\u00020\u0001*\u00020\u00022!\u0010\u0003\u001a\u001d\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u00010\u00042#\b\u0002\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u00010\u00042\b\b\u0002\u0010\t\u001a\u00020\u0001H\u0082\b\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b*\u0004\u0018\u00010\fH\u0002\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u0002*\u0004\u0018\u00010\u0002H\u0002\u001a\u001c\u0010\u000e\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\u001a\f\u0010\u0012\u001a\u00020\u0001*\u00020\u0013H\u0002\u001a\u0014\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u000bH\u0002\u001a\"\u0010\u0016\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0002\u00a8\u0006\u0019"}, d2={"anyParentMatches", "", "Lorg/jetbrains/uast/UElement;", "positivePredicate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "element", "negativePredicate", "defaultValue", "getFullyQualifiedName", "", "Lorg/jetbrains/uast/UExpression;", "getReferencedElement", "hasMatchingAttributeValueClass", "Lorg/jetbrains/uast/UAnnotation;", "attributeName", "className", "isAbstract", "Lcom/intellij/psi/PsiModifierListOwner;", "isDeclarationAnnotatedWith", "annotationFqName", "isDeclarationAnnotatedWithOptInOf", "optInFqNames", "", "annotation-experimental-lint"})
public final class ExperimentalDetectorKt {
    private static final boolean hasMatchingAttributeValueClass(UAnnotation $this$hasMatchingAttributeValueClass, String attributeName, String className) {
        UExpression attributeValue = $this$hasMatchingAttributeValueClass.findDeclaredAttributeValue(attributeName);
        if (Intrinsics.areEqual((Object)ExperimentalDetectorKt.getFullyQualifiedName(attributeValue), (Object)className)) {
            return true;
        }
        if (attributeValue instanceof UCallExpression) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = ((UCallExpression)attributeValue).getValueArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UExpression attrValue = (UExpression)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)ExperimentalDetectorKt.getFullyQualifiedName(attrValue), (Object)className)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    private static final String getFullyQualifiedName(UExpression $this$getFullyQualifiedName) {
        Object object;
        if ($this$getFullyQualifiedName instanceof UClassLiteralExpression) {
            object = ((UClassLiteralExpression)$this$getFullyQualifiedName).getType();
        } else {
            UExpression uExpression = $this$getFullyQualifiedName;
            object = uExpression == null ? null : uExpression.evaluate();
        }
        Object type = object;
        PsiClassType psiClassType = type instanceof PsiClassType ? (PsiClassType)type : null;
        return psiClassType == null ? null : psiClassType.getCanonicalText();
    }

    private static final UElement getReferencedElement(UElement $this$getReferencedElement) {
        Object object;
        UElement uElement = $this$getReferencedElement;
        if (uElement instanceof UBinaryExpression) {
            object = UastUtils.tryResolve((UElement)((UElement)((UBinaryExpression)$this$getReferencedElement).getLeftOperand()));
        } else if (uElement instanceof UMethod) {
            object = (PsiElement)$this$getReferencedElement;
        } else if (uElement instanceof UClass) {
            PsiClass psiClass;
            block22: {
                for (UTypeReferenceExpression it : (Iterable)((UClass)$this$getReferencedElement).getUastSuperTypes()) {
                    boolean bl = false;
                    PsiClass psiClass2 = PsiTypesUtil.getPsiClass((PsiType)it.getType());
                    if (psiClass2 == null) continue;
                    psiClass = psiClass2;
                    break block22;
                }
                psiClass = null;
            }
            object = (PsiElement)psiClass;
        } else if (uElement instanceof USimpleNameReferenceExpression) {
            PsiElement field = ((USimpleNameReferenceExpression)$this$getReferencedElement).resolve();
            boolean bl = false;
            Object object2 = field instanceof PsiField ? (PsiField)field : null;
            if (object2 == null) {
                object2 = field instanceof PsiMethod ? (PsiMethod)field : null;
            }
            object = (PsiElement)object2;
        } else if (uElement instanceof UCallExpression) {
            PsiMethod psiMethod = ((UCallExpression)$this$getReferencedElement).resolve();
            if (psiMethod == null) {
                UReferenceExpression uReferenceExpression = ((UCallExpression)$this$getReferencedElement).getClassReference();
                object = uReferenceExpression == null ? null : uReferenceExpression.resolve();
            } else {
                object = (PsiElement)psiMethod;
            }
        } else if (uElement instanceof UCallableReferenceExpression) {
            PsiElement psiElement = ((UCallableReferenceExpression)$this$getReferencedElement).resolve();
            object = (PsiElement)(psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null);
        } else if (uElement instanceof UAnnotation) {
            object = null;
        } else if (uElement instanceof UEnumConstant) {
            object = (PsiElement)((UEnumConstant)$this$getReferencedElement).resolveMethod();
        } else if (uElement instanceof UArrayAccessExpression) {
            UExpression uExpression = ((UArrayAccessExpression)$this$getReferencedElement).getReceiver();
            UReferenceExpression uReferenceExpression = uExpression instanceof UReferenceExpression ? (UReferenceExpression)uExpression : null;
            object = uReferenceExpression == null ? null : uReferenceExpression.resolve();
        } else {
            object = uElement instanceof UVariable ? (PsiElement)$this$getReferencedElement : null;
        }
        return UastContextKt.toUElement((PsiElement)object);
    }

    private static final boolean anyParentMatches(UElement $this$anyParentMatches, Function1<? super UElement, Boolean> positivePredicate, Function1<? super UElement, Boolean> negativePredicate, boolean defaultValue) {
        boolean $i$f$anyParentMatches = false;
        UElement element = $this$anyParentMatches;
        while (!((Boolean)positivePredicate.invoke((Object)element)).booleanValue()) {
            if (((Boolean)negativePredicate.invoke((Object)element)).booleanValue()) {
                return false;
            }
            if (element.getUastParent() != null) continue;
            return defaultValue;
        }
        return true;
    }

    static /* synthetic */ boolean anyParentMatches$default(UElement $this$anyParentMatches_u24default, Function1 positivePredicate, Function1 negativePredicate, boolean defaultValue, int n, Object object) {
        if ((n & 2) != 0) {
            negativePredicate = anyParentMatches.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            defaultValue = false;
        }
        boolean $i$f$anyParentMatches = false;
        UElement element = $this$anyParentMatches_u24default;
        while (!((Boolean)positivePredicate.invoke((Object)element)).booleanValue()) {
            if (((Boolean)negativePredicate.invoke((Object)element)).booleanValue()) {
                return false;
            }
            if (element.getUastParent() != null) continue;
            return defaultValue;
        }
        return true;
    }

    private static final boolean isDeclarationAnnotatedWith(UElement $this$isDeclarationAnnotatedWith, String annotationFqName) {
        UAnnotated uAnnotated = $this$isDeclarationAnnotatedWith instanceof UAnnotated ? (UAnnotated)$this$isDeclarationAnnotatedWith : null;
        return (uAnnotated == null ? null : uAnnotated.findAnnotation(annotationFqName)) != null;
    }

    private static final boolean isDeclarationAnnotatedWithOptInOf(UElement $this$isDeclarationAnnotatedWithOptInOf, String annotationFqName, List<String> optInFqNames) {
        boolean bl;
        UAnnotated uAnnotated = $this$isDeclarationAnnotatedWithOptInOf instanceof UAnnotated ? (UAnnotated)$this$isDeclarationAnnotatedWithOptInOf : null;
        if (uAnnotated == null) {
            bl = false;
        } else {
            boolean bl2;
            block5: {
                UAnnotated annotated = uAnnotated;
                boolean bl3 = false;
                Iterable $this$any$iv = optInFqNames;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String optInFqName = (String)element$iv;
                        boolean bl4 = false;
                        UAnnotation uAnnotation = annotated.findAnnotation(optInFqName);
                        boolean bl5 = uAnnotation == null ? false : ExperimentalDetectorKt.hasMatchingAttributeValueClass(uAnnotation, "markerClass", annotationFqName);
                        if (!bl5) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        return bl;
    }

    private static final boolean isAbstract(PsiModifierListOwner $this$isAbstract) {
        PsiModifierList psiModifierList = $this$isAbstract.getModifierList();
        return psiModifierList == null ? false : psiModifierList.hasModifierProperty("abstract");
    }

    public static final /* synthetic */ UElement access$getReferencedElement(UElement $receiver) {
        return ExperimentalDetectorKt.getReferencedElement($receiver);
    }

    public static final /* synthetic */ boolean access$isDeclarationAnnotatedWith(UElement $receiver, String annotationFqName) {
        return ExperimentalDetectorKt.isDeclarationAnnotatedWith($receiver, annotationFqName);
    }

    public static final /* synthetic */ boolean access$isAbstract(PsiModifierListOwner $receiver) {
        return ExperimentalDetectorKt.isAbstract($receiver);
    }

    public static final /* synthetic */ boolean access$isDeclarationAnnotatedWithOptInOf(UElement $receiver, String annotationFqName, List optInFqNames) {
        return ExperimentalDetectorKt.isDeclarationAnnotatedWithOptInOf($receiver, annotationFqName, optInFqNames);
    }
}

