/*
 * Decompiled with CFR 0.152.
 */
package androidx.annotation.experimental.lint;

import androidx.annotation.experimental.lint.AnnotationRetentionDetectorKt;
import androidx.annotation.experimental.lint.ExperimentalDetectorKt;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J(\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J|\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0016\u00a8\u0006#"}, d2={"Landroidx/annotation/experimental/lint/ExperimentalDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkExperimentalUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "usage", "Lorg/jetbrains/uast/UElement;", "useAnnotationNames", "hasOrUsesAnnotation", "", "annotationName", "report", "message", "level", "visitAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "qualifiedName", "method", "Lcom/intellij/psi/PsiMethod;", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "allMemberAnnotations", "allClassAnnotations", "allPackageAnnotations", "Companion", "annotation-experimental-lint"})
public final class ExperimentalDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ExperimentalDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    public static final String KOTLIN_EXPERIMENTAL_ANNOTATION = "kotlin.Experimental";
    @NotNull
    public static final String KOTLIN_USE_EXPERIMENTAL_ANNOTATION = "kotlin.UseExperimental";
    @NotNull
    public static final String KOTLIN_OPT_IN_ANNOTATION = "kotlin.OptIn";
    @NotNull
    public static final String KOTLIN_REQUIRES_OPT_IN_ANNOTATION = "kotlin.RequiresOptIn";
    @NotNull
    public static final String JAVA_EXPERIMENTAL_ANNOTATION = "androidx.annotation.experimental.Experimental";
    @NotNull
    public static final String JAVA_USE_EXPERIMENTAL_ANNOTATION = "androidx.annotation.experimental.UseExperimental";
    @NotNull
    public static final String JAVA_REQUIRES_OPT_IN_ANNOTATION = "androidx.annotation.RequiresOptIn";
    @NotNull
    public static final String JAVA_OPT_IN_ANNOTATION = "androidx.annotation.OptIn";
    @NotNull
    private static final Issue ISSUE_ERROR = androidx.annotation.experimental.lint.ExperimentalDetector$Companion.access$issueForLevel(Companion, "error", Severity.ERROR);
    @NotNull
    private static final Issue ISSUE_WARNING = androidx.annotation.experimental.lint.ExperimentalDetector$Companion.access$issueForLevel(Companion, "warning", Severity.WARNING);
    @NotNull
    private static final List<Issue> ISSUES;

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{JAVA_EXPERIMENTAL_ANNOTATION, KOTLIN_EXPERIMENTAL_ANNOTATION, JAVA_REQUIRES_OPT_IN_ANNOTATION, KOTLIN_REQUIRES_OPT_IN_ANNOTATION};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkNotNullParameter(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkNotNullParameter(allPackageAnnotations, (String)"allPackageAnnotations");
        switch (qualifiedName) {
            case "androidx.annotation.experimental.Experimental": 
            case "androidx.annotation.RequiresOptIn": {
                Object[] objectArray = new String[]{JAVA_USE_EXPERIMENTAL_ANNOTATION, JAVA_OPT_IN_ANNOTATION};
                this.checkExperimentalUsage(context, annotation, usage, CollectionsKt.listOf((Object[])objectArray));
                break;
            }
            case "kotlin.RequiresOptIn": 
            case "kotlin.Experimental": {
                if (Lint.isKotlin((PsiElement)usage.getSourcePsi())) break;
                Object[] objectArray = new String[]{KOTLIN_USE_EXPERIMENTAL_ANNOTATION, KOTLIN_OPT_IN_ANNOTATION, JAVA_USE_EXPERIMENTAL_ANNOTATION, JAVA_OPT_IN_ANNOTATION};
                this.checkExperimentalUsage(context, annotation, usage, CollectionsKt.listOf((Object[])objectArray));
            }
        }
    }

    private final void checkExperimentalUsage(JavaContext context, UAnnotation annotation, UElement usage, List<String> useAnnotationNames) {
        String string;
        UElement uElement = annotation.getUastParent();
        Object object = uElement instanceof UClass ? (UClass)uElement : null;
        String string2 = string = object == null ? null : object.getQualifiedName();
        if (string == null) {
            return;
        }
        String useAnnotation = string;
        if (!this.hasOrUsesAnnotation(context, usage, useAnnotation, useAnnotationNames)) {
            object = AnnotationRetentionDetectorKt.extractAttribute(annotation, context, "level");
            String level = object == null ? "ERROR" : object;
            this.report(context, usage, "\n                    This declaration is opt-in and its usage should be marked with\n                    '@" + useAnnotation + "' or '@OptIn(markerClass = " + useAnnotation + ".class)'\n                ", level);
        }
    }

    private final boolean hasOrUsesAnnotation(JavaContext context, UElement usage, String annotationName, List<String> useAnnotationNames) {
        UAnnotated element;
        UAnnotated uAnnotated = element = usage instanceof UAnnotated ? (UAnnotated)usage : (UAnnotated)UastUtils.getParentOfType$default((UElement)usage, UAnnotated.class, (boolean)false, (int)2, null);
        while (element != null) {
            boolean matchUse;
            block10: {
                boolean bl;
                boolean matchName;
                List annotations;
                block9: {
                    boolean bl2;
                    annotations = context.getEvaluator().getAllAnnotations(element, false);
                    Iterable $this$any$iv = annotations;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            UAnnotation it = (UAnnotation)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)annotationName, (Object)it.getQualifiedName())) continue;
                            bl2 = true;
                            break block9;
                        }
                        bl2 = matchName = false;
                    }
                }
                if (matchName) {
                    return true;
                }
                Iterable $this$any$iv = annotations;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UAnnotation annotation = (UAnnotation)element$iv;
                        boolean bl4 = false;
                        String qualifiedName = annotation.getQualifiedName();
                        if (!(qualifiedName != null && useAnnotationNames.contains(qualifiedName) && ExperimentalDetectorKt.access$hasMatchingAttributeValueClass(annotation, context, "markerClass", annotationName))) continue;
                        bl = true;
                        break block10;
                    }
                    bl = matchUse = false;
                }
            }
            if (matchUse) {
                return true;
            }
            element = (UAnnotated)UastUtils.getParentOfType$default((UElement)((UElement)element), UAnnotated.class, (boolean)false, (int)2, null);
        }
        return false;
    }

    private final void report(JavaContext context, UElement usage, String message, String level) {
        block6: {
            Issue issue;
            String string = level;
            if (Intrinsics.areEqual((Object)string, (Object)"ERROR")) {
                issue = ISSUE_ERROR;
            } else if (Intrinsics.areEqual((Object)string, (Object)"WARNING")) {
                issue = ISSUE_WARNING;
            } else {
                throw new IllegalArgumentException("Level was \"" + level + "\" but must be one of: ERROR, WARNING");
            }
            Issue issue2 = issue;
            try {
                JavaContext.report$default((JavaContext)context, (Issue)issue2, (UElement)usage, (Location)context.getNameLocation(usage), (String)StringsKt.trimIndent((String)message), null, (int)16, null);
            }
            catch (UnsupportedOperationException e) {
                if (Intrinsics.areEqual((Object)"Method not implemented", (Object)e.getMessage())) break block6;
                throw e;
            }
        }
    }

    static {
        Object[] objectArray = new Issue[]{ISSUE_ERROR, ISSUE_WARNING};
        ISSUES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/annotation/experimental/lint/ExperimentalDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUES", "", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUES", "()Ljava/util/List;", "ISSUE_ERROR", "getISSUE_ERROR", "()Lcom/android/tools/lint/detector/api/Issue;", "ISSUE_WARNING", "getISSUE_WARNING", "JAVA_EXPERIMENTAL_ANNOTATION", "", "JAVA_OPT_IN_ANNOTATION", "JAVA_REQUIRES_OPT_IN_ANNOTATION", "JAVA_USE_EXPERIMENTAL_ANNOTATION", "KOTLIN_EXPERIMENTAL_ANNOTATION", "KOTLIN_OPT_IN_ANNOTATION", "KOTLIN_REQUIRES_OPT_IN_ANNOTATION", "KOTLIN_USE_EXPERIMENTAL_ANNOTATION", "issueForLevel", "level", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "annotation-experimental-lint"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Issue issueForLevel(String level, Severity severity) {
            String string;
            Issue.Companion companion = Issue.Companion;
            String string2 = "UnsafeOptInUsage";
            String string3 = level;
            boolean bl = false;
            CharSequence charSequence = string3;
            int n = 0;
            if (charSequence.length() > 0) {
                String string4;
                void it;
                char c = string3.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                String string5 = string2;
                Issue.Companion companion2 = companion;
                boolean bl2 = false;
                void var9_12 = it;
                boolean bl3 = false;
                if (Character.isLowerCase((char)var9_12)) {
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                    string4 = CharsKt.titlecase((char)it, (Locale)locale);
                } else {
                    string4 = String.valueOf((char)it);
                }
                String string6 = string4;
                companion = companion2;
                string2 = string5;
                StringBuilder stringBuilder2 = stringBuilder.append(string6.toString());
                charSequence = string3;
                n = 1;
                c = '\u0000';
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = ((String)charSequence2).substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                string = stringBuilder2.append(string7).toString();
            } else {
                string = string3;
            }
            return companion.create(Intrinsics.stringPlus((String)string2, (Object)string), "Unsafe opt-in usage intended to be " + level + "-level severity", "\n                This API has been flagged as opt-in with " + level + "-level severity.\n\n                Any declaration annotated with this marker is considered part of an unstable or\n                otherwise non-standard API surface and its call sites should accept the opt-in\n                aspect of it either by using `@OptIn` or by being annotated with that marker\n                themselves, effectively causing further propagation of the opt-in aspect.\n            ", Category.CORRECTNESS, 4, severity, IMPLEMENTATION);
        }

        @NotNull
        public final Issue getISSUE_ERROR() {
            return ISSUE_ERROR;
        }

        @NotNull
        public final Issue getISSUE_WARNING() {
            return ISSUE_WARNING;
        }

        @NotNull
        public final List<Issue> getISSUES() {
            return ISSUES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Issue access$issueForLevel(Companion $this, String level, Severity severity) {
            return $this.issueForLevel(level, severity);
        }
    }
}

