/*
 * Decompiled with CFR 0.152.
 */
package androidx.annotation.experimental.lint;

import androidx.annotation.experimental.lint.ExperimentalDetectorKt;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J(\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J|\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0016\u00a8\u0006%"}, d2={"Landroidx/annotation/experimental/lint/ExperimentalDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkExperimentalUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "usage", "Lorg/jetbrains/uast/UElement;", "useAnnotationName", "extractAttribute", "name", "hasOrUsesAnnotation", "", "annotationName", "report", "message", "level", "visitAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "qualifiedName", "method", "Lcom/intellij/psi/PsiMethod;", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "allMemberAnnotations", "allClassAnnotations", "allPackageAnnotations", "Companion", "annotation-experimental-lint"})
public final class ExperimentalDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    private static final String KOTLIN_EXPERIMENTAL_ANNOTATION = "kotlin.Experimental";
    private static final String KOTLIN_USE_EXPERIMENTAL_ANNOTATION = "kotlin.UseExperimental";
    private static final String JAVA_EXPERIMENTAL_ANNOTATION = "androidx.annotation.experimental.Experimental";
    private static final String JAVA_USE_EXPERIMENTAL_ANNOTATION = "androidx.annotation.experimental.UseExperimental";
    @NotNull
    private static final Issue ISSUE_ERROR;
    @NotNull
    private static final Issue ISSUE_WARNING;
    @NotNull
    private static final List<Issue> ISSUES;
    public static final Companion Companion;

    @Nullable
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object[])new String[]{JAVA_EXPERIMENTAL_ANNOTATION, KOTLIN_EXPERIMENTAL_ANNOTATION});
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        switch (qualifiedName) {
            case "androidx.annotation.experimental.Experimental": {
                this.checkExperimentalUsage(context, annotation, usage, JAVA_USE_EXPERIMENTAL_ANNOTATION);
                break;
            }
            case "kotlin.Experimental": {
                if (Lint.isKotlin((PsiElement)usage.getSourcePsi())) break;
                this.checkExperimentalUsage(context, annotation, usage, KOTLIN_USE_EXPERIMENTAL_ANNOTATION);
            }
        }
    }

    private final void checkExperimentalUsage(JavaContext context, UAnnotation annotation, UElement usage, String useAnnotationName) {
        Object object;
        UElement uElement = annotation.getUastParent();
        if (!(uElement instanceof UClass)) {
            uElement = null;
        }
        if ((object = (UClass)uElement) == null || (object = object.getQualifiedName()) == null) {
            return;
        }
        Object useAnnotation = object;
        if (!this.hasOrUsesAnnotation(context, usage, (String)useAnnotation, useAnnotationName)) {
            String level = this.extractAttribute(annotation, "level");
            if (level != null) {
                this.report(context, usage, "\n                    This declaration is experimental and its usage should be marked with\n                    '@" + (String)useAnnotation + "' or '@UseExperimental(markerClass = " + (String)useAnnotation + ".class)'\n                ", level);
            } else {
                this.report(context, (UElement)annotation, "\n                    Failed to extract attribute \"level\" from annotation\n                ", "ERROR");
            }
        }
    }

    private final String extractAttribute(UAnnotation annotation, String name) {
        UReferenceExpression expression;
        Object object;
        UExpression uExpression = annotation.findAttributeValue(name);
        if (!(uExpression instanceof UReferenceExpression)) {
            uExpression = null;
        }
        if (!((object = new ConstantEvaluator().evaluate((UElement)(expression = (UReferenceExpression)uExpression))) instanceof PsiField)) {
            object = null;
        }
        PsiField psiField = (PsiField)object;
        return psiField != null ? psiField.getName() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasOrUsesAnnotation(JavaContext context, UElement usage, String annotationName, String useAnnotationName) {
        UAnnotated element;
        UAnnotated uAnnotated = element = usage instanceof UAnnotated ? (UAnnotated)usage : (UAnnotated)UastUtils.getParentOfType$default((UElement)usage, UAnnotated.class, (boolean)false, (int)2, null);
        while (element != null) {
            boolean matchUse;
            boolean matchName;
            block11: {
                boolean bl;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$filterTo$iv$iv;
                Object element$iv2;
                boolean bl2;
                List annotations;
                block10: {
                    annotations = context.getEvaluator().getAllAnnotations(element, false);
                    Iterable $this$any$iv = annotations;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            UAnnotation it = (UAnnotation)element$iv2;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)annotationName)) continue;
                            bl2 = true;
                            break block10;
                        }
                        bl2 = false;
                    }
                }
                matchName = bl2;
                Iterable $this$filter$iv = annotations;
                boolean $i$f$filter = false;
                element$iv2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    UAnnotation annotation = (UAnnotation)element$iv$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)annotation.getQualifiedName(), (Object)useAnnotationName)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    UNamedExpression uNamedExpression;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl5 = false;
                    UAnnotation annotation = (UAnnotation)element$iv$iv;
                    boolean bl6 = false;
                    if ((UNamedExpression)CollectionsKt.getOrNull((List)annotation.getAttributeValues(), (int)0) == null) continue;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    UNamedExpression it$iv$iv = uNamedExpression;
                    boolean bl9 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$any$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv3 : $this$any$iv) {
                        UNamedExpression attrValue = (UNamedExpression)element$iv3;
                        boolean bl10 = false;
                        if (!Intrinsics.areEqual((Object)ExperimentalDetectorKt.access$getFullyQualifiedName(attrValue, context), (Object)annotationName)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = matchUse = false;
                }
            }
            if (matchName || matchUse) {
                return true;
            }
            element = (UAnnotated)UastUtils.getParentOfType$default((UElement)((UElement)element), UAnnotated.class, (boolean)false, (int)2, null);
        }
        return false;
    }

    private final void report(JavaContext context, UElement usage, String message, String level) {
        Issue issue;
        switch (level) {
            case "ERROR": {
                issue = ISSUE_ERROR;
                break;
            }
            case "WARNING": {
                issue = ISSUE_WARNING;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Level was \"" + level + "\" but must be one " + "of: ERROR, WARNING");
            }
        }
        Issue issue2 = issue;
        JavaContext.report$default((JavaContext)context, (Issue)issue2, (UElement)usage, (Location)context.getNameLocation(usage), (String)StringsKt.trimIndent((String)message), null, (int)16, null);
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(ExperimentalDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE_ERROR = ExperimentalDetector.Companion.issueForLevel("error", Severity.ERROR);
        ISSUE_WARNING = ExperimentalDetector.Companion.issueForLevel("warning", Severity.WARNING);
        ISSUES = CollectionsKt.listOf((Object[])new Issue[]{ISSUE_ERROR, ISSUE_WARNING});
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/annotation/experimental/lint/ExperimentalDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUES", "", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUES", "()Ljava/util/List;", "ISSUE_ERROR", "getISSUE_ERROR", "()Lcom/android/tools/lint/detector/api/Issue;", "ISSUE_WARNING", "getISSUE_WARNING", "JAVA_EXPERIMENTAL_ANNOTATION", "", "JAVA_USE_EXPERIMENTAL_ANNOTATION", "KOTLIN_EXPERIMENTAL_ANNOTATION", "KOTLIN_USE_EXPERIMENTAL_ANNOTATION", "issueForLevel", "level", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "annotation-experimental-lint"})
    public static final class Companion {
        private final Issue issueForLevel(String level, Severity severity) {
            return Issue.Companion.create("UnsafeExperimentalUsage" + StringsKt.capitalize((String)level), "Unsafe experimental usage intended to be " + level + "-level severity", "\n                This API has been flagged as experimental with " + level + "-level severity.\n\n                Any declaration annotated with this marker is considered part of an unstable API \\\n                surface and its call sites should accept the experimental aspect of it either by \\\n                using `@UseExperimental`, or by being annotated with that marker themselves, \\\n                effectively causing further propagation of that experimental aspect.\n            ", Category.CORRECTNESS, 4, severity, IMPLEMENTATION);
        }

        @NotNull
        public final Issue getISSUE_ERROR() {
            return ISSUE_ERROR;
        }

        @NotNull
        public final Issue getISSUE_WARNING() {
            return ISSUE_WARNING;
        }

        @NotNull
        public final List<Issue> getISSUES() {
            return ISSUES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

