/*
 * Decompiled with CFR 0.152.
 */
package com.ipaulpro.afilechooser;

import android.content.Context;
import android.os.FileObserver;
import android.support.v4.content.AsyncTaskLoader;
import com.ipaulpro.afilechooser.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FileLoader
extends AsyncTaskLoader<List<File>> {
    private static final int FILE_OBSERVER_MASK = 4034;
    private FileObserver mFileObserver;
    private List<File> mData;
    private String mPath;

    public FileLoader(Context context, String path) {
        super(context);
        this.mPath = path;
    }

    public List<File> loadInBackground() {
        File[] files;
        ArrayList<File> list = new ArrayList<File>();
        File pathDir = new File(this.mPath);
        File[] dirs = pathDir.listFiles(FileUtils.sDirFilter);
        if (dirs != null) {
            Arrays.sort(dirs, FileUtils.sComparator);
            for (File dir : dirs) {
                list.add(dir);
            }
        }
        if ((files = pathDir.listFiles(FileUtils.sFileFilter)) != null) {
            Arrays.sort(files, FileUtils.sComparator);
            for (File file : files) {
                list.add(file);
            }
        }
        return list;
    }

    public void deliverResult(List<File> data) {
        if (this.isReset()) {
            this.onReleaseResources(data);
            return;
        }
        List<File> oldData = this.mData;
        this.mData = data;
        if (this.isStarted()) {
            super.deliverResult(data);
        }
        if (oldData != null && oldData != data) {
            this.onReleaseResources(oldData);
        }
    }

    protected void onStartLoading() {
        if (this.mData != null) {
            this.deliverResult(this.mData);
        }
        if (this.mFileObserver == null) {
            this.mFileObserver = new FileObserver(this.mPath, 4034){

                public void onEvent(int event, String path) {
                    FileLoader.this.onContentChanged();
                }
            };
        }
        this.mFileObserver.startWatching();
        if (this.takeContentChanged() || this.mData == null) {
            this.forceLoad();
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    protected void onReset() {
        this.onStopLoading();
        if (this.mData != null) {
            this.onReleaseResources(this.mData);
            this.mData = null;
        }
    }

    public void onCanceled(List<File> data) {
        super.onCanceled(data);
        this.onReleaseResources(data);
    }

    protected void onReleaseResources(List<File> data) {
        if (this.mFileObserver != null) {
            this.mFileObserver.stopWatching();
            this.mFileObserver = null;
        }
    }
}

