/*
 * Decompiled with CFR 0.152.
 */
package com.ipaulpro.afilechooser;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.support.v4.app.ListFragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.ipaulpro.afilechooser.FileListAdapter;
import com.ipaulpro.afilechooser.FileLoader;
import com.ipaulpro.afilechooser.R;
import java.io.File;
import java.util.List;

public class FileListFragment
extends ListFragment
implements LoaderManager.LoaderCallbacks<List<File>> {
    private static final int LOADER_ID = 0;
    private FileListAdapter mAdapter;
    private String mPath;
    private Callbacks mListener;

    public static FileListFragment newInstance(String path) {
        FileListFragment fragment = new FileListFragment();
        Bundle args = new Bundle();
        args.putString("path", path);
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mListener = (Callbacks)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement FileListFragment.Callbacks");
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mAdapter = new FileListAdapter((Context)this.getActivity());
        this.mPath = this.getArguments() != null ? this.getArguments().getString("path") : Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        this.setEmptyText(this.getString(R.string.empty_directory));
        this.setListAdapter((ListAdapter)this.mAdapter);
        this.setListShown(false);
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this);
        super.onActivityCreated(savedInstanceState);
    }

    public void onListItemClick(ListView l, View v, int position, long id) {
        FileListAdapter adapter = (FileListAdapter)l.getAdapter();
        if (adapter != null) {
            File file = adapter.getItem(position);
            this.mPath = file.getAbsolutePath();
            this.mListener.onFileSelected(file);
        }
    }

    public Loader<List<File>> onCreateLoader(int id, Bundle args) {
        return new FileLoader((Context)this.getActivity(), this.mPath);
    }

    public void onLoadFinished(Loader<List<File>> loader, List<File> data) {
        this.mAdapter.setListItems(data);
        if (this.isResumed()) {
            this.setListShown(true);
        } else {
            this.setListShownNoAnimation(true);
        }
    }

    public void onLoaderReset(Loader<List<File>> loader) {
        this.mAdapter.clear();
    }

    public static interface Callbacks {
        public void onFileSelected(File var1);
    }
}

