/*
 * Decompiled with CFR 0.152.
 */
package com.ipaulpro.afilechooser;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.ipaulpro.afilechooser.R;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileListAdapter
extends BaseAdapter {
    private static final int ICON_FOLDER = R.drawable.ic_folder;
    private static final int ICON_FILE = R.drawable.ic_file;
    private final LayoutInflater mInflater;
    private List<File> mData = new ArrayList<File>();

    public FileListAdapter(Context context) {
        this.mInflater = LayoutInflater.from((Context)context);
    }

    public void add(File file) {
        this.mData.add(file);
        this.notifyDataSetChanged();
    }

    public void remove(File file) {
        this.mData.remove(file);
        this.notifyDataSetChanged();
    }

    public void insert(File file, int index) {
        this.mData.add(index, file);
        this.notifyDataSetChanged();
    }

    public void clear() {
        this.mData.clear();
        this.notifyDataSetChanged();
    }

    public File getItem(int position) {
        return this.mData.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getCount() {
        return this.mData.size();
    }

    public List<File> getListItems() {
        return this.mData;
    }

    public void setListItems(List<File> data) {
        this.mData = data;
        this.notifyDataSetChanged();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View row = convertView;
        if (row == null) {
            row = this.mInflater.inflate(R.layout.file, parent, false);
        }
        TextView view = (TextView)row;
        File file = this.getItem(position);
        view.setText((CharSequence)file.getName());
        int icon = file.isDirectory() ? ICON_FOLDER : ICON_FILE;
        view.setCompoundDrawablesWithIntrinsicBounds(icon, 0, 0, 0);
        return row;
    }
}

