/*
 * Decompiled with CFR 0.152.
 */
package com.ipaulpro.afilechooser;

import android.app.ActionBar;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.Toast;
import com.ipaulpro.afilechooser.FileListFragment;
import com.ipaulpro.afilechooser.R;
import java.io.File;

public class FileChooserActivity
extends FragmentActivity
implements FragmentManager.OnBackStackChangedListener,
FileListFragment.Callbacks {
    public static final String PATH = "path";
    public static final String EXTERNAL_BASE_PATH = Environment.getExternalStorageDirectory().getAbsolutePath();
    private static final boolean HAS_ACTIONBAR = Build.VERSION.SDK_INT >= 11;
    private FragmentManager mFragmentManager;
    private BroadcastReceiver mStorageListener = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Toast.makeText((Context)context, (int)R.string.storage_removed, (int)1).show();
            FileChooserActivity.this.finishWithResult(null);
        }
    };
    private String mPath;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mFragmentManager = this.getSupportFragmentManager();
        this.mFragmentManager.addOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)this);
        if (savedInstanceState == null) {
            this.mPath = EXTERNAL_BASE_PATH;
            this.addFragment();
        } else {
            this.mPath = savedInstanceState.getString(PATH);
        }
        this.setTitle(this.mPath);
    }

    protected void onPause() {
        super.onPause();
        this.unregisterStorageListener();
    }

    protected void onResume() {
        super.onResume();
        this.registerStorageListener();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(PATH, this.mPath);
    }

    public void onBackStackChanged() {
        int count = this.mFragmentManager.getBackStackEntryCount();
        if (count > 0) {
            FragmentManager.BackStackEntry fragment = this.mFragmentManager.getBackStackEntryAt(count - 1);
            this.mPath = fragment.getName();
        } else {
            this.mPath = EXTERNAL_BASE_PATH;
        }
        this.setTitle(this.mPath);
        if (HAS_ACTIONBAR) {
            this.invalidateOptionsMenu();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        if (HAS_ACTIONBAR) {
            boolean hasBackStack = this.mFragmentManager.getBackStackEntryCount() > 0;
            ActionBar actionBar = this.getActionBar();
            actionBar.setDisplayHomeAsUpEnabled(hasBackStack);
            actionBar.setHomeButtonEnabled(hasBackStack);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.mFragmentManager.popBackStack();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void addFragment() {
        FileListFragment fragment = FileListFragment.newInstance(this.mPath);
        this.mFragmentManager.beginTransaction().add(0x1020002, (Fragment)fragment).commit();
    }

    private void replaceFragment(File file) {
        this.mPath = file.getAbsolutePath();
        FileListFragment fragment = FileListFragment.newInstance(this.mPath);
        this.mFragmentManager.beginTransaction().replace(0x1020002, (Fragment)fragment).setTransition(4097).addToBackStack(this.mPath).commit();
    }

    private void finishWithResult(File file) {
        if (file != null) {
            Uri uri = Uri.fromFile((File)file);
            this.setResult(-1, new Intent().setData(uri));
            this.finish();
        } else {
            this.setResult(0);
            this.finish();
        }
    }

    @Override
    public void onFileSelected(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                this.replaceFragment(file);
            } else {
                this.finishWithResult(file);
            }
        } else {
            Toast.makeText((Context)this, (int)R.string.error_selecting_file, (int)0).show();
        }
    }

    private void registerStorageListener() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.MEDIA_REMOVED");
        this.registerReceiver(this.mStorageListener, filter);
    }

    private void unregisterStorageListener() {
        this.unregisterReceiver(this.mStorageListener);
    }
}

