/*
 * Decompiled with CFR 0.152.
 */
package amarenkov.androidx.slidingdatepicker;

import amarenkov.androidx.slidingdatepicker.Date;
import amarenkov.androidx.slidingdatepicker.R;
import amarenkov.androidx.snappyrecyclerview.SnappyAdapter;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;

class Adapter
extends SnappyAdapter<ViewHolder> {
    private ArrayList<Date> mDates = new ArrayList();
    private int mDefaultDay = -1;
    private Drawable mBgDateSelected;
    private Drawable mBgDateDefault;
    private int mColorDateSelected;
    private int mColorDateNotSelected;
    private int mDateItemSpacing;
    private String[] mWeekdaysArray;

    Adapter(Drawable bgDateSelected, Drawable bgDateDefault, int colorDateSelected, int colorDateNotSelected, int dateItemSpacing, String[] weekdaysArray) {
        this.mBgDateSelected = bgDateSelected;
        this.mBgDateDefault = bgDateDefault;
        this.mColorDateSelected = colorDateSelected;
        this.mColorDateNotSelected = colorDateNotSelected;
        this.mDateItemSpacing = dateItemSpacing;
        this.mWeekdaysArray = weekdaysArray;
    }

    void dispatchList(ArrayList<Date> dates, int defaultDay) {
        if (this.snapper.getSnappedPosition() > dates.size() - 1) {
            this.snapper.snapToPosition(dates.size() - 1);
        }
        this.mDates.clear();
        this.mDates.addAll(dates);
        this.mDefaultDay = defaultDay;
        this.notifyDataSetChanged();
    }

    int getCurrentDate() {
        return this.snapper.getSnappedPosition();
    }

    public int getItemCount() {
        return this.mDates.size();
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int i) {
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.sdp_item, parent, false));
    }

    protected void onBindViewHolder(@NonNull ViewHolder viewHolder, int position, boolean isAtTheCenter) {
        if (isAtTheCenter) {
            viewHolder.select(this.mDates.get(position));
        } else {
            viewHolder.deselect(this.mDates.get(position));
        }
    }

    protected void onSnapedFromCenter(@NonNull ViewHolder viewHolder) {
        viewHolder.deselect();
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvDate;
        private TextView tvWeekday;

        ViewHolder(View itemView) {
            super(itemView);
            this.tvDate = (TextView)itemView.findViewById(R.id.date);
            this.tvWeekday = (TextView)itemView.findViewById(R.id.weekday);
            RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)itemView.getLayoutParams();
            lp.leftMargin = Adapter.this.mDateItemSpacing;
            lp.rightMargin = Adapter.this.mDateItemSpacing;
            itemView.setLayoutParams((ViewGroup.LayoutParams)lp);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ViewHolder.this.getAdapterPosition() == Adapter.this.snapper.getSnappedPosition()) {
                        return;
                    }
                    Adapter.this.snapper.smoothSnapToPosition(ViewHolder.this.getAdapterPosition());
                }
            });
        }

        void select(Date date) {
            this.tvDate.setText((CharSequence)String.valueOf(date.getDate()));
            this.tvWeekday.setText((CharSequence)Adapter.this.mWeekdaysArray[date.getWeekday() - 1]);
            this.tvDate.setBackground(Adapter.this.mBgDateSelected);
            this.tvDate.setTextColor(Adapter.this.mColorDateSelected);
        }

        void deselect(Date date) {
            this.tvDate.setText((CharSequence)String.valueOf(date.getDate()));
            this.tvWeekday.setText((CharSequence)Adapter.this.mWeekdaysArray[date.getWeekday() - 1]);
            if (this.getAdapterPosition() == Adapter.this.mDefaultDay) {
                this.tvDate.setBackground(Adapter.this.mBgDateDefault);
            } else {
                this.tvDate.setBackground(null);
            }
            this.tvDate.setTextColor(Adapter.this.mColorDateNotSelected);
        }

        void deselect() {
            if (this.getAdapterPosition() == Adapter.this.mDefaultDay) {
                this.tvDate.setBackground(Adapter.this.mBgDateDefault);
            } else {
                this.tvDate.setBackground(null);
            }
            this.tvDate.setTextColor(Adapter.this.mColorDateNotSelected);
        }
    }
}

