/*
 * Decompiled with CFR 0.152.
 */
package amarenkov.androidx.slidingdatepicker;

import amarenkov.androidx.slidingdatepicker.Adapter;
import amarenkov.androidx.slidingdatepicker.Date;
import amarenkov.androidx.slidingdatepicker.R;
import amarenkov.androidx.snappyrecyclerview.SnappyAdapter;
import amarenkov.androidx.snappyrecyclerview.SnappyRecyclerView;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Calendar;

public class SlidingDatePicker
extends FrameLayout {
    private static final String SDP_DEFAULT = "SDP_DEFAULT_";
    private static final String SDP_LAST = "SDP_LAST_";
    private static final int FORWARD = 1;
    private static final int BACKWARD = -1;
    private static final int NONE = 0;
    private SnappyRecyclerView rv;
    private TextView tvMonth;
    private TextView highlight;
    private Adapter mAdapter;
    private boolean mShowDefaultDate;
    private Calendar mCalendar = Calendar.getInstance();
    private int mDefaultYear = this.mCalendar.get(1);
    private int mDefaultMonth = this.mCalendar.get(2);
    private int mDefaultDay = this.mCalendar.get(5);
    private String[] mMonthsArray = this.getResources().getStringArray(R.array.SDPMonthsArray);
    private String[] mWeekdaysArray = this.getResources().getStringArray(R.array.SDPWeekdaysArray);
    private float mMaxAlpha = 1.0f;
    private int spacing;
    private int itemSize;

    public SlidingDatePicker(@NonNull Context context) {
        this(context, null);
    }

    public SlidingDatePicker(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SlidingDatePicker(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(@Nullable AttributeSet attrs) {
        View view = SlidingDatePicker.inflate((Context)this.getContext(), (int)R.layout.sdp_layout, (ViewGroup)this);
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.SlidingDatePicker, 0, 0);
        this.tvMonth = (TextView)view.findViewById(R.id.month);
        this.mMaxAlpha = this.tvMonth.getAlpha();
        ImageView left = (ImageView)view.findViewById(R.id.chevron_left);
        ImageView right = (ImageView)view.findViewById(R.id.chevron_right);
        if (typedArray.getBoolean(R.styleable.SlidingDatePicker_sdp_enable_chevrons, true)) {
            left.setColorFilter(this.tvMonth.getCurrentTextColor(), PorterDuff.Mode.SRC_IN);
            right.setColorFilter(this.tvMonth.getCurrentTextColor(), PorterDuff.Mode.SRC_IN);
            left.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SlidingDatePicker.this.previousMonth();
                }
            });
            right.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SlidingDatePicker.this.nextMonth();
                }
            });
        } else {
            left.setVisibility(8);
            right.setVisibility(8);
        }
        this.mShowDefaultDate = typedArray.getBoolean(R.styleable.SlidingDatePicker_sdp_enable_default_date, true);
        this.highlight = (TextView)view.findViewById(R.id.highlight);
        this.spacing = (int)typedArray.getDimension(R.styleable.SlidingDatePicker_sdp_date_item_spacing, 0.0f);
        Drawable bgDateSelected = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.sdp_bg_date_selected);
        Drawable bgDateDefault = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.sdp_bg_date_default);
        int colorDateSelected = typedArray.getColor(R.styleable.SlidingDatePicker_sdp_date_color_selected, ContextCompat.getColor((Context)this.getContext(), (int)17170443));
        this.mAdapter = new Adapter(bgDateSelected, bgDateDefault, colorDateSelected, this.highlight.getCurrentTextColor(), this.spacing, this.mWeekdaysArray);
        this.rv = (SnappyRecyclerView)view.findViewById(R.id.rv);
        this.rv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
        this.rv.enableSnapListener(SnappyRecyclerView.Behavior.NOTIFY_ON_IDLE_AND_NO_POSITION);
        this.rv.setAdapter((RecyclerView.Adapter)this.mAdapter);
        if (typedArray.getBoolean(R.styleable.SlidingDatePicker_sdp_enable_highlight, true)) {
            this.highlight.setBackground(bgDateSelected);
        } else {
            this.highlight.setVisibility(4);
        }
        this.highlight.post(new Runnable(){

            @Override
            public void run() {
                SlidingDatePicker.this.itemSize = SlidingDatePicker.this.highlight.getWidth();
                SlidingDatePicker.this.rv.resetCenteringPadding(SlidingDatePicker.this.itemSize, SlidingDatePicker.this.spacing, SlidingDatePicker.this.mDefaultDay - 1);
                SlidingDatePicker.this.setMonth(-1, 0);
            }
        });
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.itemSize == 0) {
            this.highlight.post(new Runnable(){

                @Override
                public void run() {
                    SlidingDatePicker.this.itemSize = SlidingDatePicker.this.highlight.getWidth();
                    SlidingDatePicker.this.rv.resetCenteringPadding(SlidingDatePicker.this.itemSize, SlidingDatePicker.this.spacing, SlidingDatePicker.this.mDefaultDay - 1);
                }
            });
        }
    }

    private void setMonth(int date, int direction) {
        this.mCalendar.set(5, 1);
        int count = this.mCalendar.getActualMaximum(5);
        int dayOfWeek = this.mCalendar.get(7);
        ArrayList<Date> dates = new ArrayList<Date>();
        ++count;
        for (int i = 1; i < count; ++i) {
            dates.add(new Date(i, dayOfWeek));
            if (dayOfWeek < 7) {
                ++dayOfWeek;
                continue;
            }
            dayOfWeek = 1;
        }
        String newMonth = this.mMonthsArray[this.mCalendar.get(2)] + " " + String.valueOf(this.mCalendar.get(1));
        switch (direction) {
            case 1: {
                this.animateMonthForward(newMonth);
                break;
            }
            case -1: {
                this.animateMonthBackward(newMonth);
                break;
            }
            default: {
                this.tvMonth.setText((CharSequence)newMonth);
            }
        }
        if (this.mShowDefaultDate && this.mDefaultMonth == this.mCalendar.get(2) && this.mDefaultYear == this.mCalendar.get(1)) {
            this.mAdapter.dispatchList(dates, this.mDefaultDay - 1);
        } else {
            this.mAdapter.dispatchList(dates, -1);
        }
        if (date != -1) {
            this.rv.smoothSnapToPosition(date);
        }
    }

    private void animateMonthBackward(final String newMonth) {
        final float translationDelta = (float)this.tvMonth.getWidth() / 2.0f;
        this.tvMonth.animate().alpha(0.0f).translationX(translationDelta).withEndAction(new Runnable(){

            @Override
            public void run() {
                SlidingDatePicker.this.tvMonth.setText((CharSequence)newMonth);
                SlidingDatePicker.this.tvMonth.setTranslationX(-translationDelta);
                SlidingDatePicker.this.tvMonth.animate().alpha(SlidingDatePicker.this.mMaxAlpha).translationX(0.0f).start();
            }
        }).start();
    }

    private void animateMonthForward(final String newMonth) {
        final float translationDelta = (float)this.tvMonth.getWidth() / 2.0f;
        this.tvMonth.animate().alpha(0.0f).translationX(-translationDelta).withEndAction(new Runnable(){

            @Override
            public void run() {
                SlidingDatePicker.this.tvMonth.setText((CharSequence)newMonth);
                SlidingDatePicker.this.tvMonth.setTranslationX(translationDelta);
                SlidingDatePicker.this.tvMonth.animate().alpha(SlidingDatePicker.this.mMaxAlpha).translationX(0.0f).start();
            }
        }).start();
    }

    public void backToDefaultDate() {
        int year = this.mCalendar.get(1);
        int month = this.mCalendar.get(2);
        this.mCalendar.set(1, this.mDefaultYear);
        this.mCalendar.set(2, this.mDefaultMonth);
        int direction = year > this.mDefaultYear ? -1 : (year < this.mDefaultYear ? 1 : (month > this.mDefaultMonth ? -1 : (month < this.mDefaultMonth ? 1 : 0)));
        this.setMonth(this.mDefaultDay - 1, direction);
    }

    public void backToDefaultDateForced() {
        this.mCalendar.set(1, this.mDefaultYear);
        this.mCalendar.set(2, this.mDefaultMonth);
        this.tvMonth.setText((CharSequence)(this.mMonthsArray[this.mDefaultMonth] + " " + String.valueOf(this.mDefaultYear)));
        this.rv.snapToPosition(this.mDefaultDay - 1);
    }

    public void nextMonth() {
        this.mCalendar.add(2, 1);
        this.setMonth(-1, 1);
    }

    public void previousMonth() {
        this.mCalendar.add(2, -1);
        this.setMonth(-1, -1);
    }

    public Calendar getCalendar() {
        this.mCalendar.set(5, this.mAdapter.getCurrentDate() + 1);
        return this.mCalendar;
    }

    public Calendar getDefaultCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.mDefaultYear, this.mDefaultMonth, this.mDefaultDay);
        return calendar;
    }

    public void setCalendar(Long time) {
        this.mCalendar.setTimeInMillis(time);
        this.mDefaultYear = this.mCalendar.get(1);
        this.mDefaultMonth = this.mCalendar.get(2);
        this.mDefaultDay = this.mCalendar.get(5);
        if (this.rv.isPaddingApplied()) {
            this.setMonth(this.mDefaultDay - 1, 0);
        }
    }

    public void saveInstanceState(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        this.mCalendar.set(5, this.mAdapter.getCurrentDate() + 1);
        bundle.putLong(SDP_LAST + this.getId(), this.mCalendar.getTimeInMillis());
        this.mCalendar.set(this.mDefaultYear, this.mDefaultMonth, this.mDefaultDay);
        bundle.putLong(SDP_DEFAULT + this.getId(), this.mCalendar.getTimeInMillis());
    }

    public void restoreInstanceState(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        this.mCalendar.setTimeInMillis(bundle.getLong(SDP_DEFAULT + this.getId()));
        this.mDefaultYear = this.mCalendar.get(1);
        this.mDefaultMonth = this.mCalendar.get(2);
        this.mDefaultDay = this.mCalendar.get(5);
        this.mCalendar.setTimeInMillis(bundle.getLong(SDP_LAST + this.getId()));
    }

    public void setCallback(final Callback callback) {
        this.mAdapter.setCallback(new SnappyAdapter.Callback(){

            public void onItemCentered(int position) {
                SlidingDatePicker.this.mCalendar.set(5, position + 1);
                callback.onDatePicked(SlidingDatePicker.this.mCalendar);
            }
        });
    }

    public static interface Callback {
        public void onDatePicked(Calendar var1);
    }
}

