/*
 * Decompiled with CFR 0.152.
 */
package am.util.font;

import am.util.font.Alias;
import am.util.font.Fallback;
import am.util.font.Family;
import am.util.font.FamilySet;
import am.util.font.Font;
import am.util.font.FontsReaderBase;
import android.text.TextUtils;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;

class FontsReaderApi14
extends FontsReaderBase {
    protected static final String NAME_FAMILYSET = "familyset";
    protected static final String NAME_FAMILY = "family";
    protected static final String NAME_NAMESET = "nameset";
    protected static final String NAME_FILESET = "fileset";
    protected static final String NAME_FILE = "file";
    protected Family mFamily;
    protected Fallback mFallback;
    protected boolean mIsFallback = false;
    private ArrayList<String> mNames = new ArrayList();

    FontsReaderApi14() {
    }

    @Override
    public String getConfigDir() {
        return "/system/etc";
    }

    @Override
    public String getFontsDir() {
        return "/system/fonts";
    }

    @Override
    public FamilySet readConfig() {
        FileReader fallback;
        FileReader system;
        File systemFile = new File(this.getConfigDir(), "system_fonts.xml");
        File fallbackFile = new File(this.getConfigDir(), "fallback_fonts.xml");
        if (!(systemFile.exists() && systemFile.isFile() && systemFile.canRead() && fallbackFile.exists() && fallbackFile.isFile() && fallbackFile.canRead())) {
            return null;
        }
        try {
            system = new FileReader(systemFile);
        }
        catch (Exception e) {
            return null;
        }
        this.mIsFallback = false;
        this.readConfig(system);
        try {
            ((Reader)system).close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            fallback = new FileReader(fallbackFile);
        }
        catch (Exception e) {
            return null;
        }
        this.mIsFallback = true;
        this.readConfig(fallback);
        try {
            ((Reader)fallback).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mSet;
    }

    @Override
    protected boolean startTag(XmlPullParser parser) {
        String name;
        switch (name = parser.getName()) {
            case "familyset": {
                this.startFamilySet(parser);
                return true;
            }
            case "family": {
                this.startFamily(parser);
                return true;
            }
            case "nameset": {
                this.startNameSet();
                return true;
            }
            case "name": {
                this.startName(parser);
                return true;
            }
            case "fileset": {
                return true;
            }
            case "file": {
                this.startFile(parser);
                return true;
            }
        }
        return false;
    }

    protected void startFamilySet(XmlPullParser parser) {
        if (!this.mIsFallback) {
            this.mSet = new FamilySet(null);
        }
    }

    protected void startFamily(XmlPullParser parser) {
        if (this.mIsFallback) {
            this.mFallback = new Fallback();
        }
    }

    protected void startNameSet() {
        this.mNames.clear();
    }

    @Override
    protected void startName(XmlPullParser parser) {
        try {
            if (parser.next() != 4) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        this.mNames.add(parser.getText());
    }

    protected void startFile(XmlPullParser parser) {
        int style;
        int weight;
        try {
            if (parser.next() != 4) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        String name = parser.getText();
        if (TextUtils.isEmpty((CharSequence)name)) {
            return;
        }
        if (name.contains("-BoldItalic.")) {
            weight = 700;
            style = 1;
        } else if (name.contains("-Bold.")) {
            weight = 700;
            style = 0;
        } else if (name.contains("-BlackItalic.")) {
            weight = 900;
            style = 1;
        } else if (name.contains("-Black.")) {
            weight = 900;
            style = 0;
        } else if (name.contains("-MediumItalic.")) {
            weight = 500;
            style = 1;
        } else if (name.contains("-Medium.")) {
            weight = 500;
            style = 0;
        } else if (name.contains("-Italic.")) {
            weight = 400;
            style = 1;
        } else if (name.contains("-LightItalic.")) {
            weight = 300;
            style = 1;
        } else if (name.contains("-Light.")) {
            weight = 300;
            style = 0;
        } else if (name.contains("-ThinItalic.")) {
            weight = 100;
            style = 1;
        } else if (name.contains("-Thin.")) {
            weight = 100;
            style = 0;
        } else {
            weight = 400;
            style = 0;
        }
        if (this.mFallback != null) {
            this.mFallback.addFont(new Font(name, weight, style));
            return;
        }
        if (this.mFamily != null) {
            this.mFamily.addFont(new Font(name, weight, style));
        }
    }

    @Override
    protected boolean endTag(XmlPullParser parser) {
        String name;
        switch (name = parser.getName()) {
            case "familyset": {
                this.endFamilySet();
                return true;
            }
            case "family": {
                this.endFamily();
                return true;
            }
            case "nameset": {
                this.endNameSet();
                return true;
            }
            case "name": {
                return true;
            }
            case "fileset": {
                return true;
            }
            case "file": {
                return true;
            }
        }
        return false;
    }

    protected void endFamilySet() {
        if (!this.mIsFallback) {
            return;
        }
        if (this.mSet != null && this.mSet.isAvailable()) {
            return;
        }
        this.mSet = null;
    }

    protected void endFamily() {
        if (this.mSet != null) {
            if (this.mFamily != null) {
                this.mSet.putFamily(this.mFamily);
                String to = this.mFamily.getName();
                int count = this.mNames.size();
                for (int i = 1; i < count; ++i) {
                    this.mSet.putAlias(new Alias(this.mNames.get(i), to, -1));
                }
            }
            this.mSet.putFallback(this.mFallback);
        }
        this.mFamily = null;
        this.mFallback = null;
    }

    protected void endNameSet() {
        if (this.mNames.isEmpty()) {
            return;
        }
        this.mFamily = new Family(this.mNames.get(0));
    }
}

