/*
 * Decompiled with CFR 0.152.
 */
package am.util.font;

import am.util.font.Alias;
import am.util.font.Fallback;
import am.util.font.Family;
import am.util.font.TypefaceCollection;
import am.util.font.TypefaceFallback;
import am.util.font.TypefaceItem;
import java.util.ArrayList;
import java.util.HashMap;

class FamilySet {
    private final String mVersion;
    private final ArrayList<String> mNames = new ArrayList();
    private final HashMap<String, Family> mSystemFamily = new HashMap();
    private final ArrayList<String> mAliases = new ArrayList();
    private final HashMap<String, Alias> mSystemFamilyAlias = new HashMap();
    private final ArrayList<Fallback> mFallbacks = new ArrayList();

    FamilySet(String version) {
        this.mVersion = version;
    }

    boolean putFamily(Family family) {
        if (family == null || !family.isAvailable()) {
            return false;
        }
        String name = family.getName();
        this.mNames.add(name);
        this.mSystemFamily.put(name, family);
        return true;
    }

    void putAlias(Alias alias) {
        if (alias == null || !alias.isAvailable()) {
            return;
        }
        String to = alias.getTo();
        if (this.mSystemFamily.containsKey(to)) {
            String name = alias.getName();
            this.mAliases.add(name);
            this.mSystemFamilyAlias.put(name, alias);
        }
    }

    void putFallback(Fallback fallback) {
        if (fallback == null || !fallback.isAvailable()) {
            return;
        }
        this.mFallbacks.add(fallback);
    }

    boolean isAvailable() {
        return this.mSystemFamily.size() > 0;
    }

    String getVersion() {
        return this.mVersion;
    }

    ArrayList<String> getNames() {
        return this.mNames;
    }

    ArrayList<String> getAliases() {
        return this.mAliases;
    }

    TypefaceCollection getTypefaceCollection(String nameOrAlias) {
        Alias alias;
        Family family = this.mSystemFamily.get(nameOrAlias);
        int weight = -1;
        if (family == null && (alias = this.mSystemFamilyAlias.get(nameOrAlias)) != null) {
            family = this.mSystemFamily.get(alias.getTo());
            weight = alias.getWeight();
        }
        if (family == null) {
            return null;
        }
        String name = family.getName();
        ArrayList<TypefaceItem> items = family.convert(weight);
        ArrayList<TypefaceFallback> fallbacks = this.getFallbacks(name);
        if (items == null || fallbacks == null) {
            return null;
        }
        return new TypefaceCollection(name, items, fallbacks);
    }

    private ArrayList<TypefaceFallback> getFallbacks(String name) {
        ArrayList<TypefaceFallback> fallbacks = new ArrayList<TypefaceFallback>();
        for (Fallback fallback : this.mFallbacks) {
            TypefaceFallback f = fallback.convert(name);
            if (f == null) continue;
            fallbacks.add(f);
        }
        return fallbacks.isEmpty() ? null : fallbacks;
    }
}

