/*
 * Decompiled with CFR 0.152.
 */
package am.util.font;

import am.util.font.Font;
import am.util.font.TypefaceItem;
import android.text.TextUtils;
import java.util.ArrayList;

class Family {
    private final String mName;
    private final ArrayList<Font> mFonts = new ArrayList();

    Family(String name) {
        this.mName = name;
    }

    boolean isAvailable() {
        return !TextUtils.isEmpty((CharSequence)this.mName) && this.mFonts.size() > 0;
    }

    void addFont(Font font) {
        if (font == null) {
            return;
        }
        this.mFonts.add(font);
    }

    String getName() {
        return this.mName;
    }

    ArrayList<TypefaceItem> convert(int weight) {
        ArrayList<TypefaceItem> items = new ArrayList<TypefaceItem>();
        for (Font font : this.mFonts) {
            if (weight == -1) {
                items.add(font.convert());
                continue;
            }
            if (weight != font.getWeight()) continue;
            items.add(font.convert());
        }
        return items.isEmpty() ? null : items;
    }
}

