/*
 * Decompiled with CFR 0.152.
 */
package am.util.font;

import am.util.font.Font;
import am.util.font.TypefaceFallback;
import am.util.font.TypefaceItem;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashSet;

class Fallback {
    private final ArrayList<Font> mFonts = new ArrayList();
    private String mLang;
    private String mVariant;
    private final HashSet<String> mFallbackForSet = new HashSet();
    private final ArrayList<Font> mFallbackForFonts = new ArrayList();

    Fallback() {
    }

    boolean isAvailable() {
        return this.mFonts.size() > 0;
    }

    void setLang(String lang) {
        this.mLang = lang;
    }

    void setVariant(String variant) {
        this.mVariant = variant;
    }

    void addFont(Font font) {
        if (font == null) {
            return;
        }
        String fallbackFor = font.getFallbackFor();
        if (fallbackFor == null) {
            this.mFonts.add(font);
        } else {
            this.mFallbackForSet.add(fallbackFor);
            this.mFallbackForFonts.add(font);
        }
    }

    TypefaceFallback convert(String name) {
        boolean capture;
        ArrayList<TypefaceItem> items = new ArrayList<TypefaceItem>();
        boolean bl = capture = !this.mFallbackForSet.isEmpty() && this.mFallbackForSet.contains(name);
        if (capture) {
            for (Font font : this.mFallbackForFonts) {
                if (!TextUtils.equals((CharSequence)font.getFallbackFor(), (CharSequence)name)) continue;
                items.add(font.convert());
            }
        } else {
            for (Font font : this.mFonts) {
                items.add(font.convert());
            }
        }
        if (items.isEmpty()) {
            return null;
        }
        return new TypefaceFallback(this.mLang, this.mVariant, items);
    }
}

