/*
 * Decompiled with CFR 0.152.
 */
package am.util.font;

import am.util.font.Axis;
import am.util.font.FontsReaderApi24;
import android.text.TextUtils;
import org.xmlpull.v1.XmlPullParser;

class FontsReaderApi26
extends FontsReaderApi24 {
    protected static final String NAME_AXIS = "axis";
    protected static final String ATTR_TAG = "tag";
    protected static final String ATTR_STYLEVALUE = "stylevalue";
    protected Axis mAxis;

    FontsReaderApi26() {
    }

    @Override
    protected boolean startTag(XmlPullParser parser) {
        String name;
        if (super.startTag(parser)) {
            return true;
        }
        switch (name = parser.getName()) {
            case "axis": {
                this.startAxis(parser);
                return true;
            }
        }
        return false;
    }

    protected void startAxis(XmlPullParser parser) {
        float value;
        String tag = parser.getAttributeValue(null, ATTR_TAG);
        if (TextUtils.isEmpty((CharSequence)tag)) {
            return;
        }
        try {
            value = Float.parseFloat(parser.getAttributeValue(null, ATTR_STYLEVALUE));
        }
        catch (Exception e) {
            return;
        }
        if ("ital".equals(tag) || "opsz".equals(tag) || "slnt".equals(tag) || "wdth".equals(tag) || "wght".equals(tag)) {
            this.mAxis = new Axis(tag, value);
        }
    }

    @Override
    protected boolean endTag(XmlPullParser parser) {
        String name;
        if (super.endTag(parser)) {
            return true;
        }
        switch (name = parser.getName()) {
            case "axis": {
                this.endAxis();
                return true;
            }
        }
        return false;
    }

    protected void endAxis() {
        if (this.mFont != null) {
            this.mFont.putAxis(this.mAxis);
        }
        this.mAxis = null;
    }
}

