/*
 * Decompiled with CFR 0.152.
 */
package am.util.font;

import am.util.font.TypefaceAxis;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TypefaceItem
implements Parcelable {
    public static final int STYLE_NORMAL = 0;
    public static final int STYLE_ITALIC = 1;
    private final String mName;
    private final int mWeight;
    private final int mStyle;
    private final int mIndex;
    private final Map<String, TypefaceAxis> mAxises;
    public static final Parcelable.Creator<TypefaceItem> CREATOR = new Parcelable.Creator<TypefaceItem>(){

        public TypefaceItem createFromParcel(Parcel source) {
            return new TypefaceItem(source);
        }

        public TypefaceItem[] newArray(int size) {
            return new TypefaceItem[size];
        }
    };

    public TypefaceItem(String name, int weight, int style, int index, Map<String, TypefaceAxis> axises) {
        this.mName = name;
        this.mWeight = weight;
        this.mStyle = style;
        this.mIndex = index;
        this.mAxises = axises;
    }

    public String getName() {
        return this.mName;
    }

    public int getWeight() {
        return this.mWeight;
    }

    public int getStyle() {
        return this.mStyle;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public int getAxisCount() {
        return this.mAxises == null ? 0 : this.mAxises.size();
    }

    public TypefaceAxis getAxis(String tag) {
        if (tag == null || this.mAxises == null) {
            return null;
        }
        if ("ital".equals(tag) || "opsz".equals(tag) || "slnt".equals(tag) || "wdth".equals(tag) || "wght".equals(tag)) {
            return this.mAxises.get(tag);
        }
        return null;
    }

    public Map<String, TypefaceAxis> getAxises() {
        return this.mAxises;
    }

    public String toString() {
        return "TypefaceItem{name='" + this.mName + '\'' + ", weight=" + this.mWeight + ", style=" + this.mStyle + ", index=" + this.mIndex + ", axises=" + (this.mAxises == null ? "null" : this.mAxises.toString()) + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mName);
        dest.writeInt(this.mWeight);
        dest.writeInt(this.mStyle);
        dest.writeInt(this.mIndex);
        int size = this.mAxises == null ? 0 : this.mAxises.size();
        dest.writeInt(size);
        if (size > 0) {
            Set<Map.Entry<String, TypefaceAxis>> axisesSet = this.mAxises.entrySet();
            for (Map.Entry<String, TypefaceAxis> entry : axisesSet) {
                dest.writeString(entry.getKey());
                dest.writeParcelable((Parcelable)entry.getValue(), flags);
            }
        }
    }

    private TypefaceItem(Parcel in) {
        this.mName = in.readString();
        this.mWeight = in.readInt();
        this.mStyle = in.readInt();
        this.mIndex = in.readInt();
        int size = in.readInt();
        if (size > 0) {
            this.mAxises = new HashMap<String, TypefaceAxis>(size);
            for (int i = 0; i < size; ++i) {
                String key = in.readString();
                TypefaceAxis value = (TypefaceAxis)in.readParcelable(TypefaceAxis.class.getClassLoader());
                this.mAxises.put(key, value);
            }
        } else {
            this.mAxises = null;
        }
    }
}

