/*
 * Decompiled with CFR 0.152.
 */
package am.util.font;

import am.util.font.Alias;
import am.util.font.Fallback;
import am.util.font.Family;
import am.util.font.FamilySet;
import am.util.font.Font;
import am.util.font.FontsReader;
import android.text.TextUtils;
import android.util.Xml;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;

class FontsReaderBase
implements FontsReader {
    protected static final String NAME_FONTS = "fonts";
    protected static final String NAME_FONT = "font";
    protected static final String NAME_NAME = "name";
    protected static final String NAME_FALLBACK = "fallback";
    protected static final String ATTR_TTF = "ttf";
    protected FamilySet mSet;
    private String mTTF;
    private ArrayList<String> mNames = new ArrayList();

    FontsReaderBase() {
    }

    @Override
    public String getConfigDir() {
        return "/system/etc";
    }

    @Override
    public String getFontsDir() {
        return "/system/fonts";
    }

    @Override
    public FamilySet readConfig() {
        FileReader reader;
        File config = new File(this.getConfigDir(), "fonts.xml");
        if (!(config.exists() && config.isFile() && config.canRead())) {
            return null;
        }
        try {
            reader = new FileReader(config);
        }
        catch (Exception e) {
            return null;
        }
        this.readConfig(reader);
        try {
            ((Reader)reader).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mSet;
    }

    protected void readConfig(Reader reader) {
        XmlPullParser parser;
        try {
            parser = Xml.newPullParser();
            parser.setInput(reader);
        }
        catch (Exception e) {
            return;
        }
        try {
            int event = parser.getEventType();
            while (true) {
                switch (event) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return;
                    }
                    case 2: {
                        this.startTag(parser);
                        break;
                    }
                    case 3: {
                        this.endTag(parser);
                    }
                }
                event = parser.next();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    protected boolean startTag(XmlPullParser parser) {
        String name;
        switch (name = parser.getName()) {
            case "fonts": {
                this.startFonts(parser);
                return true;
            }
            case "font": {
                this.startFont(parser);
                return true;
            }
            case "name": {
                this.startName(parser);
                return true;
            }
            case "fallback": {
                this.startFallback(parser);
                return true;
            }
        }
        return false;
    }

    protected void startFonts(XmlPullParser parser) {
        this.mSet = new FamilySet(null);
    }

    protected void startFont(XmlPullParser parser) {
        this.mTTF = parser.getAttributeValue(null, ATTR_TTF);
        this.mNames.clear();
    }

    protected void startName(XmlPullParser parser) {
        try {
            if (parser.next() != 4) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        this.mNames.add(parser.getText());
    }

    protected void startFallback(XmlPullParser parser) {
        if (this.mSet == null) {
            return;
        }
        String ttf = parser.getAttributeValue(null, ATTR_TTF);
        if (TextUtils.isEmpty((CharSequence)ttf)) {
            return;
        }
        Fallback fallback = new Fallback();
        fallback.addFont(this.getFont(ttf + "-Thin.ttf", 100, 0));
        fallback.addFont(this.getFont(ttf + "-ThinItalic.ttf", 100, 1));
        fallback.addFont(this.getFont(ttf + "-Light.ttf", 300, 0));
        fallback.addFont(this.getFont(ttf + "-LightItalic.ttf", 300, 1));
        fallback.addFont(this.getFont(ttf + ".ttf", 400, 0));
        fallback.addFont(this.getFont(ttf + "-Regular.ttf", 400, 0));
        fallback.addFont(this.getFont(ttf + "-Italic.ttf", 400, 1));
        fallback.addFont(this.getFont(ttf + "-Medium.ttf", 500, 0));
        fallback.addFont(this.getFont(ttf + "-MediumItalic.ttf", 500, 1));
        fallback.addFont(this.getFont(ttf + "-Black.ttf", 900, 0));
        fallback.addFont(this.getFont(ttf + "-BlackItalic.ttf", 900, 1));
        fallback.addFont(this.getFont(ttf + "-Bold.ttf", 700, 0));
        fallback.addFont(this.getFont(ttf + "-BoldItalic.ttf", 700, 1));
        this.mSet.putFallback(fallback);
    }

    protected boolean endTag(XmlPullParser parser) {
        String name;
        switch (name = parser.getName()) {
            case "fonts": {
                this.endFonts();
                return true;
            }
            case "font": {
                this.endFont();
                return true;
            }
            case "name": {
                return true;
            }
            case "fallback": {
                return true;
            }
        }
        return false;
    }

    protected void endFonts() {
        if (this.mSet != null && this.mSet.isAvailable()) {
            return;
        }
        this.mSet = null;
    }

    protected void endFont() {
        if (this.mSet == null || this.mNames.isEmpty() || TextUtils.isEmpty((CharSequence)this.mTTF)) {
            this.mNames.clear();
            this.mTTF = null;
            return;
        }
        String to = this.mNames.get(0);
        Family family = new Family(to);
        family.addFont(this.getFont(this.mTTF + "-Thin.ttf", 100, 0));
        family.addFont(this.getFont(this.mTTF + "-ThinItalic.ttf", 100, 1));
        family.addFont(this.getFont(this.mTTF + "-Light.ttf", 300, 0));
        family.addFont(this.getFont(this.mTTF + "-LightItalic.ttf", 300, 1));
        family.addFont(this.getFont(this.mTTF + ".ttf", 400, 0));
        family.addFont(this.getFont(this.mTTF + "-Regular.ttf", 400, 0));
        family.addFont(this.getFont(this.mTTF + "-Italic.ttf", 400, 1));
        family.addFont(this.getFont(this.mTTF + "-Medium.ttf", 500, 0));
        family.addFont(this.getFont(this.mTTF + "-MediumItalic.ttf", 500, 1));
        family.addFont(this.getFont(this.mTTF + "-Black.ttf", 900, 0));
        family.addFont(this.getFont(this.mTTF + "-BlackItalic.ttf", 900, 1));
        family.addFont(this.getFont(this.mTTF + "-Bold.ttf", 700, 0));
        family.addFont(this.getFont(this.mTTF + "-BoldItalic.ttf", 700, 1));
        if (this.mSet.putFamily(family)) {
            int count = this.mNames.size();
            for (int i = 1; i < count; ++i) {
                this.mSet.putAlias(new Alias(this.mNames.get(i), to, -1));
            }
        }
        this.mTTF = null;
    }

    private Font getFont(String name, int weight, int style) {
        File font = new File(this.getFontsDir(), name);
        if (font.exists() && font.isFile()) {
            return new Font(name, weight, style);
        }
        return null;
    }
}

