/*
 * Decompiled with CFR 0.152.
 */
package am.util.font;

import am.util.font.Alias;
import am.util.font.Fallback;
import am.util.font.Family;
import am.util.font.FamilySet;
import am.util.font.Font;
import am.util.font.FontsReaderApi17;
import android.text.TextUtils;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParser;

class FontsReaderApi21
extends FontsReaderApi17 {
    protected static final String NAME_ALIAS = "alias";
    protected static final String ATTR_VERSION = "version";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_TO = "to";
    protected static final String ATTR_WEIGHT = "weight";
    protected static final String ATTR_STYLE = "style";
    protected Alias mAlias;
    protected Font mFont;

    FontsReaderApi21() {
    }

    @Override
    public FamilySet readConfig() {
        FileReader reader;
        File config = new File(this.getConfigDir(), "fonts.xml");
        if (!(config.exists() && config.isFile() && config.canRead())) {
            return null;
        }
        try {
            reader = new FileReader(config);
        }
        catch (Exception e) {
            return null;
        }
        this.readConfig(reader);
        try {
            ((Reader)reader).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mSet;
    }

    @Override
    protected boolean startTag(XmlPullParser parser) {
        String name;
        switch (name = parser.getName()) {
            case "familyset": {
                this.startFamilySet(parser);
                return true;
            }
            case "family": {
                this.startFamily(parser);
                return true;
            }
            case "alias": {
                this.startAlias(parser);
                return true;
            }
            case "font": {
                this.startFont(parser);
                return true;
            }
        }
        return false;
    }

    @Override
    protected void startFamilySet(XmlPullParser parser) {
        String version = parser.getAttributeValue(null, ATTR_VERSION);
        this.mSet = new FamilySet(version);
    }

    @Override
    protected void startFamily(XmlPullParser parser) {
        String name = parser.getAttributeValue(null, ATTR_NAME);
        if (TextUtils.isEmpty((CharSequence)name)) {
            this.mFallback = new Fallback();
            this.mFallback.setLang(parser.getAttributeValue(null, "lang"));
            this.mFallback.setVariant(parser.getAttributeValue(null, "variant"));
        } else {
            this.mFamily = new Family(name);
        }
    }

    protected void startAlias(XmlPullParser parser) {
        int weight;
        String name = parser.getAttributeValue(null, ATTR_NAME);
        if (TextUtils.isEmpty((CharSequence)name)) {
            return;
        }
        String to = parser.getAttributeValue(null, ATTR_TO);
        if (TextUtils.isEmpty((CharSequence)to)) {
            return;
        }
        try {
            weight = Integer.parseInt(parser.getAttributeValue(null, ATTR_WEIGHT));
        }
        catch (Exception e) {
            weight = -1;
        }
        this.mAlias = new Alias(name, to, weight);
    }

    @Override
    protected void startFont(XmlPullParser parser) {
        int weight;
        try {
            weight = Integer.parseInt(parser.getAttributeValue(null, ATTR_WEIGHT));
        }
        catch (Exception e) {
            return;
        }
        try {
            if (parser.next() != 4) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        String name = parser.getText();
        if (TextUtils.isEmpty((CharSequence)name)) {
            return;
        }
        int style = "italic".equals(parser.getAttributeValue(null, ATTR_STYLE)) ? 1 : 0;
        this.mFont = new Font(name, weight, style);
    }

    @Override
    protected boolean endTag(XmlPullParser parser) {
        String name;
        switch (name = parser.getName()) {
            case "familyset": {
                this.endFamilySet();
                return true;
            }
            case "family": {
                this.endFamily();
                return true;
            }
            case "alias": {
                this.endAlias();
                return true;
            }
            case "font": {
                this.endFont();
                return true;
            }
        }
        return false;
    }

    protected void endAlias() {
        if (this.mSet != null) {
            this.mSet.putAlias(this.mAlias);
        }
        this.mAlias = null;
    }

    @Override
    protected void endFont() {
        if (this.mFamily != null) {
            this.mFamily.addFont(this.mFont);
            this.mFont = null;
            return;
        }
        if (this.mFallback != null) {
            this.mFallback.addFont(this.mFont);
            this.mFont = null;
            return;
        }
        this.mFont = null;
    }
}

