/*
 * Decompiled with CFR 0.152.
 */
package am.util.font;

import am.util.font.Axis;
import am.util.font.TypefaceAxis;
import am.util.font.TypefaceItem;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class Font {
    public static final int STYLE_NORMAL = 0;
    public static final int STYLE_ITALIC = 1;
    private final String mName;
    private final int mWeight;
    private final int mStyle;
    private int mIndex = -1;
    private final HashMap<String, Axis> mAxises = new HashMap();
    private String mFallbackFor;

    Font(String name, int weight, int style) {
        this.mName = name;
        this.mWeight = weight;
        this.mStyle = style;
    }

    int getWeight() {
        return this.mWeight;
    }

    void setIndex(int index) {
        this.mIndex = index;
    }

    void putAxis(Axis axis) {
        if (axis == null) {
            return;
        }
        String tag = axis.getTag();
        if (TextUtils.isEmpty((CharSequence)tag)) {
            return;
        }
        this.mAxises.put(tag, axis);
    }

    void setFallbackFor(String fallbackFor) {
        this.mFallbackFor = fallbackFor;
    }

    String getFallbackFor() {
        return this.mFallbackFor;
    }

    TypefaceItem convert() {
        HashMap<String, TypefaceAxis> axises;
        int size = this.mAxises.size();
        if (size <= 0) {
            axises = null;
        } else {
            axises = new HashMap<String, TypefaceAxis>(size);
            Set<Map.Entry<String, Axis>> entries = this.mAxises.entrySet();
            for (Map.Entry<String, Axis> entry : entries) {
                TypefaceAxis axis = entry.getValue().convert();
                axises.put(axis.getTag(), axis);
            }
        }
        int style = this.mStyle == 1 ? 1 : 0;
        return new TypefaceItem(this.mName, this.mWeight, style, this.mIndex, axises);
    }
}

