/**
 * The MIT License (MIT)
 *
 * Copyright (c) 2016 Bertrand Martel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package fr.bmartel.protocol.http.constants;

/**
 * HTTP Header List
 * 
 * @author Bertrand Martel
 *
 */
public class HttpHeader {
	public final static String ACCESS_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
	public final static String ACCEPT              = "Accept"               ;
    public final static String ACCEPT_CHARSET      = "Accept-Charset"       ;
    public final static String ACCEPT_ENCODING     = "Accept-Encoding"      ;
    public final static String ACCEPT_LANGUAGE     = "Accept-Language"      ;
    public final static String ACCEPT_RANGES       = "Accept-Ranges"        ;
    public final static String AGE                 = "Age"                  ;
    public final static String ALLOW               = "Allow"                ;
    public final static String AUTHORIZATION       = "Authorization"        ;
    public final static String CACHE_CONTROL       = "Cache-Control"        ;
    public final static String CONNECTION          = "Connection"           ;
    public final static String CONTENT_ENCODING    = "Content-Encoding"     ;
    public final static String CONTENT_LANGUAGE    = "Content-Language"     ;
    public final static String CONTENT_LENGTH      = "Content-Length"       ;
    public final static String CONTENT_LOCATION    = "Content-Location"     ;
    public final static String CONTENT_MD5         = "Content-MD5"          ;
    public final static String CONTENT_RANGE       = "Content-Range"        ;
    public final static String CONTENT_TYPE        = "Content-Type"         ;
    public final static String DATA                = "Date"                 ;
    public final static String ETAG                = "ETag"                 ;
    public final static String EXPECT              = "Expect"               ;
    public final static String EXPIRES             = "Expires"              ;
    public final static String FROM                = "From"                 ;
    public final static String HOST                = "Host"                 ;
    public final static String IF_MATCH            = "If-Match"             ;
    public final static String IF_MODIFIED_SINCE   = "If-Modified-Since"    ;
    public final static String IF_NONE_MATCH       = "If-None-Match"        ;
    public final static String IF_RANGE            = "If-Range"             ;
    public final static String IF_UNMODIFIED_SINCE = "If-Unmodified-Since"  ;
    public final static String LAST_MODIFIED       = "Last-Modified"        ;
    public final static String LOCATION            = "Location"             ;
    public final static String MAX_FORWARDS        = "Max-Forwards"         ;
    public final static String PRAGMA              = "Pragma"               ;
    public final static String PROXY_AUTHENTICATE  = "Proxy-Authenticate"   ;
    public final static String PROXY_AUTHORIZATION = "Proxy-Authorization"  ;
    public final static String RANGE               = "Range"                ;
    public final static String REFERER             = "Referer"              ;
    public final static String RETRY_AFTER         = "Retry-After"          ;
    public final static String SERVER              = "Server"               ;
    public final static String TE                  = "TE"                   ;
    public final static String TRAILER             = "Trailer"              ;
    public final static String TRANSFER_ENCODING   = "Transfer-Encoding"    ;
    public final static String UPGRADE             = "Upgrade"              ;
    public final static String USER_AGENT          = "User-Agent"           ;
    public final static String VARY                = "Vary"                 ;
    public final static String VIA                 = "Via"                  ;
    public final static String WARNING             = "Warning"              ;
    public final static String WWW_AUTHENTICATE    = "WWW-Authenticate"     ;
    public final static String WEB_SOCKET_ACCEPT   = "Sec-WebSocket-Accept" ;

}
