/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.utils;

import ai.z.openapi.core.config.ZaiConfig;
import ai.z.openapi.core.token.HttpRequestInterceptor;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public final class OkHttps {
    private static final int DEFAULT_CALL_TIMEOUT_SECONDS = 30;
    private static final int DEFAULT_CONNECT_TIMEOUT_SECONDS = 10;
    private static final int DEFAULT_READ_TIMEOUT_SECONDS = 10;
    private static final int DEFAULT_WRITE_TIMEOUT_SECONDS = 10;

    private OkHttps() {
        throw new UnsupportedOperationException("OkHttps is a utility class and cannot be instantiated");
    }

    public static OkHttpClient create(ZaiConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Configuration cannot be null");
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor((Interceptor)new HttpRequestInterceptor(config));
        OkHttps.configureTimeouts(builder, config);
        OkHttps.configureConnectionPool(builder, config);
        return builder.build();
    }

    private static void configureTimeouts(OkHttpClient.Builder builder, ZaiConfig config) {
        TimeUnit timeUnit = config.getTimeOutTimeUnit();
        if (config.getRequestTimeOut() > 0) {
            builder.callTimeout((long)config.getRequestTimeOut(), timeUnit);
        } else {
            builder.callTimeout(30L, TimeUnit.SECONDS);
        }
        if (config.getConnectTimeout() > 0) {
            builder.connectTimeout((long)config.getConnectTimeout(), timeUnit);
        } else {
            builder.connectTimeout(10L, TimeUnit.SECONDS);
        }
        if (config.getReadTimeout() > 0) {
            builder.readTimeout((long)config.getReadTimeout(), timeUnit);
        } else {
            builder.readTimeout(10L, TimeUnit.SECONDS);
        }
        if (config.getWriteTimeout() > 0) {
            builder.writeTimeout((long)config.getWriteTimeout(), timeUnit);
        } else {
            builder.writeTimeout(10L, TimeUnit.SECONDS);
        }
    }

    private static void configureConnectionPool(OkHttpClient.Builder builder, ZaiConfig config) {
        ConnectionPool connectionPool = new ConnectionPool(config.getConnectionPoolMaxIdleConnections(), config.getConnectionPoolKeepAliveDuration(), config.getConnectionPoolTimeUnit());
        builder.connectionPool(connectionPool);
    }
}

