/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.service.videos;

import ai.z.openapi.AbstractAiClient;
import ai.z.openapi.api.videos.VideosApi;
import ai.z.openapi.service.model.AsyncResultRetrieveParams;
import ai.z.openapi.service.videos.VideoCreateParams;
import ai.z.openapi.service.videos.VideosResponse;
import ai.z.openapi.service.videos.VideosService;
import ai.z.openapi.utils.RequestSupplier;
import ai.z.openapi.utils.StringUtils;

public class VideosServiceImpl
implements VideosService {
    private final AbstractAiClient zAiClient;
    private final VideosApi videosApi;

    public VideosServiceImpl(AbstractAiClient client) {
        this.zAiClient = client;
        this.videosApi = (VideosApi)client.retrofit().create(VideosApi.class);
    }

    @Override
    public VideosResponse videoGenerations(VideoCreateParams request) {
        this.validateParams(request);
        RequestSupplier supplier = this.videosApi::videoGenerations;
        return this.zAiClient.executeRequest(request, supplier, VideosResponse.class);
    }

    @Override
    public VideosResponse videoGenerationsResult(String taskId) {
        this.validateTaskId(taskId);
        AsyncResultRetrieveParams request = new AsyncResultRetrieveParams(taskId);
        RequestSupplier supplier = params -> this.videosApi.videoGenerationsResult(params.getTaskId());
        return this.zAiClient.executeRequest(request, supplier, VideosResponse.class);
    }

    private void validateParams(VideoCreateParams request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (StringUtils.isEmpty(request.getModel())) {
            throw new IllegalArgumentException("request model cannot be null or empty");
        }
        if (StringUtils.isEmpty(request.getPrompt())) {
            throw new IllegalArgumentException("request prompt cannot be null or empty");
        }
    }

    private void validateTaskId(String taskId) {
        if (StringUtils.isEmpty(taskId)) {
            throw new IllegalArgumentException("taskId cannot be null or empty");
        }
    }
}

