/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.service.model;

import ai.z.openapi.service.model.SSE;
import ai.z.openapi.service.model.SSEFormatException;
import ai.z.openapi.service.model.ZAiError;
import ai.z.openapi.service.model.ZAiHttpException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.FlowableEmitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;

public class ResponseBodyCallback
implements Callback<ResponseBody> {
    private static final ObjectMapper mapper = new ObjectMapper();
    private FlowableEmitter<SSE> emitter;
    private boolean emitDone;

    public ResponseBodyCallback(FlowableEmitter<SSE> emitter, boolean emitDone) {
        this.emitter = emitter;
        this.emitDone = emitDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
        BufferedReader reader = null;
        try {
            String line;
            if (!response.isSuccessful()) {
                HttpException e = new HttpException(response);
                ResponseBody errorBody = response.errorBody();
                if (errorBody == null) {
                    throw e;
                }
                ZAiError error = (ZAiError)mapper.readValue(errorBody.string(), ZAiError.class);
                throw new ZAiHttpException(error, (Exception)((Object)e), e.code());
            }
            InputStream in = ((ResponseBody)response.body()).byteStream();
            reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            SSE sse = null;
            while (!this.emitter.isCancelled() && (line = reader.readLine()) != null) {
                if (line.startsWith("data:")) {
                    String data = line.substring(5).trim();
                    sse = new SSE(data);
                    continue;
                }
                if (line.equals("") && sse != null) {
                    if (sse.isDone()) {
                        if (!this.emitDone) break;
                        this.emitter.onNext((Object)sse);
                        break;
                    }
                    this.emitter.onNext((Object)sse);
                    sse = null;
                    continue;
                }
                throw new SSEFormatException("Invalid sse format! " + line);
            }
            this.emitter.onComplete();
        }
        catch (Throwable t) {
            this.onFailure(call, t);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException in) {}
            }
        }
    }

    public void onFailure(Call<ResponseBody> call, Throwable t) {
        this.emitter.onError(t);
    }
}

