/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.service.deserialize;

import ai.z.openapi.service.deserialize.BaseNodeDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public final class ObjectDeserializer
extends BaseNodeDeserializer<ObjectNode> {
    private static final long serialVersionUID = 1L;
    private static final ObjectDeserializer _instance = new ObjectDeserializer();

    private ObjectDeserializer() {
        super(ObjectNode.class, true);
    }

    public static ObjectDeserializer getInstance() {
        return _instance;
    }

    public ObjectNode deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.isExpectedStartObjectToken()) {
            return this.deserializeObject(p, ctxt, ctxt.getNodeFactory());
        }
        if (p.hasToken(JsonToken.FIELD_NAME)) {
            return this.deserializeObjectAtName(p, ctxt, ctxt.getNodeFactory());
        }
        if (p.hasToken(JsonToken.END_OBJECT)) {
            return ctxt.getNodeFactory().objectNode();
        }
        return (ObjectNode)ctxt.handleUnexpectedToken(ObjectNode.class, p);
    }

    public ObjectNode deserialize(JsonParser p, DeserializationContext ctxt, ObjectNode node) throws IOException {
        if (p.isExpectedStartObjectToken() || p.hasToken(JsonToken.FIELD_NAME)) {
            return (ObjectNode)this.updateObject(p, ctxt, node);
        }
        return (ObjectNode)ctxt.handleUnexpectedToken(ObjectNode.class, p);
    }
}

