/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.service.batches;

import ai.z.openapi.AbstractAiClient;
import ai.z.openapi.api.batches.BatchesApi;
import ai.z.openapi.service.batches.BatchCreateParams;
import ai.z.openapi.service.batches.BatchRequest;
import ai.z.openapi.service.batches.BatchResponse;
import ai.z.openapi.service.batches.BatchService;
import ai.z.openapi.service.batches.QueryBatchResponse;
import ai.z.openapi.service.file.QueryBatchRequest;
import ai.z.openapi.utils.RequestSupplier;

public class BatchServiceImpl
implements BatchService {
    private final AbstractAiClient zAiClient;
    private final BatchesApi batchesApi;

    public BatchServiceImpl(AbstractAiClient zAiClient) {
        this.zAiClient = zAiClient;
        this.batchesApi = (BatchesApi)zAiClient.retrofit().create(BatchesApi.class);
    }

    @Override
    public BatchResponse createBatch(BatchCreateParams batchCreateParams) {
        this.validateCreateBatchParams(batchCreateParams);
        RequestSupplier supplier = this.batchesApi::batchesCreate;
        return this.zAiClient.executeRequest(batchCreateParams, supplier, BatchResponse.class);
    }

    @Override
    public BatchResponse retrieveBatch(BatchRequest request) {
        this.validateBatchRequest(request);
        RequestSupplier supplier = params -> this.batchesApi.batchesRetrieve(params.getBatchId());
        return this.zAiClient.executeRequest(request, supplier, BatchResponse.class);
    }

    @Override
    public BatchResponse retrieveBatch(String batchId) {
        this.validateBatchId(batchId);
        Object request = ((BatchRequest.BatchRequestBuilder)BatchRequest.builder().batchId(batchId)).build();
        return this.retrieveBatch((BatchRequest)request);
    }

    @Override
    public QueryBatchResponse listBatches(QueryBatchRequest queryBatchRequest) {
        this.validateQueryBatchRequest(queryBatchRequest);
        RequestSupplier supplier = params -> this.batchesApi.batchesList(params.getAfter(), params.getLimit());
        return this.zAiClient.executeRequest(queryBatchRequest, supplier, QueryBatchResponse.class);
    }

    @Override
    public BatchResponse cancelBatch(BatchRequest request) {
        this.validateBatchRequest(request);
        RequestSupplier supplier = params -> this.batchesApi.batchesCancel(params.getBatchId());
        return this.zAiClient.executeRequest(request, supplier, BatchResponse.class);
    }

    @Override
    public BatchResponse cancelBatch(String batchId) {
        this.validateBatchId(batchId);
        Object request = ((BatchRequest.BatchRequestBuilder)BatchRequest.builder().batchId(batchId)).build();
        return this.cancelBatch((BatchRequest)request);
    }

    private void validateCreateBatchParams(BatchCreateParams batchCreateParams) {
        if (batchCreateParams == null) {
            throw new IllegalArgumentException("BatchCreateParams cannot be null");
        }
        if (batchCreateParams.getEndpoint() == null || batchCreateParams.getEndpoint().trim().isEmpty()) {
            throw new IllegalArgumentException("Endpoint cannot be null or empty");
        }
        if (batchCreateParams.getInputFileId() == null || batchCreateParams.getInputFileId().trim().isEmpty()) {
            throw new IllegalArgumentException("Input file ID cannot be null or empty");
        }
        if (batchCreateParams.getCompletionWindow() == null || batchCreateParams.getCompletionWindow().trim().isEmpty()) {
            throw new IllegalArgumentException("Completion window cannot be null or empty");
        }
    }

    private void validateBatchRequest(BatchRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("BatchRequest cannot be null");
        }
        if (request.getBatchId() == null || request.getBatchId().trim().isEmpty()) {
            throw new IllegalArgumentException("Batch ID cannot be null or empty");
        }
    }

    private void validateBatchId(String batchId) {
        if (batchId == null || batchId.trim().isEmpty()) {
            throw new IllegalArgumentException("Batch ID cannot be null or empty");
        }
    }

    private void validateQueryBatchRequest(QueryBatchRequest queryBatchRequest) {
        if (queryBatchRequest == null) {
            throw new IllegalArgumentException("QueryBatchRequest cannot be null");
        }
    }
}

