/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi.service.audio;

import ai.z.openapi.AbstractAiClient;
import ai.z.openapi.api.audio.AudioApi;
import ai.z.openapi.service.audio.AudioCustomizationRequest;
import ai.z.openapi.service.audio.AudioCustomizationResponse;
import ai.z.openapi.service.audio.AudioService;
import ai.z.openapi.service.audio.AudioSpeechRequest;
import ai.z.openapi.service.audio.AudioSpeechResponse;
import ai.z.openapi.service.audio.AudioTranscriptionChunk;
import ai.z.openapi.service.audio.AudioTranscriptionRequest;
import ai.z.openapi.service.audio.AudioTranscriptionResponse;
import ai.z.openapi.service.deserialize.MessageDeserializeFactory;
import ai.z.openapi.utils.FlowableRequestSupplier;
import ai.z.openapi.utils.RequestSupplier;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.Single;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;

public class AudioServiceImpl
implements AudioService {
    private static final Logger log = LoggerFactory.getLogger(AudioServiceImpl.class);
    protected static final ObjectMapper mapper = MessageDeserializeFactory.defaultObjectMapper();
    private final AbstractAiClient zAiClient;
    private final AudioApi audioApi;

    public AudioServiceImpl(AbstractAiClient zAiClient) {
        this.zAiClient = zAiClient;
        this.audioApi = (AudioApi)zAiClient.retrofit().create(AudioApi.class);
    }

    @Override
    public AudioSpeechResponse createSpeech(AudioSpeechRequest request) {
        this.validateSpeechParams(request);
        RequestSupplier supplier = params -> {
            try {
                Single<ResponseBody> responseBody = this.audioApi.audioSpeech((AudioSpeechRequest)params);
                Path tempDirectory = Files.createTempFile("audio_speech" + UUID.randomUUID(), ".wav", new FileAttribute[0]);
                File file = tempDirectory.toFile();
                this.writeResponseBodyToFile((ResponseBody)responseBody.blockingGet(), file);
                return Single.just((Object)file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return this.zAiClient.executeRequest(request, supplier, AudioSpeechResponse.class);
    }

    @Override
    public AudioCustomizationResponse createCustomSpeech(AudioCustomizationRequest request) {
        this.validateCustomSpeechParams(request);
        RequestSupplier supplier = params -> {
            try {
                File voiceFile = params.getVoiceData();
                RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)voiceFile);
                MultipartBody.Part voiceData = MultipartBody.Part.createFormData((String)"voice_data", (String)voiceFile.getName(), (RequestBody)requestFile);
                HashMap<String, RequestBody> requestMap = new HashMap<String, RequestBody>();
                if (params.getInput() != null) {
                    requestMap.put("input", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)params.getInput()));
                }
                if (params.getModel() != null) {
                    requestMap.put("model", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)params.getModel()));
                }
                if (params.getVoiceText() != null) {
                    requestMap.put("voice_text", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)params.getVoiceText()));
                }
                if (params.getResponseFormat() != null) {
                    requestMap.put("response_format", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)params.getResponseFormat()));
                }
                if (params.getSensitiveWordCheck() != null) {
                    try {
                        String sensitiveWordCheckJson = mapper.writeValueAsString((Object)params.getSensitiveWordCheck());
                        requestMap.put("sensitive_word_check", RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)sensitiveWordCheckJson));
                    }
                    catch (Exception e) {
                        log.error("Error serializing sensitive_word_check: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
                if (params.getRequestId() != null) {
                    requestMap.put("request_id", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)params.getRequestId()));
                }
                if (params.getUserId() != null) {
                    requestMap.put("user_id", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)params.getUserId()));
                }
                Single<ResponseBody> responseBody = this.audioApi.audioCustomization(requestMap, voiceData);
                Path tempDirectory = Files.createTempFile("audio_customization" + UUID.randomUUID(), ".wav", new FileAttribute[0]);
                File file = tempDirectory.toFile();
                this.writeResponseBodyToFile((ResponseBody)responseBody.blockingGet(), file);
                return Single.just((Object)file);
            }
            catch (IOException e) {
                log.error("Error create custom speak: {}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
        };
        return this.zAiClient.executeRequest(request, supplier, AudioCustomizationResponse.class);
    }

    @Override
    public AudioTranscriptionResponse createTranscription(AudioTranscriptionRequest request) {
        this.validateTranscriptionParams(request);
        if (request.getStream().booleanValue()) {
            return this.createTranscriptionStream(request);
        }
        return this.createTranscriptionBlock(request);
    }

    private AudioTranscriptionResponse createTranscriptionStream(AudioTranscriptionRequest request) {
        FlowableRequestSupplier<AudioTranscriptionRequest, Call> supplier = params -> {
            try {
                File file = params.getFile();
                Tika tika = new Tika();
                String contentType = tika.detect(file);
                RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)contentType), (File)file);
                MultipartBody.Part fileData = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)requestFile);
                HashMap<String, RequestBody> requestMap = new HashMap<String, RequestBody>();
                if (params.getModel() != null) {
                    requestMap.put("model", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)params.getModel()));
                }
                if (params.getStream() != null) {
                    requestMap.put("stream", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)params.getStream().toString()));
                }
                if (params.getRequestId() != null) {
                    requestMap.put("request_id", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)params.getRequestId()));
                }
                if (params.getUserId() != null) {
                    requestMap.put("user_id", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)params.getUserId()));
                }
                return this.audioApi.audioTranscriptionStream(requestMap, fileData);
            }
            catch (IOException e) {
                log.error("Error create transcription: {}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
        };
        return this.zAiClient.biStreamRequest(request, supplier, AudioTranscriptionResponse.class, AudioTranscriptionChunk.class);
    }

    private AudioTranscriptionResponse createTranscriptionBlock(AudioTranscriptionRequest request) {
        RequestSupplier supplier = params -> {
            try {
                File file = params.getFile();
                Tika tika = new Tika();
                String contentType = tika.detect(file);
                RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)contentType), (File)file);
                MultipartBody.Part fileData = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)requestFile);
                HashMap<String, RequestBody> requestMap = new HashMap<String, RequestBody>();
                if (params.getModel() != null) {
                    requestMap.put("model", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)params.getModel()));
                }
                if (params.getStream() != null) {
                    requestMap.put("stream", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)params.getStream().toString()));
                }
                if (params.getRequestId() != null) {
                    requestMap.put("request_id", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)params.getRequestId()));
                }
                if (params.getUserId() != null) {
                    requestMap.put("user_id", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)params.getUserId()));
                }
                return this.audioApi.audioTranscription(requestMap, fileData);
            }
            catch (IOException e) {
                log.error("Error create transcription: {}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
        };
        return this.zAiClient.executeRequest(request, supplier, AudioTranscriptionResponse.class);
    }

    private void validateSpeechParams(AudioSpeechRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getModel() == null) {
            throw new IllegalArgumentException("request model cannot be null");
        }
        if (request.getInput() == null || request.getInput().trim().isEmpty()) {
            throw new IllegalArgumentException("request input cannot be null or empty");
        }
    }

    private void validateCustomSpeechParams(AudioCustomizationRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getModel() == null) {
            throw new IllegalArgumentException("request model cannot be null");
        }
        if (request.getInput() == null || request.getInput().trim().isEmpty()) {
            throw new IllegalArgumentException("request input cannot be null or empty");
        }
        if (request.getVoiceData() == null) {
            throw new IllegalArgumentException("request voice data cannot be null");
        }
    }

    private void validateTranscriptionParams(AudioTranscriptionRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getModel() == null) {
            throw new IllegalArgumentException("request model cannot be null");
        }
        if (request.getFile() == null) {
            throw new IllegalArgumentException("request file cannot be null");
        }
        if (!request.getFile().exists()) {
            throw new IllegalArgumentException("request file does not exist");
        }
    }

    private void writeResponseBodyToFile(ResponseBody body, File file) {
        try (InputStream inputStream = body.byteStream();
             OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            log.error("writeResponseBodyToFile error,msg:{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

