/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi;

import ai.z.openapi.AbstractAiClient;
import ai.z.openapi.core.config.ZaiConfig;
import ai.z.openapi.utils.StringUtils;

public class ZhipuAiClient
extends AbstractAiClient {
    public ZhipuAiClient(ZaiConfig config) {
        super(StringUtils.isEmpty(config.getBaseUrl()) ? ZhipuAiClient.createConfigWithDefaultUrl(config) : config, StringUtils.isEmpty(config.getBaseUrl()) ? "https://open.bigmodel.cn/api/paas/v4/" : config.getBaseUrl());
    }

    private static ZaiConfig createConfigWithDefaultUrl(ZaiConfig originalConfig) {
        ZaiConfig newConfig = new ZaiConfig();
        newConfig.setApiKey(originalConfig.getApiKey());
        newConfig.setBaseUrl("https://open.bigmodel.cn/api/paas/v4/");
        newConfig.setDisableTokenCache(originalConfig.isDisableTokenCache());
        newConfig.setConnectionPoolMaxIdleConnections(originalConfig.getConnectionPoolMaxIdleConnections());
        newConfig.setConnectionPoolKeepAliveDuration(originalConfig.getConnectionPoolKeepAliveDuration());
        newConfig.setConnectionPoolTimeUnit(originalConfig.getConnectionPoolTimeUnit());
        newConfig.setExpireMillis(originalConfig.getExpireMillis());
        newConfig.setRequestTimeOut(originalConfig.getRequestTimeOut());
        newConfig.setConnectTimeout(originalConfig.getConnectTimeout());
        newConfig.setReadTimeout(originalConfig.getReadTimeout());
        newConfig.setWriteTimeout(originalConfig.getWriteTimeout());
        newConfig.setTimeOutTimeUnit(originalConfig.getTimeOutTimeUnit());
        return newConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractAiClient.AbstractBuilder<ZhipuAiClient, Builder> {
        public Builder() {
        }

        public Builder(String apiKey) {
            super(apiKey);
        }

        public Builder(String baseUrl, String apiKey) {
            super(baseUrl, apiKey);
        }

        public Builder ofZHIPU() {
            this.config.setBaseUrl("https://open.bigmodel.cn/api/paas/v4/");
            return this;
        }

        public Builder ofZAI() {
            this.config.setBaseUrl("https://api.z.ai/api/paas/v4/");
            return this;
        }

        @Override
        public ZhipuAiClient build() {
            return new ZhipuAiClient(this.config);
        }
    }
}

