/*
 * Decompiled with CFR 0.152.
 */
package ai.z.openapi;

import ai.z.openapi.core.config.ZaiConfig;
import ai.z.openapi.core.model.BiFlowableClientResponse;
import ai.z.openapi.core.model.ClientRequest;
import ai.z.openapi.core.model.ClientResponse;
import ai.z.openapi.core.model.FlowableClientResponse;
import ai.z.openapi.service.AbstractClientBaseService;
import ai.z.openapi.service.agents.AgentService;
import ai.z.openapi.service.agents.AgentServiceImpl;
import ai.z.openapi.service.assistant.AssistantService;
import ai.z.openapi.service.assistant.AssistantServiceImpl;
import ai.z.openapi.service.audio.AudioService;
import ai.z.openapi.service.audio.AudioServiceImpl;
import ai.z.openapi.service.batches.BatchService;
import ai.z.openapi.service.batches.BatchServiceImpl;
import ai.z.openapi.service.chat.ChatService;
import ai.z.openapi.service.chat.ChatServiceImpl;
import ai.z.openapi.service.embedding.EmbeddingService;
import ai.z.openapi.service.embedding.EmbeddingServiceImpl;
import ai.z.openapi.service.file.FileService;
import ai.z.openapi.service.file.FileServiceImpl;
import ai.z.openapi.service.image.ImageService;
import ai.z.openapi.service.image.ImageServiceImpl;
import ai.z.openapi.service.model.ChatError;
import ai.z.openapi.service.model.ZAiHttpException;
import ai.z.openapi.service.videos.VideosService;
import ai.z.openapi.service.videos.VideosServiceImpl;
import ai.z.openapi.service.web_search.WebSearchService;
import ai.z.openapi.service.web_search.WebSearchServiceImpl;
import ai.z.openapi.utils.FlowableRequestSupplier;
import ai.z.openapi.utils.OkHttps;
import ai.z.openapi.utils.RequestSupplier;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public abstract class AbstractAiClient
extends AbstractClientBaseService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAiClient.class);
    protected final OkHttpClient httpClient;
    protected final Retrofit retrofit;
    private ChatService chatService;
    private AgentService agentService;
    private EmbeddingService embeddingService;
    private FileService fileService;
    private AudioService audioService;
    private ImageService imageService;
    private BatchService batchService;
    private WebSearchService webSearchService;
    private VideosService videosService;
    private AssistantService assistantService;

    protected AbstractAiClient(ZaiConfig config, String baseUrl) {
        logger.info("ZAI Init the client: {}, baseUrl: {}", (Object)this.getClass().getSimpleName(), (Object)baseUrl);
        this.httpClient = OkHttps.create(config);
        this.retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(this.httpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
    }

    public synchronized ChatService chat() {
        if (this.chatService == null) {
            this.chatService = new ChatServiceImpl(this);
        }
        return this.chatService;
    }

    public synchronized AgentService agents() {
        if (this.agentService == null) {
            this.agentService = new AgentServiceImpl(this);
        }
        return this.agentService;
    }

    public synchronized EmbeddingService embeddings() {
        if (this.embeddingService == null) {
            this.embeddingService = new EmbeddingServiceImpl(this);
        }
        return this.embeddingService;
    }

    public synchronized FileService files() {
        if (this.fileService == null) {
            this.fileService = new FileServiceImpl(this);
        }
        return this.fileService;
    }

    public synchronized AudioService audio() {
        if (this.audioService == null) {
            this.audioService = new AudioServiceImpl(this);
        }
        return this.audioService;
    }

    public synchronized ImageService images() {
        if (this.imageService == null) {
            this.imageService = new ImageServiceImpl(this);
        }
        return this.imageService;
    }

    public synchronized BatchService batches() {
        if (this.batchService == null) {
            this.batchService = new BatchServiceImpl(this);
        }
        return this.batchService;
    }

    public synchronized WebSearchService webSearch() {
        if (this.webSearchService == null) {
            this.webSearchService = new WebSearchServiceImpl(this);
        }
        return this.webSearchService;
    }

    public synchronized VideosService videos() {
        if (this.videosService == null) {
            this.videosService = new VideosServiceImpl(this);
        }
        return this.videosService;
    }

    public synchronized AssistantService assistants() {
        if (this.assistantService == null) {
            this.assistantService = new AssistantServiceImpl(this);
        }
        return this.assistantService;
    }

    public Retrofit retrofit() {
        return this.retrofit;
    }

    public void close() {
        if (this.httpClient != null) {
            this.httpClient.dispatcher().executorService().shutdown();
        }
    }

    @Override
    public <Data, Param, TReq extends ClientRequest<Param>, TResp extends ClientResponse<Data>> TResp executeRequest(TReq request, RequestSupplier<Param, Data> requestSupplier, Class<TResp> tRespClass) {
        Single<Data> apiCall = requestSupplier.get(request);
        TResp tResp = this.convertToClientResponse(tRespClass);
        try {
            Data response = AbstractAiClient.execute(apiCall);
            tResp.setCode(200);
            tResp.setMsg("Call Successful");
            tResp.setData(response);
            tResp.setSuccess(true);
        }
        catch (ZAiHttpException e) {
            logger.error("API request failed with call error", (Throwable)e);
            tResp.setCode(e.statusCode);
            tResp.setMsg("Call Failed");
            tResp.setSuccess(false);
            ChatError chatError = new ChatError();
            chatError.setCode(Integer.parseInt(e.code));
            chatError.setMessage(e.getMessage());
            tResp.setError(chatError);
        }
        return tResp;
    }

    @Override
    public <Data, F, Param, TReq extends ClientRequest<Param>, TResp extends BiFlowableClientResponse<Data, F>> TResp biStreamRequest(TReq request, FlowableRequestSupplier<Param, Call<ResponseBody>> requestSupplier, Class<TResp> tRespClass, Class<F> tStreamDataClass) {
        Call<ResponseBody> apiCall = requestSupplier.get(request);
        BiFlowableClientResponse tResp = (BiFlowableClientResponse)this.convertToClientResponse(tRespClass);
        try {
            Flowable<F> stream = this.stream(apiCall, tStreamDataClass);
            tResp.setCode(200);
            tResp.setMsg("Stream initialized successfully");
            tResp.setSuccess(true);
            tResp.setFlowable(stream);
        }
        catch (ZAiHttpException e) {
            this.handleStreamError(tResp, e);
        }
        return (TResp)tResp;
    }

    private void handleStreamError(ClientResponse<?> response, ZAiHttpException e) {
        logger.error("Streaming API request failed with business error", (Throwable)e);
        response.setCode(e.statusCode);
        response.setMsg("Business error");
        response.setSuccess(false);
        ChatError chatError = new ChatError();
        chatError.setCode(Integer.parseInt(e.code));
        chatError.setMessage(e.getMessage());
        response.setError(chatError);
    }

    public <Data, Param, TReq extends ClientRequest<Param>, TResp extends FlowableClientResponse<Data>> TResp streamRequest(TReq request, FlowableRequestSupplier<Param, Call<ResponseBody>> requestSupplier, Class<TResp> tRespClass, Class<Data> tDataClass) {
        Call<ResponseBody> apiCall = requestSupplier.get(request);
        FlowableClientResponse tResp = (FlowableClientResponse)this.convertToClientResponse(tRespClass);
        try {
            Flowable<Data> stream = this.stream(apiCall, tDataClass);
            tResp.setCode(200);
            tResp.setMsg("Stream initialized successfully");
            tResp.setSuccess(true);
            tResp.setFlowable(stream);
        }
        catch (ZAiHttpException e) {
            this.handleStreamError(tResp, e);
        }
        return (TResp)tResp;
    }

    private <Data, TResp extends ClientResponse<Data>> TResp convertToClientResponse(Class<TResp> tRespClass) {
        try {
            return (TResp)((ClientResponse)tRespClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to create response object of type: " + tRespClass.getSimpleName(), e);
        }
    }

    public static abstract class AbstractBuilder<T extends AbstractAiClient, B extends AbstractBuilder<T, B>> {
        protected final ZaiConfig config = new ZaiConfig();

        public AbstractBuilder() {
        }

        public AbstractBuilder(String apiKey) {
            if (apiKey == null || apiKey.trim().isEmpty()) {
                throw new IllegalArgumentException("API key cannot be null or empty");
            }
            this.config.setApiKey(apiKey);
        }

        public AbstractBuilder(String baseUrl, String apiKey) {
            if (baseUrl == null || baseUrl.trim().isEmpty()) {
                throw new IllegalArgumentException("Base URL cannot be null or empty");
            }
            if (apiKey == null || apiKey.trim().isEmpty()) {
                throw new IllegalArgumentException("API secret key cannot be null or empty");
            }
            this.config.setBaseUrl(baseUrl);
            this.config.setApiKey(apiKey);
        }

        protected B self() {
            return (B)this;
        }

        public B baseUrl(String baseUrl) {
            if (baseUrl == null || baseUrl.trim().isEmpty()) {
                throw new IllegalArgumentException("Base URL cannot be null or empty");
            }
            this.config.setBaseUrl(baseUrl);
            return this.self();
        }

        public B apiKey(String apiKey) {
            if (apiKey == null || apiKey.trim().isEmpty()) {
                throw new IllegalArgumentException("API secret key cannot be null or empty");
            }
            this.config.setApiKey(apiKey);
            return this.self();
        }

        public B customHeaders(Map<String, String> customHeaders) {
            if (customHeaders == null || customHeaders.isEmpty()) {
                throw new IllegalArgumentException("Custom headers cannot be null or empty");
            }
            this.config.setCustomHeaders(customHeaders);
            return this.self();
        }

        public B disableTokenCache() {
            this.config.setDisableTokenCache(true);
            return this.self();
        }

        public B enableTokenCache() {
            this.config.setDisableTokenCache(false);
            return this.self();
        }

        public B connectionPool(int maxIdleConnections, long keepAliveDuration, TimeUnit timeUnit) {
            this.config.setConnectionPoolMaxIdleConnections(maxIdleConnections);
            this.config.setConnectionPoolKeepAliveDuration(keepAliveDuration);
            this.config.setConnectionPoolTimeUnit(timeUnit);
            return this.self();
        }

        public B tokenExpire(int expireMillis) {
            this.config.setExpireMillis(expireMillis);
            return this.self();
        }

        public B networkConfig(int requestTimeOut, int connectTimeout, int readTimeout, int writeTimeout, TimeUnit timeUnit) {
            this.config.setRequestTimeOut(requestTimeOut);
            this.config.setConnectTimeout(connectTimeout);
            this.config.setReadTimeout(readTimeout);
            this.config.setWriteTimeout(writeTimeout);
            this.config.setTimeOutTimeUnit(timeUnit);
            return this.self();
        }

        public abstract T build();
    }
}

