/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.load;

import ai.tripl.arc.api.API;
import ai.tripl.arc.load.MongoDBLoad;
import ai.tripl.arc.load.MongoDBLoadStage;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ListenerUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import com.mongodb.spark.config.ReadConfig;
import com.mongodb.spark.config.ReadConfig$;
import java.io.Serializable;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple10;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MongoDBLoadStage$
implements scala.Serializable {
    public static MongoDBLoadStage$ MODULE$;

    static {
        new MongoDBLoadStage$();
    }

    public Option<Dataset<Row>> execute(MongoDBLoadStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Dataset df = spark.table(stage.inputView());
        if (arcContext.isStreaming()) {
            throw new DetailException(stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        SparkListener listener = ListenerUtils$.MODULE$.addStageCompletedListener(stage.stageDetail(), spark, logger);
        try {
            List<String> list = stage.partitionBy();
            if (Nil$.MODULE$.equals(list)) {
                Option<Object> option = stage.numPartitions();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int n = BoxesRunTime.unboxToInt((Object)some.value());
                    df.repartition(n).write().mode(stage.saveMode()).format("com.mongodb.spark.sql").options(((ReadConfig)ReadConfig$.MODULE$.apply(stage.options())).asOptions()).save();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    df.write().mode(stage.saveMode()).format("com.mongodb.spark.sql").options(((ReadConfig)ReadConfig$.MODULE$.apply(stage.options())).asOptions()).save();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(option);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> df.apply(col), List$.MODULE$.canBuildFrom());
                Option<Object> option = stage.numPartitions();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int n = BoxesRunTime.unboxToInt((Object)some.value());
                    df.repartition(n, (Seq)partitionCols).write().mode(stage.saveMode()).format("com.mongodb.spark.sql").options(((ReadConfig)ReadConfig$.MODULE$.apply(stage.options())).asOptions()).save();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    df.repartition((Seq)partitionCols).write().partitionBy(list).mode(stage.saveMode()).format("com.mongodb.spark.sql").options(((ReadConfig)ReadConfig$.MODULE$.apply(stage.options())).asOptions()).save();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(option);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        spark.sparkContext().removeSparkListener((SparkListenerInterface)listener);
        return Option$.MODULE$.apply((Object)df);
    }

    public MongoDBLoadStage apply(MongoDBLoad plugin, Option<String> id, String name, Option<String> description, String inputView, scala.collection.immutable.Map<String, String> options, List<String> partitionBy, Option<Object> numPartitions, SaveMode saveMode, scala.collection.immutable.Map<String, String> params) {
        return new MongoDBLoadStage(plugin, id, name, description, inputView, options, partitionBy, numPartitions, saveMode, params);
    }

    public Option<Tuple10<MongoDBLoad, Option<String>, String, Option<String>, String, scala.collection.immutable.Map<String, String>, List<String>, Option<Object>, SaveMode, scala.collection.immutable.Map<String, String>>> unapply(MongoDBLoadStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple10((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputView(), x$0.options(), x$0.partitionBy(), x$0.numPartitions(), (Object)x$0.saveMode(), x$0.params()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MongoDBLoadStage$() {
        MODULE$ = this;
    }
}

