/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.test.api.score.stream;

import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintFactory;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.api.score.stream.ConstraintStreamImplType;
import ai.timefold.solver.core.config.score.director.ScoreDirectorFactoryConfig;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.test.api.score.stream.MultiConstraintVerification;
import ai.timefold.solver.test.api.score.stream.SingleConstraintVerification;
import ai.timefold.solver.test.impl.score.stream.DefaultConstraintVerifier;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.jspecify.annotations.NonNull;

public interface ConstraintVerifier<ConstraintProvider_ extends ConstraintProvider, Solution_> {
    public static <ConstraintProvider_ extends ConstraintProvider, Solution_> @NonNull ConstraintVerifier<ConstraintProvider_, Solution_> build(@NonNull ConstraintProvider_ constraintProvider, @NonNull Class<Solution_> planningSolutionClass, Class<?> ... entityClasses) {
        Objects.requireNonNull(constraintProvider);
        SolutionDescriptor solutionDescriptor = SolutionDescriptor.buildSolutionDescriptor(Objects.requireNonNull(planningSolutionClass), (Class[])entityClasses);
        return new DefaultConstraintVerifier(constraintProvider, solutionDescriptor);
    }

    public static <ConstraintProvider_ extends ConstraintProvider, Solution_> @NonNull ConstraintVerifier<ConstraintProvider_, Solution_> create(@NonNull SolverConfig solverConfig) {
        SolverConfig nonNullSolverConfig = Objects.requireNonNull(solverConfig);
        List entityClassList = Objects.requireNonNull(nonNullSolverConfig.getEntityClassList());
        SolutionDescriptor solutionDescriptor = SolutionDescriptor.buildSolutionDescriptor((Set)nonNullSolverConfig.getEnablePreviewFeatureSet(), (Class)Objects.requireNonNull(nonNullSolverConfig.getSolutionClass()), (Class[])entityClassList.toArray(new Class[0]));
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = Objects.requireNonNull(nonNullSolverConfig.getScoreDirectorFactoryConfig());
        Class constraintProviderClass = Objects.requireNonNull(scoreDirectorFactoryConfig.getConstraintProviderClass());
        ConstraintProvider constraintProvider = (ConstraintProvider)ConfigUtils.newInstance(() -> ((ScoreDirectorFactoryConfig)scoreDirectorFactoryConfig).toString(), (String)"constraintProviderClass", (Class)constraintProviderClass);
        ConfigUtils.applyCustomProperties((Object)constraintProvider, (String)"constraintProviderClass", (Map)scoreDirectorFactoryConfig.getConstraintProviderCustomProperties(), (String)"constraintProviderCustomProperties");
        return new DefaultConstraintVerifier(constraintProvider, solutionDescriptor);
    }

    @Deprecated(forRemoval=true, since="1.16.0")
    default public @NonNull ConstraintVerifier<ConstraintProvider_, Solution_> withConstraintStreamImplType(@NonNull ConstraintStreamImplType constraintStreamImplType) {
        return this;
    }

    public @NonNull SingleConstraintVerification<Solution_> verifyThat(@NonNull BiFunction<ConstraintProvider_, ConstraintFactory, Constraint> var1);

    public @NonNull MultiConstraintVerification<Solution_> verifyThat();
}

