/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.test.impl.score.stream;

import ai.timefold.solver.constraint.streams.common.AbstractConstraint;
import ai.timefold.solver.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.constraint.streams.common.ScoreImpactType;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.impl.score.DefaultScoreExplanation;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.util.Pair;
import ai.timefold.solver.test.api.score.stream.SingleConstraintAssertion;
import ai.timefold.solver.test.impl.score.stream.NumberEqualityUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public final class DefaultSingleConstraintAssertion<Solution_, Score_ extends Score<Score_>>
implements SingleConstraintAssertion {
    private final AbstractConstraint<Solution_, ?, ?> constraint;
    private final ScoreDefinition<Score_> scoreDefinition;
    private final Score_ score;
    private final Collection<ConstraintMatchTotal<Score_>> constraintMatchTotalCollection;
    private final Collection<Indictment<Score_>> indictmentCollection;

    DefaultSingleConstraintAssertion(AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory, Score_ score, Map<String, ConstraintMatchTotal<Score_>> constraintMatchTotalMap, Map<Object, Indictment<Score_>> indictmentMap) {
        this.constraint = (AbstractConstraint)scoreDirectorFactory.getConstraints()[0];
        this.scoreDefinition = scoreDirectorFactory.getScoreDefinition();
        this.score = (Score)Objects.requireNonNull(score);
        this.constraintMatchTotalCollection = new ArrayList<ConstraintMatchTotal<Score_>>(Objects.requireNonNull(constraintMatchTotalMap).values());
        this.indictmentCollection = new ArrayList<Indictment<Score_>>(Objects.requireNonNull(indictmentMap).values());
    }

    @Override
    public void penalizesBy(int matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void penalizesBy(long matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void penalizesBy(BigDecimal matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void penalizes(long times, String message) {
        this.assertMatchCount(ScoreImpactType.PENALTY, times, message);
    }

    @Override
    public void penalizes(String message) {
        this.assertMatch(ScoreImpactType.PENALTY, message);
    }

    @Override
    public void rewardsWith(int matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    @Override
    public void rewardsWith(long matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    @Override
    public void rewardsWith(BigDecimal matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    @Override
    public void rewards(long times, String message) {
        this.assertMatchCount(ScoreImpactType.REWARD, times, message);
    }

    @Override
    public void rewards(String message) {
        this.assertMatch(ScoreImpactType.REWARD, message);
    }

    private void validateMatchWeighTotal(Number matchWeightTotal) {
        if (matchWeightTotal.doubleValue() < 0.0) {
            throw new IllegalArgumentException("The matchWeightTotal (" + matchWeightTotal + ") must be positive.");
        }
    }

    private void assertImpact(ScoreImpactType scoreImpactType, Number matchWeightTotal, String message) {
        BiPredicate<Number, Number> equalityPredicate = NumberEqualityUtil.getEqualityPredicate(this.scoreDefinition, matchWeightTotal);
        Pair<Number, Number> deducedImpacts = this.deduceImpact();
        Number impact = (Number)deducedImpacts.getKey();
        ScoreImpactType actualScoreImpactType = this.constraint.getScoreImpactType();
        if (actualScoreImpactType == ScoreImpactType.MIXED) {
            switch (scoreImpactType) {
                case REWARD: {
                    Number negatedImpact = (Number)deducedImpacts.getValue();
                    if (!equalityPredicate.test(matchWeightTotal, negatedImpact)) break;
                    return;
                }
                case PENALTY: {
                    if (!equalityPredicate.test(matchWeightTotal, impact)) break;
                    return;
                }
            }
        } else if (actualScoreImpactType == scoreImpactType && equalityPredicate.test(matchWeightTotal, impact)) {
            return;
        }
        String constraintId = this.constraint.getConstraintId();
        String assertionMessage = this.buildAssertionErrorMessage(scoreImpactType, matchWeightTotal, actualScoreImpactType, impact, constraintId, message);
        throw new AssertionError((Object)assertionMessage);
    }

    private Pair<Number, Number> deduceImpact() {
        Score zeroScore = this.scoreDefinition.getZeroScore();
        Number zero = zeroScore.toLevelNumbers()[0];
        if (this.constraintMatchTotalCollection.isEmpty()) {
            return Pair.of((Object)zero, (Object)zero);
        }
        Score totalMatchWeightedScore = this.constraintMatchTotalCollection.stream().map(matchScore -> this.scoreDefinition.divideBySanitizedDivisor(matchScore.getScore(), matchScore.getConstraintWeight())).reduce(zeroScore, Score::add);
        Number deducedImpact = this.retrieveImpact(totalMatchWeightedScore, zero);
        if (deducedImpact.equals(zero)) {
            return Pair.of((Object)zero, (Object)zero);
        }
        Number negatedDeducedImpact = this.retrieveImpact(totalMatchWeightedScore.negate(), zero);
        return Pair.of((Object)deducedImpact, (Object)negatedDeducedImpact);
    }

    private Number retrieveImpact(Score_ score, Number zero) {
        Object[] levelNumbers = score.toLevelNumbers();
        List impacts = Arrays.stream(levelNumbers).distinct().filter(matchWeight -> !Objects.equals(matchWeight, zero)).collect(Collectors.toList());
        switch (impacts.size()) {
            case 0: {
                return zero;
            }
            case 1: {
                return (Number)impacts.get(0);
            }
        }
        throw new IllegalStateException("Impossible state: expecting at most one match weight (" + impacts.size() + ") in matchWeightedScore level numbers (" + Arrays.toString(levelNumbers) + ").");
    }

    private void assertMatchCount(ScoreImpactType scoreImpactType, long expectedMatchCount, String message) {
        long actualMatchCount = this.determineMatchCount(scoreImpactType);
        if (actualMatchCount == expectedMatchCount) {
            return;
        }
        String constraintId = this.constraint.getConstraintId();
        String assertionMessage = this.buildAssertionErrorMessage(scoreImpactType, expectedMatchCount, actualMatchCount, constraintId, message);
        throw new AssertionError((Object)assertionMessage);
    }

    private void assertMatch(ScoreImpactType scoreImpactType, String message) {
        if (this.determineMatchCount(scoreImpactType) > 0L) {
            return;
        }
        String constraintId = this.constraint.getConstraintId();
        String assertionMessage = this.buildAssertionErrorMessage(scoreImpactType, constraintId, message);
        throw new AssertionError((Object)assertionMessage);
    }

    private long determineMatchCount(ScoreImpactType scoreImpactType) {
        if (this.constraintMatchTotalCollection.isEmpty()) {
            return 0L;
        }
        ScoreImpactType actualImpactType = this.constraint.getScoreImpactType();
        if (actualImpactType != scoreImpactType && actualImpactType != ScoreImpactType.MIXED) {
            return 0L;
        }
        Score zeroScore = this.scoreDefinition.getZeroScore();
        return this.constraintMatchTotalCollection.stream().mapToLong(constraintMatchTotal -> {
            if (actualImpactType == ScoreImpactType.MIXED) {
                boolean isImpactNegative;
                boolean isImpactPositive = constraintMatchTotal.getScore().compareTo((Object)zeroScore) > 0;
                boolean bl = isImpactNegative = constraintMatchTotal.getScore().compareTo((Object)zeroScore) < 0;
                if (isImpactPositive && scoreImpactType == ScoreImpactType.PENALTY) {
                    return constraintMatchTotal.getConstraintMatchSet().size();
                }
                if (isImpactNegative && scoreImpactType == ScoreImpactType.REWARD) {
                    return constraintMatchTotal.getConstraintMatchSet().size();
                }
                return 0L;
            }
            return constraintMatchTotal.getConstraintMatchSet().size();
        }).sum();
    }

    private String buildAssertionErrorMessage(ScoreImpactType expectedImpactType, Number expectedImpact, ScoreImpactType actualImpactType, Number actualImpact, String constraintId, String message) {
        String expectation = message != null ? message : "Broken expectation.";
        String preformattedMessage = "%s%n%18s: %s%n%18s: %s (%s)%n%18s: %s (%s)%n%n  %s";
        String expectedImpactLabel = "Expected " + this.getImpactTypeLabel(expectedImpactType);
        String actualImpactLabel = "Actual " + this.getImpactTypeLabel(actualImpactType);
        return String.format(preformattedMessage, expectation, "Constraint", constraintId, expectedImpactLabel, expectedImpact, expectedImpact.getClass(), actualImpactLabel, actualImpact, actualImpact.getClass(), DefaultScoreExplanation.explainScore(this.score, this.constraintMatchTotalCollection, this.indictmentCollection));
    }

    private String buildAssertionErrorMessage(ScoreImpactType impactType, long expectedTimes, long actualTimes, String constraintId, String message) {
        String expectation = message != null ? message : "Broken expectation.";
        String preformattedMessage = "%s%n%18s: %s%n%18s: %s time(s)%n%18s: %s time(s)%n%n  %s";
        String expectedImpactLabel = "Expected " + this.getImpactTypeLabel(impactType);
        String actualImpactLabel = "Actual " + this.getImpactTypeLabel(impactType);
        return String.format(preformattedMessage, expectation, "Constraint", constraintId, expectedImpactLabel, expectedTimes, actualImpactLabel, actualTimes, DefaultScoreExplanation.explainScore(this.score, this.constraintMatchTotalCollection, this.indictmentCollection));
    }

    private String buildAssertionErrorMessage(ScoreImpactType impactType, String constraintId, String message) {
        String expectation = message != null ? message : "Broken expectation.";
        String preformattedMessage = "%s%n%18s: %s%n%18s but there was none.%n%n  %s";
        String expectedImpactLabel = "Expected " + this.getImpactTypeLabel(impactType);
        return String.format(preformattedMessage, expectation, "Constraint", constraintId, expectedImpactLabel, DefaultScoreExplanation.explainScore(this.score, this.constraintMatchTotalCollection, this.indictmentCollection));
    }

    private String getImpactTypeLabel(ScoreImpactType scoreImpactType) {
        if (scoreImpactType == ScoreImpactType.PENALTY) {
            return "penalty";
        }
        if (scoreImpactType == ScoreImpactType.REWARD) {
            return "reward";
        }
        return "impact";
    }
}

